/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.client.renderer;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftSpells;
import electroblob.wizardry.data.IVariable;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Transportation;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.Location;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class RenderTransportationPortalUI {
    private static final ResourceLocation TEXTURE = new ResourceLocation("ebwizardry", "textures/gui/transportation_marker.png");
    private static final ResourceLocation TEXTURE_OTHER_DIM = new ResourceLocation("ancientspellcraft", "textures/gui/transportation_marker_otherdim.png");

    @SubscribeEvent
    public static void onRenderWorldLastEvent(RenderWorldLastEvent event) {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O != 0) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = player.func_184614_ca();
        if (!(stack.func_77973_b() instanceof ISpellCastingItem) && !((stack = player.func_184592_cb()).func_77973_b() instanceof ISpellCastingItem)) {
            return;
        }
        if (((ISpellCastingItem)stack.func_77973_b()).getCurrentSpell(stack) == AncientSpellcraftSpells.transportation_portal && ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)WizardryItems.charm_transportation)) {
            WizardData data = WizardData.get((EntityPlayer)player);
            if (data == null) {
                return;
            }
            List locations = (List)data.getVariable((IVariable)Transportation.LOCATIONS_KEY);
            if (locations == null) {
                return;
            }
            GlStateManager.func_179094_E();
            Vec3d origin = player.func_174824_e(event.getPartialTicks());
            GlStateManager.func_179137_b((double)0.0, (double)(origin.field_72448_b - Minecraft.func_71410_x().func_175598_ae().field_78731_m), (double)0.0);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            Location target = Transportation.getLocationAimedAt((EntityPlayer)player, (List)locations, (float)event.getPartialTicks());
            boolean rift_active = ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)AncientSpellcraftItems.charm_rift_bottle);
            for (Location location : locations) {
                String label;
                boolean otherdim = false;
                if (location.dimension != player.field_71093_bK) {
                    otherdim = true;
                    if (!rift_active) continue;
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                GlStateManager.func_179112_b((int)770, (int)771);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (otherdim) {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE_OTHER_DIM);
                } else {
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE);
                }
                buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                Vec3d position = GeometryUtils.getCentre((BlockPos)location.pos).func_178788_d(origin);
                double distance = position.func_72433_c();
                double distanceCap = Minecraft.func_71410_x().field_71474_y.field_151451_c * 16 - 8;
                double displayDist = distance > distanceCap ? distanceCap : distance;
                double factor = displayDist / distance;
                GlStateManager.func_179137_b((double)(position.field_72450_a * factor), (double)(position.field_72448_b * factor), (double)(position.field_72449_c * factor));
                GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)Minecraft.func_71410_x().func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                double angle = Transportation.getLookDeviationAngle((EntityPlayer)player, (BlockPos)location.pos, (float)event.getPartialTicks());
                double iconSize = Transportation.getIconSize((double)distance);
                double proximityFactor = Math.max(0.0, Math.pow(1.0 - angle / iconSize * angle / iconSize, 3.0));
                iconSize *= 1.0 + 0.3 * proximityFactor;
                float f = location == target ? 1.0f : 0.5f;
                buffer.func_181662_b(-(iconSize *= displayDist), iconSize, 0.0).func_187315_a(0.0, 0.0).func_181666_a(f, 1.0f, f, f).func_181675_d();
                buffer.func_181662_b(iconSize, iconSize, 0.0).func_187315_a(1.0, 0.0).func_181666_a(f, 1.0f, f, f).func_181675_d();
                buffer.func_181662_b(iconSize, -iconSize, 0.0).func_187315_a(1.0, 1.0).func_181666_a(f, 1.0f, f, f).func_181675_d();
                buffer.func_181662_b(-iconSize, -iconSize, 0.0).func_187315_a(0.0, 1.0).func_181666_a(f, 1.0f, f, f).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
                if (location != target) continue;
                if (otherdim) {
                    String name = I18n.func_135052_a((String)("misc.ancientspellcraft:" + DimensionType.func_186069_a((int)location.dimension).func_186065_b()), (Object[])new Object[0]);
                    label = name + " - " + location.pos.func_177958_n() + ", " + location.pos.func_177956_o() + ", " + location.pos.func_177952_p();
                } else {
                    label = location.pos.func_177958_n() + ", " + location.pos.func_177956_o() + ", " + location.pos.func_177952_p();
                }
                RenderTransportationPortalUI.drawLabel(Minecraft.func_71410_x().field_71466_p, label, (float)(position.field_72450_a * factor), (float)(position.field_72448_b * factor + iconSize * 1.5), (float)(position.field_72449_c * factor), (float)displayDist * 0.2f, 0, Minecraft.func_71410_x().func_175598_ae().field_78735_i, Minecraft.func_71410_x().func_175598_ae().field_78732_j);
            }
            GlStateManager.func_179084_k();
            GlStateManager.func_179098_w();
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
        }
    }

    private static void drawLabel(FontRenderer fontRendererIn, String str, float x, float y, float z, float scale, int verticalShift, float viewerYaw, float viewerPitch) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-viewerYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)viewerPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-0.025f, (float)-0.025f, (float)0.025f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int i = fontRendererIn.func_78256_a(str) / 2;
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)(-i - 1), (double)(-1 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b((double)(-i - 1), (double)(8 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b((double)(i + 1), (double)(8 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        bufferbuilder.func_181662_b((double)(i + 1), (double)(-1 + verticalShift), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        fontRendererIn.func_78276_b(str, -fontRendererIn.func_78256_a(str) / 2, verticalShift, 8847205);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        fontRendererIn.func_78276_b(str, -fontRendererIn.func_78256_a(str) / 2, verticalShift, 8847205);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }
}

