/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.data;

import com.google.common.collect.Maps;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftSpells;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;

public enum SpellComponentList {
    ANTIMAGIC_FIELD(AncientSpellcraftSpells.antimagic_field, new ItemStack(Items.field_151045_i), new ItemStack(WizardryItems.grand_crystal)),
    ARCANE_AEGIS(AncientSpellcraftSpells.arcane_aegis, new ItemStack(WizardryItems.astral_diamond), new ItemStack(WizardryItems.grand_crystal), new ItemStack(Items.field_151153_ao)),
    ARCANE_AUGMENTATION(AncientSpellcraftSpells.arcane_augmentation, new ItemStack(WizardryItems.grand_crystal), new ItemStack(WizardryItems.blast_upgrade)),
    ARCANE_BEAM(AncientSpellcraftSpells.arcane_beam, new ItemStack(WizardryItems.grand_crystal), new ItemStack(Items.field_151128_bU)),
    ARCANE_MAGNETISM(AncientSpellcraftSpells.arcane_magnetism, new ItemStack(Items.field_151061_bv), new ItemStack(Item.func_150898_a((Block)Blocks.field_150429_aA))),
    ASPECT_HUNTER(AncientSpellcraftSpells.aspect_hunter, new ItemStack((Item)Items.field_151031_f), new ItemStack((Item)Items.field_151024_Q), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)PotionTypes.field_185223_F)),
    MIGHT_AND_MAGIC(AncientSpellcraftSpells.might_and_magic, new ItemStack(WizardryItems.medium_mana_flask), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)PotionTypes.field_185250_v)),
    BLOCKWEAVING(AncientSpellcraftSpells.blockweaving, new ItemStack(WizardryBlocks.crystal_block, 1, 0), new ItemStack(Items.field_151005_D)),
    BUBBLE_HEAD(AncientSpellcraftSpells.bubble_head, new ItemStack(Item.func_150898_a((Block)Blocks.field_150359_w)), new ItemStack(Items.field_151131_as), new ItemStack(Items.field_151114_aO)),
    BULWARK(AncientSpellcraftSpells.bulwark, new ItemStack(WizardryItems.magic_crystal, 1, 5), new ItemStack(Items.field_185159_cQ), new ItemStack(WizardryItems.grand_crystal)),
    CHANNEL_POWER(AncientSpellcraftSpells.channel_power, new ItemStack(WizardryItems.astral_diamond), new ItemStack(WizardryItems.astral_diamond), new ItemStack(WizardryItems.astral_diamond)),
    CHANNEL_EFFECT(AncientSpellcraftSpells.channel_effect, new ItemStack(WizardryItems.grand_crystal)),
    CONTINUITY_CHANT(AncientSpellcraftSpells.continuity_charm, new ItemStack(WizardryItems.grand_crystal), new ItemStack(WizardryItems.duration_upgrade)),
    CRYSTAL_MINE(AncientSpellcraftSpells.crystal_mine, new ItemStack(Item.func_150898_a((Block)WizardryBlocks.crystal_block)), new ItemStack(Item.func_150898_a((Block)Blocks.field_150335_W))),
    CONDUIT(AncientSpellcraftSpells.conduit, new ItemStack(WizardryItems.large_mana_flask), new ItemStack(Item.func_150898_a((Block)WizardryBlocks.receptacle)), new ItemStack(WizardryItems.grand_crystal)),
    COVENANT(AncientSpellcraftSpells.covenant, new ItemStack(WizardryItems.master_wand), new ItemStack(Item.func_150898_a((Block)Blocks.field_150484_ah)), new ItemStack(WizardryItems.astral_diamond)),
    DISPEL_LESSER_MAGIC(AncientSpellcraftSpells.dispel_lesser_magic, new ItemStack(Items.field_151069_bo), new ItemStack(WizardryItems.grand_crystal), new ItemStack(WizardryItems.siphon_upgrade)),
    DISPEL_GREATER_MAGIC(AncientSpellcraftSpells.dispel_greater_magic, new ItemStack(Items.field_151069_bo), new ItemStack(WizardryItems.astral_diamond), new ItemStack(WizardryItems.siphon_upgrade)),
    EAGLE_EYE(AncientSpellcraftSpells.eagle_eye, new ItemStack(Items.field_151061_bv), new ItemStack(WizardryItems.magic_crystal), new ItemStack(Items.field_151008_G)),
    FARSIGHT(AncientSpellcraftSpells.farsight, new ItemStack(Items.field_151061_bv), new ItemStack(WizardryItems.magic_crystal), new ItemStack(Item.func_150898_a((Block)Blocks.field_150410_aZ))),
    FORCEFEND(AncientSpellcraftSpells.forcefend, new ItemStack(WizardryItems.astral_diamond), new ItemStack(Items.field_151153_ao), new ItemStack(Items.field_185159_cQ)),
    INTENSIFYING_FOCUS(AncientSpellcraftSpells.intensifying_focus, new ItemStack(WizardryItems.grand_crystal), new ItemStack(WizardryItems.attunement_upgrade)),
    MAGELIGHT(AncientSpellcraftSpells.magelight, new ItemStack(Item.func_150898_a((Block)Blocks.field_150426_aN)), new ItemStack(Item.func_150898_a((Block)Blocks.field_150478_aa)), new ItemStack(Items.field_151059_bz)),
    MANA_FLARE(AncientSpellcraftSpells.mana_flare, new ItemStack(WizardryItems.magic_wand), new ItemStack(WizardryItems.grand_crystal)),
    MANA_VORTEX(AncientSpellcraftSpells.mana_vortex, new ItemStack(Item.func_150898_a((Block)WizardryBlocks.receptacle)), new ItemStack(WizardryItems.grand_crystal), new ItemStack(Items.field_151065_br)),
    PROJECTILE_WARD(AncientSpellcraftSpells.projectile_ward, new ItemStack((Item)Items.field_151027_R), new ItemStack(Items.field_185159_cQ), new ItemStack(Items.field_151032_g)),
    PRISMATIC_SPRAY(AncientSpellcraftSpells.prismatic_spray, new ItemStack(Item.func_150898_a((Block)Blocks.field_150410_aZ)), new ItemStack(WizardryItems.grand_crystal), new ItemStack(WizardryItems.astral_diamond)),
    SILENCING_SIGIL(AncientSpellcraftSpells.silencing_sigil, new ItemStack(Blocks.field_150323_B), new ItemStack(Item.func_150898_a((Block)Blocks.field_150451_bX))),
    SKULL_SENTINEL(AncientSpellcraftSpells.skull_sentinel, new ItemStack(Items.field_151144_bL), new ItemStack(WizardryItems.grand_crystal)),
    WATER_WALKING(AncientSpellcraftSpells.water_walking, new ItemStack(Items.field_151131_as), new ItemStack((Item)Items.field_151175_af), new ItemStack(WizardryItems.grand_crystal)),
    ESSENCE_EXTRACTION(AncientSpellcraftSpells.essence_extraction, new ItemStack(WizardryItems.large_mana_flask), new ItemStack(Item.func_150898_a((Block)WizardryBlocks.receptacle)), new ItemStack(WizardryItems.grand_crystal)),
    CONTINGENCY_FIRE(AncientSpellcraftSpells.contingency_fire, new ItemStack(WizardryItems.blank_scroll), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)PotionTypes.field_185241_m), new ItemStack(Item.func_150898_a((Block)WizardryBlocks.crystal_block))),
    CONTINGENCY_FALL(AncientSpellcraftSpells.contingency_fire, new ItemStack(WizardryItems.blank_scroll), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)PotionTypes.field_185244_p), new ItemStack(Item.func_150898_a((Block)WizardryBlocks.crystal_block))),
    CONTINGENCY_DAMAGE(AncientSpellcraftSpells.contingency_damage, new ItemStack(WizardryItems.blank_scroll), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)PotionTypes.field_185252_x), new ItemStack(Item.func_150898_a((Block)WizardryBlocks.crystal_block))),
    CONTINGENCY_CRITICAL_HEALTH(AncientSpellcraftSpells.contingency_critical_health, new ItemStack(WizardryItems.blank_scroll), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)PotionTypes.field_185251_w), new ItemStack(Item.func_150898_a((Block)WizardryBlocks.crystal_block))),
    CONTINGENCY_DEATH(AncientSpellcraftSpells.contingency_death, new ItemStack(WizardryItems.blank_scroll), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)PotionTypes.field_185253_y), new ItemStack(Item.func_150898_a((Block)WizardryBlocks.crystal_block))),
    CONTINGENCY_DROWNING(AncientSpellcraftSpells.contingency_drowning, new ItemStack(WizardryItems.blank_scroll), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)PotionTypes.field_185248_t), new ItemStack(Item.func_150898_a((Block)WizardryBlocks.crystal_block))),
    CONTINGENCY_HOSTILE_SPELLCAST(AncientSpellcraftSpells.contingency_hostile_spellcast, new ItemStack(WizardryItems.blank_scroll), new ItemStack(WizardryItems.wizard_hat), new ItemStack(Item.func_150898_a((Block)WizardryBlocks.crystal_block))),
    CONTINGENCY_IMMOBILITY(AncientSpellcraftSpells.contingency_immobility, new ItemStack(WizardryItems.blank_scroll), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)PotionTypes.field_185246_r), new ItemStack(Item.func_150898_a((Block)WizardryBlocks.crystal_block))),
    METAMAGIC_PROJECTILE(AncientSpellcraftSpells.metamagic_projectile, new ItemStack(WizardryItems.magic_wand), new ItemStack(Item.func_150898_a((Block)WizardryBlocks.crystal_block))),
    WIZARD_SHIELD(AncientSpellcraftSpells.wizard_shield, new ItemStack(WizardryItems.magic_wand), new ItemStack(Item.func_150898_a((Block)WizardryBlocks.crystal_block))),
    SHRINK_SELF(AncientSpellcraftSpells.shrink_self, new ItemStack(Items.field_151060_bw), new ItemStack(Items.field_151153_ao)),
    GROW_SELF(AncientSpellcraftSpells.grow_self, new ItemStack(Items.field_151150_bK), new ItemStack(Items.field_151153_ao)),
    MASS_SHRINK(AncientSpellcraftSpells.mass_shrink, new ItemStack(Items.field_151060_bw), new ItemStack(Items.field_151153_ao), new ItemStack(WizardryItems.grand_crystal)),
    MASS_GROWTH(AncientSpellcraftSpells.mass_growth, new ItemStack(Items.field_151150_bK), new ItemStack(Items.field_151153_ao), new ItemStack(WizardryItems.grand_crystal)),
    PERMASHRINK(AncientSpellcraftSpells.permashrink, new ItemStack(Items.field_151060_bw), new ItemStack(Items.field_151153_ao), new ItemStack(WizardryItems.astral_diamond)),
    PERMAGROWTH(AncientSpellcraftSpells.permagrowth, new ItemStack(Items.field_151150_bK), new ItemStack(Items.field_151153_ao), new ItemStack(WizardryItems.astral_diamond)),
    WORDS_OF_UNBINDING(AncientSpellcraftSpells.words_of_unbinding, new ItemStack(Item.func_150898_a((Block)Blocks.field_150381_bn)), new ItemStack(WizardryItems.grand_crystal)),
    ASTRAL_PROJECTION(AncientSpellcraftSpells.astral_projection, new ItemStack(Items.field_151073_bk), new ItemStack(WizardryItems.grand_crystal), new ItemStack(Items.field_151153_ao)),
    DIMENSIONAL_ANCHOR(AncientSpellcraftSpells.dimensional_anchor, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)PotionTypes.field_185226_I)),
    CONJURE_LESSER_SENTRY(AncientSpellcraftSpells.conjure_lesser_sentry, new ItemStack(Item.func_150898_a((Block)Blocks.field_150340_R)), new ItemStack(WizardryItems.magic_crystal, 1, 0)),
    CONJURE_GREATER_SENTRY(AncientSpellcraftSpells.conjure_greater_sentry, new ItemStack(Item.func_150898_a((Block)Blocks.field_150484_ah)), new ItemStack(WizardryItems.grand_crystal));

    public static final Map<Spell, SpellComponentList> nameIndex;
    private final Spell spell;
    private final ItemStack[] components;

    public static SpellComponentList lookupBySpell(Spell name) {
        return nameIndex.get(name);
    }

    public static boolean containsSpell(Spell spell) {
        return nameIndex.keySet().contains(spell);
    }

    public static List<Spell> getSpellListByTier(Tier tier) {
        ArrayList<Spell> spells = new ArrayList<Spell>();
        for (Spell spell : nameIndex.keySet()) {
            if (spell.getTier() != tier) continue;
            spells.add(spell);
        }
        return spells;
    }

    private SpellComponentList(Spell spell, ItemStack ... components) {
        this.spell = spell;
        this.components = components;
    }

    public Spell getSpell() {
        return this.spell;
    }

    public ItemStack[] getComponents() {
        return this.components;
    }

    static {
        nameIndex = Maps.newHashMapWithExpectedSize((int)SpellComponentList.values().length);
        for (SpellComponentList spellComponent : SpellComponentList.values()) {
            nameIndex.put(spellComponent.spell, spellComponent);
        }
    }
}

