/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftBlocks;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.ICustomHitbox;
import electroblob.wizardry.entity.construct.EntityMagicConstruct;
import electroblob.wizardry.entity.projectile.EntityMagicArrow;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class EntityArcaneBarrier
extends EntityMagicConstruct
implements ICustomHitbox {
    private static final double SEARCH_BORDER_SIZE = 5.0;
    private static final float BOUNCINESS = 0.2f;
    private static String RADIUS_TAG = "radius";
    private float radius;
    private static final DataParameter<Integer> COLOUR = EntityDataManager.func_187226_a(EntityArcaneBarrier.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> RADIUS = EntityDataManager.func_187226_a(EntityArcaneBarrier.class, (DataSerializer)DataSerializers.field_187193_c);
    private Colour colour = Colour.MAGENTA;
    private List<Entity> entityCache = new ArrayList<Entity>();

    public EntityArcaneBarrier(World world) {
        super(world);
        this.setRadius(1.0f);
        this.field_70158_ak = true;
        this.field_70145_X = true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOUR, (Object)13);
        this.field_70180_af.func_187214_a(RADIUS, (Object)Float.valueOf(1.0f));
    }

    public void setColour(int newColour) {
        this.field_70180_af.func_187227_b(COLOUR, (Object)newColour);
    }

    public Colour getColour() {
        return Colour.getByIndex((Integer)this.field_70180_af.func_187225_a(COLOUR));
    }

    public void setRadius(float radius) {
        this.field_70180_af.func_187227_b(RADIUS, (Object)Float.valueOf(radius));
        this.radius = radius;
        this.field_70131_O = 2.0f * radius;
        this.field_70130_N = 2.0f * radius;
        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - (double)radius, this.field_70163_u - (double)radius, this.field_70161_v - (double)radius, this.field_70165_t + (double)radius, this.field_70163_u + (double)radius, this.field_70161_v + (double)radius));
    }

    public float getRadius() {
        return ((Float)this.field_70180_af.func_187225_a(RADIUS)).floatValue();
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return super.func_70046_E();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void func_70106_y() {
        AncientSpellcraft.proxy.handleRemoveBarrier(this);
        super.func_70106_y();
    }

    public void func_70071_h_() {
        List targets;
        boolean useCache = false;
        if (this.field_70173_aa == 1 || this.field_70173_aa % 60 == 0) {
            this.radius = ((Float)this.field_70180_af.func_187225_a(RADIUS)).floatValue();
            if (this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c() != AncientSpellcraftBlocks.PLACED_RUNE) {
                this.func_70106_y();
                return;
            }
            AncientSpellcraft.proxy.handleAddBarrier(this);
        }
        if (this.field_70173_aa > this.lifetime && this.lifetime != -1) {
            this.despawn();
        }
        if (this.field_70173_aa == 1 && this.field_70170_p.field_72995_K) {
            Wizardry.proxy.playMovingSound((Entity)this, WizardrySounds.ENTITY_FORCEFIELD_AMBIENT, WizardrySounds.SPELLS, 0.5f, 1.0f, true);
        }
        if (this.field_70173_aa % 80 == 0) {
            targets = EntityUtils.getEntitiesWithinRadius((double)((double)this.radius + 5.0), (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (World)this.field_70170_p, Entity.class);
            useCache = true;
        } else {
            targets = this.entityCache;
        }
        targets.remove((Object)this);
        targets.removeIf(t -> t instanceof EntityMagicConstruct || t instanceof EntityXPOrb || t instanceof EntityAnimal || t instanceof EntityMagicArrow && !this.isValidTarget((Entity)((EntityMagicArrow)t).getCaster()) || t instanceof EntityThrowable && !this.isValidTarget((Entity)((EntityThrowable)t).func_85052_h()) || t instanceof EntityArrow && !this.isValidTarget(((EntityArrow)t).field_70250_c));
        for (Entity target : targets) {
            double nudgeVelocity;
            boolean flag;
            if (target == null || !this.isValidTarget(target)) continue;
            if (useCache) {
                this.entityCache = targets;
            }
            Vec3d currentPos = Arrays.stream(GeometryUtils.getVertices((AxisAlignedBB)target.func_174813_aQ())).min(Comparator.comparingDouble(v -> v.func_72438_d(this.func_174791_d()))).orElse(target.func_174791_d());
            double currentDistance = target.func_70032_d((Entity)this);
            Vec3d nextTickPos = currentPos.func_72441_c(target.field_70159_w, target.field_70181_x, target.field_70179_y);
            double nextTickDistance = nextTickPos.func_72438_d(this.func_174791_d());
            if (EntityUtils.isLiving((Entity)target)) {
                flag = nextTickDistance <= (double)this.radius;
            } else {
                boolean bl = flag = currentDistance > (double)this.radius && nextTickDistance <= (double)this.radius || currentDistance < (double)this.radius && nextTickDistance >= (double)this.radius;
            }
            if (!flag) continue;
            if (this.getCaster() instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)this.getCaster()), (Item)WizardryItems.ring_interdiction) && EntityUtils.isLiving((Entity)target)) {
                target.func_70097_a(MagicDamage.causeIndirectMagicDamage((Entity)this, (Entity)this.getCaster(), (MagicDamage.DamageType)MagicDamage.DamageType.MAGIC), 1.0f);
            }
            Vec3d targetRelativePos = currentPos.func_178788_d(this.func_174791_d());
            double d = nudgeVelocity = this.contains(target) ? -0.1 : 0.1;
            if (EntityUtils.isLiving((Entity)target)) {
                nudgeVelocity = 0.25;
            }
            Vec3d extraVelocity = targetRelativePos.func_72432_b().func_186678_a(nudgeVelocity);
            if (!(currentDistance < (double)this.radius)) {
                target.field_70159_w = target.field_70159_w * (double)-0.2f + extraVelocity.field_72450_a;
                target.field_70181_x = target.field_70181_x * (double)-0.2f + extraVelocity.field_72448_b;
                target.field_70179_y = target.field_70179_y * (double)-0.2f + extraVelocity.field_72449_c;
                if (target.field_70122_E && target.field_70181_x < 0.0) {
                    target.field_70181_x = 0.1;
                }
            }
            double distanceTowardsCentre = -(targetRelativePos.func_72433_c() - (double)this.radius - 3.0) - ((double)(this.radius - 3.0f) - nextTickDistance);
            double test = targetRelativePos.func_72433_c() - (double)this.radius - 1.0;
            Vec3d targetNewPos = target.func_174791_d().func_178787_e(targetRelativePos.func_72432_b().func_186678_a(distanceTowardsCentre));
            Vec3d targetNewPos2 = target.func_174791_d().func_178787_e(targetRelativePos.func_72432_b().func_186678_a(-test));
            if (currentDistance - 3.0 < (double)this.radius) {
                target.func_70107_b(targetNewPos2.field_72450_a, targetNewPos2.field_72448_b, targetNewPos2.field_72449_c);
            }
            this.field_70170_p.func_184134_a(target.field_70165_t, target.field_70163_u, target.field_70161_v, WizardrySounds.ENTITY_FORCEFIELD_DEFLECT, WizardrySounds.SPELLS, 0.3f, 1.3f, false);
            if (!this.field_70170_p.field_72995_K) {
                if (!(target instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(target));
                continue;
            }
            Vec3d relativeImpactPos = targetRelativePos.func_72432_b().func_186678_a((double)this.radius);
            float yaw = (float)Math.atan2(relativeImpactPos.field_72450_a, -relativeImpactPos.field_72449_c);
            float pitch = (float)Math.asin(relativeImpactPos.field_72448_b / (double)this.radius);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(this.func_174791_d().func_178787_e(relativeImpactPos)).time(6).face((float)((double)(yaw * 180.0f) / Math.PI), (float)((double)(pitch * 180.0f) / Math.PI)).clr(0.9f, 0.95f, 1.0f).spawn(this.field_70170_p);
            for (int i = 0; i < 12; ++i) {
                float yaw1 = yaw + 0.3f * (this.field_70146_Z.nextFloat() - 0.5f) - 1.5707964f;
                float pitch1 = pitch + 0.3f * (this.field_70146_Z.nextFloat() - 0.5f);
                float brightness = this.field_70146_Z.nextFloat();
                double r = (double)this.radius + 0.05;
                double x = this.field_70165_t + r * (double)MathHelper.func_76134_b((float)yaw1) * (double)MathHelper.func_76134_b((float)pitch1);
                double y = this.field_70163_u + r * (double)MathHelper.func_76126_a((float)pitch1);
                double z = this.field_70161_v + r * (double)MathHelper.func_76126_a((float)yaw1) * (double)MathHelper.func_76134_b((float)pitch1);
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).pos(x, y, z).time(6 + this.field_70146_Z.nextInt(6)).face((float)((double)(yaw1 * 180.0f) / Math.PI) + 90.0f, (float)((double)(pitch1 * 180.0f) / Math.PI)).scale(1.5f).clr(0.7f + 0.3f * brightness, 0.85f + 0.15f * brightness, 1.0f).spawn(this.field_70170_p);
            }
        }
        this.entityCache = targets;
    }

    public boolean contains(Vec3d vec) {
        return vec.func_72438_d(this.func_174791_d()) < (double)this.radius;
    }

    public boolean contains(AxisAlignedBB box) {
        return Arrays.stream(GeometryUtils.getVertices((AxisAlignedBB)box)).allMatch(this::contains);
    }

    public boolean contains(Entity entity) {
        return this.contains(entity.func_174813_aQ());
    }

    public Vec3d calculateIntercept(Vec3d origin, Vec3d endpoint, float fuzziness) {
        double rsquared;
        double t;
        Vec3d line = endpoint.func_178788_d(origin);
        Vec3d closestPoint = origin.func_178787_e(line.func_186678_a(t = -origin.func_178788_d(this.func_174791_d()).func_72430_b(line) / line.func_189985_c()));
        double dsquared = closestPoint.func_72436_e(this.func_174791_d());
        if (dsquared > (rsquared = Math.pow(this.radius + fuzziness, 2.0))) {
            return null;
        }
        return closestPoint.func_178788_d(line.func_72432_b().func_186678_a((double)MathHelper.func_76133_a((double)(rsquared - dsquared))));
    }

    public void writeSpawnData(ByteBuf data) {
        super.writeSpawnData(data);
        data.writeFloat(this.getRadius());
    }

    public boolean func_184215_y(Entity entityIn) {
        return entityIn instanceof EntityPlayer;
    }

    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
        this.setRadius(data.readFloat());
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74776_a(RADIUS_TAG, this.radius);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.radius = nbt.func_74760_g(RADIUS_TAG);
    }

    public boolean func_90999_ad() {
        return false;
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
    }

    @Nullable
    private static EntityArcaneBarrier getSurroundingForcefield(World world, Vec3d vec) {
        double searchRadius = 20.0;
        List forcefields = EntityUtils.getEntitiesWithinRadius((double)searchRadius, (double)vec.field_72450_a, (double)vec.field_72448_b, (double)vec.field_72449_c, (World)world, EntityArcaneBarrier.class);
        forcefields.removeIf(f -> !f.contains(vec));
        return forcefields.stream().min(Comparator.comparingDouble(f -> vec.func_72436_e(f.func_174791_d()))).orElse(null);
    }

    @Nullable
    private static EntityArcaneBarrier getSurroundingForcefield(World world, AxisAlignedBB box, Vec3d vec) {
        double searchRadius = 20.0;
        List forcefields = EntityUtils.getEntitiesWithinRadius((double)searchRadius, (double)vec.field_72450_a, (double)vec.field_72448_b, (double)vec.field_72449_c, (World)world, EntityArcaneBarrier.class);
        forcefields.removeIf(f -> !f.contains(box));
        return forcefields.stream().min(Comparator.comparingDouble(f -> vec.func_72436_e(f.func_174791_d()))).orElse(null);
    }

    @Nullable
    private static EntityArcaneBarrier getSurroundingForcefield(Entity entity) {
        return EntityArcaneBarrier.getSurroundingForcefield(entity.field_70170_p, entity.func_174813_aQ(), entity.func_174791_d());
    }

    @SubscribeEvent
    public static void onPlayerInteractEvent(PlayerInteractEvent event) {
        if (!event.isCancelable()) {
            return;
        }
        AxisAlignedBB box = event.getWorld().func_180495_p(event.getPos()).func_185900_c((IBlockAccess)event.getWorld(), event.getPos()).func_72317_d((double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p());
        if (event instanceof PlayerInteractEvent.EntityInteract) {
            box = ((PlayerInteractEvent.EntityInteract)event).getTarget().func_174813_aQ();
        } else if (event instanceof PlayerInteractEvent.EntityInteractSpecific) {
            box = ((PlayerInteractEvent.EntityInteractSpecific)event).getTarget().func_174813_aQ();
        }
        if (EntityArcaneBarrier.getSurroundingForcefield(event.getWorld(), GeometryUtils.getCentre((AxisAlignedBB)box)) != EntityArcaneBarrier.getSurroundingForcefield(event.getWorld(), event.getEntityPlayer().func_174791_d())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onExplosionEvent(ExplosionEvent event) {
        EntityArcaneBarrier forcefield = EntityArcaneBarrier.getSurroundingForcefield(event.getWorld(), event.getExplosion().getPosition());
        event.getExplosion().func_180343_e().removeIf(p -> EntityArcaneBarrier.getSurroundingForcefield(event.getWorld(), new Vec3d((Vec3i)p).func_72441_c(0.5, 0.5, 0.5)) != forcefield);
        event.getExplosion().func_77277_b().keySet().removeIf(p -> EntityArcaneBarrier.getSurroundingForcefield((Entity)p) != forcefield);
    }

    public static enum Colour {
        MAGENTA(13, 0.67f, 0.28f, 0.85f),
        RED(1, 0.85f, 0.27f, 0.27f),
        GREEN(2, 0.2f, 0.92f, 0.22f),
        ORANGE(14, 0.92f, 0.69f, 0.2f),
        BLUE(2, 0.27f, 0.31f, 0.85f);

        private int colourIndex;
        private final float r;
        private final float g;
        private final float b;

        private Colour(int colourIndex, float r, float g, float b) {
            this.colourIndex = colourIndex;
            this.r = r;
            this.g = g;
            this.b = b;
        }

        public static Colour getByIndex(int index) {
            for (int i = 0; i < Colour.values().length; ++i) {
                if (Colour.values()[i].colourIndex != index) continue;
                return Colour.values()[i];
            }
            return MAGENTA;
        }

        public float getR() {
            return this.r;
        }

        public float getG() {
            return this.g;
        }

        public float getB() {
            return this.b;
        }
    }
}

