/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.living;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.tileentity.TileSentinel;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntitySpellCaster
extends EntityCreature
implements ISpellCaster,
IEntityOwnable {
    private List<Spell> spells = new ArrayList<Spell>(1);
    private Spell continuousSpell;
    private SpellModifiers modifiers = new SpellModifiers();
    private int lifetime = -1;
    private UUID ownerUUID;

    public EntitySpellCaster(World worldIn) {
        super(worldIn);
        this.func_94061_f(true);
        this.field_70131_O = 0.7f;
        this.field_70130_N = 0.4f;
    }

    public void func_70071_h_() {
        TileEntity tile;
        if (this.lifetime != -1) {
            --this.lifetime;
            if (this.lifetime == 0) {
                this.field_70170_p.func_175698_g(this.func_180425_c());
            }
        }
        super.func_70071_h_();
        if (!(this.field_70170_p.field_72995_K || this.field_70173_aa <= 10 || (tile = this.field_70170_p.func_175625_s(this.func_180425_c())) instanceof TileSentinel && ((TileSentinel)tile).getSpellCasterEntity() == this)) {
            this.func_70106_y();
        }
    }

    public ITextComponent func_145748_c_() {
        Entity owner;
        if (this.lifetime != -1 && (owner = EntityUtils.getEntityByUUID((World)this.field_70170_p, (UUID)this.ownerUUID)) != null) {
            return new TextComponentTranslation("entity.ancientspellcraft:spellcaster_entity.name_conjured", new Object[]{owner.func_145748_c_()});
        }
        return super.func_145748_c_();
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public void setSpells(List<Spell> spells) {
        this.spells = spells;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187565_bO;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187766_dk;
    }

    public boolean func_70687_e(PotionEffect effect) {
        return effect.func_188419_a() == WizardryPotions.arcane_jammer;
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
    }

    public boolean func_184603_cC() {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    public boolean func_70104_M() {
        return false;
    }

    public EnumPushReaction func_184192_z() {
        return EnumPushReaction.IGNORE;
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    @Nonnull
    public List<Spell> getSpells() {
        return this.spells;
    }

    @Nonnull
    public SpellModifiers getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(SpellModifiers modifiers) {
        this.modifiers = modifiers;
    }

    @Nonnull
    public Spell getContinuousSpell() {
        return this.continuousSpell;
    }

    public void setContinuousSpell(Spell spell) {
        this.continuousSpell = spell;
    }

    public int getSpellCounter() {
        return 1;
    }

    public void setSpellCounter(int count) {
    }

    public int getAimingError(EnumDifficulty difficulty) {
        switch (difficulty) {
            case EASY: {
                return 7;
            }
            case NORMAL: {
                return 4;
            }
            case HARD: {
                return 1;
            }
        }
        return 7;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void setOwnerId(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    @Nullable
    public UUID func_184753_b() {
        return this.ownerUUID;
    }

    @Nullable
    public Entity func_70902_q() {
        Entity entity = EntityUtils.getEntityByUUID((World)this.field_70170_p, (UUID)this.func_184753_b());
        if (entity != null && !(entity instanceof EntityLivingBase)) {
            AncientSpellcraft.logger.warn("{} has a non-living owner!", (Object)this);
            entity = null;
        }
        return (EntityLivingBase)entity;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        EntityPlayer possibleOwner;
        if (source.func_76346_g() instanceof EntityLivingBase && this.ownerUUID != null && (possibleOwner = this.field_70170_p.func_152378_a(this.ownerUUID)) != null && (Wizardry.settings.friendlyFire == AllyDesignationSystem.FriendlyFire.ONLY_OWNED || Wizardry.settings.friendlyFire == AllyDesignationSystem.FriendlyFire.NONE) && AllyDesignationSystem.isAllied((EntityLivingBase)possibleOwner, (EntityLivingBase)((EntityLivingBase)source.func_76346_g()))) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    static {
        MagicDamage.addEntityImmunity(EntitySpellCaster.class, (MagicDamage.DamageType)MagicDamage.DamageType.WITHER);
    }
}

