/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.living;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.block.BlockReceptacle;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.misc.WildcardTradeList;
import electroblob.wizardry.packet.PacketNPCCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.SpellProperties;
import electroblob.wizardry.util.WandHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class EntityWizardMerchant
extends EntityWizard {
    int lifetime = 24000;
    private MerchantRecipeList trades;

    public EntityWizardMerchant(World world) {
        super(world);
    }

    public ITextComponent func_145748_c_() {
        ITextComponent tex = super.func_145748_c_();
        if (!this.func_145818_k_()) {
            return new TextComponentTranslation("entity.ancientspellcraft:travelling.prefix", new Object[0]).func_150258_a(" ").func_150257_a(tex);
        }
        return super.func_145748_c_();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.lifetime >= 0) {
            EntityPlayer closestPlayer;
            if (this.field_70173_aa == 1) {
                this.onSpawn(false);
            }
            if (this.field_70173_aa == 40 && (closestPlayer = this.field_70170_p.func_72890_a((Entity)this, 120.0)) != null) {
                this.func_70661_as().func_75499_g();
                this.func_70661_as().func_75497_a((Entity)closestPlayer, (double)0.7f);
                this.func_70625_a((Entity)closestPlayer, 30.0f, 30.0f);
            }
            --this.lifetime;
            if (this.lifetime <= 0) {
                this.onDespawn(false);
            } else if (this.isNearCriticalHealth()) {
                this.onDespawn(true);
            }
        }
    }

    protected void func_70619_bc() {
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.trades != null) {
            NBTExtras.storeTagSafely((NBTTagCompound)nbt, (String)"trades", (NBTBase)this.trades.func_77202_a());
        }
        nbt.func_74768_a("lifetime", this.lifetime);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        Element element;
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("trades")) {
            NBTTagCompound nbttagcompound1 = nbt.func_74775_l("trades");
            this.trades = new WildcardTradeList(nbttagcompound1);
        }
        nbt.func_74768_a("element", (element = this.getElement()) == null ? 0 : element.ordinal());
        nbt.func_74768_a("skin", this.textureIndex);
        if (nbt.func_74764_b("lifetime")) {
            this.lifetime = nbt.func_74762_e("lifetime");
        }
    }

    public MerchantRecipeList func_70934_b(EntityPlayer par1EntityPlayer) {
        if (this.trades == null) {
            this.trades = new WildcardTradeList();
            ItemStack crystalStack = new ItemStack(WizardryItems.magic_crystal, 5);
            ArrayList bookTypeList = new ArrayList(ForgeRegistries.ITEMS.getValuesCollection().stream().filter(i -> i instanceof ItemSpellBook).distinct().collect(Collectors.toList()));
            if (!bookTypeList.isEmpty()) {
                MerchantRecipe bookRecipe = new MerchantRecipe(new ItemStack((Item)bookTypeList.get(this.field_70146_Z.nextInt(bookTypeList.size())), 1, Short.MAX_VALUE), crystalStack);
                this.trades.add((Object)bookRecipe);
            }
            this.addRandomRecipes(Math.max(7, this.field_70146_Z.nextInt(10)));
            if (this.field_70146_Z.nextBoolean()) {
                ItemStack secondItemToBuy;
                ArrayList<Item> tablets = new ArrayList<Item>(Arrays.asList(AncientSpellcraftItems.stone_tablet_small, AncientSpellcraftItems.stone_tablet, AncientSpellcraftItems.stone_tablet_large, AncientSpellcraftItems.stone_tablet_grand));
                Item tablet = (Item)tablets.get(this.field_70146_Z.nextInt(tablets.size()));
                if (tablet == AncientSpellcraftItems.stone_tablet_small) {
                    secondItemToBuy = new ItemStack(WizardryItems.magic_crystal, Tier.NOVICE.ordinal() * 3 + 1 + this.field_70146_Z.nextInt(4));
                    this.trades.add((Object)new MerchantRecipe(this.getRandomPrice(Tier.NOVICE), secondItemToBuy, new ItemStack(tablet), 0, 1));
                } else if (tablet == AncientSpellcraftItems.stone_tablet) {
                    secondItemToBuy = new ItemStack(WizardryItems.magic_crystal, Tier.APPRENTICE.ordinal() * 3 + 1 + this.field_70146_Z.nextInt(4));
                    this.trades.add((Object)new MerchantRecipe(this.getRandomPrice(Tier.APPRENTICE), secondItemToBuy, new ItemStack(tablet), 0, 1));
                } else {
                    secondItemToBuy = new ItemStack(WizardryItems.magic_crystal, Tier.ADVANCED.ordinal() * 3 + 1 + this.field_70146_Z.nextInt(8));
                    this.trades.add((Object)new MerchantRecipe(this.getRandomPrice(Tier.ADVANCED), secondItemToBuy, new ItemStack(tablet), 0, 1));
                }
            }
            String rarity = "uncommon";
            for (int j = 0; j < 2; ++j) {
                LootContext context;
                LootTable table = this.field_70170_p.func_184146_ak().func_186521_a(new ResourceLocation("ebwizardry", "subsets/" + rarity + "_artefacts"));
                List stacks = table.func_186462_a(this.field_70170_p.field_73012_v, context = new LootContext.Builder((WorldServer)this.field_70170_p).func_186469_a(0.0f).func_186471_a());
                if (!stacks.isEmpty()) {
                    ItemStack secondItemToBuy = rarity.equals("uncommon") ? new ItemStack(WizardryItems.astral_diamond) : (rarity.equals("rare") ? new ItemStack(WizardryItems.astral_diamond, 2) : new ItemStack(WizardryItems.astral_diamond, 3));
                    this.trades.add((Object)new MerchantRecipe(this.getRandomPrice(Tier.MASTER), secondItemToBuy, (ItemStack)stacks.get(0), 0, 1));
                }
                String string = rarity = this.field_70146_Z.nextInt(5) == 0 ? "epic" : "rare";
                if (!this.field_70146_Z.nextBoolean()) continue;
                ++j;
            }
        }
        return this.trades;
    }

    private void addRandomRecipes(int numberOfItemsToAdd) {
        MerchantRecipeList merchantrecipelist = new MerchantRecipeList();
        for (int i = 0; i < numberOfItemsToAdd; ++i) {
            ItemStack itemToSell = ItemStack.field_190927_a;
            boolean itemAlreadySold = true;
            Tier tier = Tier.NOVICE;
            while (itemAlreadySold) {
                itemAlreadySold = false;
                double tierIncreaseChance = 0.5 + 0.04 * (double)Math.max(this.trades.size(), 0);
                tier = Tier.APPRENTICE;
                if (this.field_70146_Z.nextDouble() < tierIncreaseChance) {
                    tier = Tier.ADVANCED;
                    if (this.field_70146_Z.nextDouble() < tierIncreaseChance * 0.6) {
                        tier = Tier.MASTER;
                    }
                }
                itemToSell = this.getRandomItemOfTier(tier);
                for (Object recipe : merchantrecipelist) {
                    if (!ItemStack.func_77989_b((ItemStack)((MerchantRecipe)recipe).func_77397_d(), (ItemStack)itemToSell)) continue;
                    itemAlreadySold = true;
                }
                if (this.trades == null) continue;
                for (Object recipe : this.trades) {
                    if (!ItemStack.func_77989_b((ItemStack)((MerchantRecipe)recipe).func_77397_d(), (ItemStack)itemToSell)) continue;
                    itemAlreadySold = true;
                }
            }
            if (itemToSell.func_190926_b()) {
                return;
            }
            ItemStack secondItemToBuy = tier == Tier.MASTER ? new ItemStack(WizardryItems.astral_diamond) : new ItemStack(WizardryItems.magic_crystal, tier.ordinal() * 3 + 1 + this.field_70146_Z.nextInt(4));
            merchantrecipelist.add((Object)new MerchantRecipe(this.getRandomPrice(tier), secondItemToBuy, itemToSell, 0, 1));
        }
        Collections.shuffle(merchantrecipelist);
        if (this.trades == null) {
            this.trades = new WildcardTradeList();
        }
        this.trades.addAll((Collection)merchantrecipelist);
    }

    private ItemStack getRandomPrice(Tier tier) {
        int value;
        Map map = Wizardry.settings.currencyItems;
        Pair itemName = map.keySet().toArray(new Pair[0])[this.field_70146_Z.nextInt(map.size())];
        Item item = (Item)Item.field_150901_e.func_82594_a(itemName.getLeft());
        short meta = (Short)itemName.getRight();
        if (item == null) {
            Wizardry.logger.warn("Invalid item in currency items: {}", (Object)itemName);
            item = Items.field_151166_bC;
            value = 6;
        } else {
            value = (Integer)map.get(itemName);
        }
        return new ItemStack(item, MathHelper.func_76125_a((int)((8 + tier.ordinal() * 16 + this.field_70146_Z.nextInt(9)) / value), (int)1, (int)64), (int)meta);
    }

    private ItemStack getRandomItemOfTier(Tier tier) {
        List spells = Spell.getSpells((Predicate)new Spell.TierElementFilter(tier, null, new SpellProperties.Context[]{SpellProperties.Context.TRADES}));
        List specialismSpells = Spell.getSpells((Predicate)new Spell.TierElementFilter(tier, this.getElement(), new SpellProperties.Context[]{SpellProperties.Context.TRADES}));
        spells.removeIf(s -> !s.isEnabled(new SpellProperties.Context[]{SpellProperties.Context.BOOK}));
        specialismSpells.removeIf(s -> !s.isEnabled(new SpellProperties.Context[]{SpellProperties.Context.BOOK}));
        switch (tier) {
            case NOVICE: {
                int randomiser = this.field_70146_Z.nextInt(5);
                if (randomiser < 4 && !spells.isEmpty()) {
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0 && !specialismSpells.isEmpty()) {
                        return new ItemStack(WizardryItems.spell_book, 1, ((Spell)specialismSpells.get(this.field_70146_Z.nextInt(specialismSpells.size()))).metadata());
                    }
                    return new ItemStack(WizardryItems.spell_book, 1, ((Spell)spells.get(this.field_70146_Z.nextInt(spells.size()))).metadata());
                }
                if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0) {
                    return new ItemStack(WizardryItems.getWand((Tier)tier, (Element)this.getElement()));
                }
                return new ItemStack(WizardryItems.getWand((Tier)tier, (Element)Element.values()[this.field_70146_Z.nextInt(Element.values().length)]));
            }
            case APPRENTICE: {
                int randomiser = this.field_70146_Z.nextInt(Wizardry.settings.discoveryMode ? 12 : 10);
                if (randomiser < 5 && !spells.isEmpty()) {
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0 && !specialismSpells.isEmpty()) {
                        return new ItemStack(WizardryItems.spell_book, 1, ((Spell)specialismSpells.get(this.field_70146_Z.nextInt(specialismSpells.size()))).metadata());
                    }
                    return new ItemStack(WizardryItems.spell_book, 1, ((Spell)spells.get(this.field_70146_Z.nextInt(spells.size()))).metadata());
                }
                if (randomiser < 6) {
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0) {
                        return new ItemStack(WizardryItems.getWand((Tier)tier, (Element)this.getElement()));
                    }
                    return new ItemStack(WizardryItems.getWand((Tier)tier, (Element)Element.values()[this.field_70146_Z.nextInt(Element.values().length)]));
                }
                if (randomiser < 8) {
                    return new ItemStack(WizardryItems.arcane_tome, 1, 1);
                }
                if (randomiser < 10) {
                    EntityEquipmentSlot slot = InventoryUtils.ARMOUR_SLOTS[this.field_70146_Z.nextInt(InventoryUtils.ARMOUR_SLOTS.length)];
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0) {
                        return new ItemStack(WizardryItems.getArmour((Element)this.getElement(), (EntityEquipmentSlot)slot));
                    }
                    return new ItemStack(WizardryItems.getArmour((Element)Element.values()[this.field_70146_Z.nextInt(Element.values().length)], (EntityEquipmentSlot)slot));
                }
                return new ItemStack(WizardryItems.identification_scroll);
            }
            case ADVANCED: {
                int randomiser = this.field_70146_Z.nextInt(18);
                if (randomiser < 5 && !spells.isEmpty()) {
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0 && !specialismSpells.isEmpty()) {
                        return new ItemStack(WizardryItems.spell_book, 1, ((Spell)specialismSpells.get(this.field_70146_Z.nextInt(specialismSpells.size()))).metadata());
                    }
                    return new ItemStack(WizardryItems.spell_book, 1, ((Spell)spells.get(this.field_70146_Z.nextInt(spells.size()))).metadata());
                }
                if (randomiser < 6) {
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0) {
                        return new ItemStack(WizardryItems.getWand((Tier)tier, (Element)this.getElement()));
                    }
                    return new ItemStack(WizardryItems.getWand((Tier)tier, (Element)Element.values()[this.field_70146_Z.nextInt(Element.values().length)]));
                }
                if (randomiser < 8) {
                    return new ItemStack(WizardryItems.arcane_tome, 1, 2);
                }
                if (randomiser < 10) {
                    return new ItemStack(AncientSpellcraftItems.transmutation_scroll, 1);
                }
                if (randomiser < 12) {
                    return new ItemStack(WizardryItems.grand_crystal, 1);
                }
                if (randomiser < 14) {
                    ArrayList<Item> upgrades = new ArrayList<Item>(Arrays.asList(WizardryItems.resplendent_thread, WizardryItems.crystal_silver_plating, WizardryItems.ethereal_crystalweave));
                    return new ItemStack((Item)upgrades.get(this.field_70146_Z.nextInt(upgrades.size())), 1);
                }
                ArrayList upgrades = new ArrayList(WandHelper.getSpecialUpgrades());
                randomiser = this.field_70146_Z.nextInt(upgrades.size());
                return new ItemStack((Item)upgrades.get(randomiser));
            }
            case MASTER: {
                int randomiser;
                int n = randomiser = this.getElement() != Element.MAGIC ? this.field_70146_Z.nextInt(8) : 5 + this.field_70146_Z.nextInt(3);
                if (randomiser < 5 && this.getElement() != Element.MAGIC && !specialismSpells.isEmpty()) {
                    return new ItemStack(WizardryItems.spell_book, 1, ((Spell)specialismSpells.get(this.field_70146_Z.nextInt(specialismSpells.size()))).metadata());
                }
                if (randomiser < 6) {
                    if (this.getElement() != Element.MAGIC && this.field_70146_Z.nextInt(4) > 0) {
                        return new ItemStack(WizardryItems.getWand((Tier)tier, (Element)this.getElement()));
                    }
                    return new ItemStack(WizardryItems.master_wand);
                }
                return new ItemStack(WizardryItems.arcane_tome, 1, 3);
            }
        }
        return new ItemStack(Blocks.field_150348_b);
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.isNearCriticalHealth(damage)) {
            this.onDespawn(true);
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    private boolean isNearCriticalHealth(float damage) {
        return this.func_110138_aP() - damage <= this.func_110138_aP() * 0.3f;
    }

    private boolean isNearCriticalHealth() {
        return this.func_110143_aJ() <= this.func_110138_aP() * 0.3f;
    }

    private void onSpawn(boolean castBlind) {
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticles();
        } else if (castBlind) {
            this.castBlind();
        }
    }

    private void onDespawn(boolean castBlind) {
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticles();
        } else if (castBlind) {
            this.castBlind();
        }
        this.func_70106_y();
    }

    private void castBlind() {
        Spells.blinding_flash.cast(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, EnumFacing.UP, 0, 0, new SpellModifiers());
        if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(SpellCastEvent.Source.NPC, Spells.blinding_flash, (EntityLivingBase)this, new SpellModifiers()))) {
            return;
        }
        if (Spells.blinding_flash.cast(this.field_70170_p, (EntityLiving)this, EnumHand.MAIN_HAND, 0, (EntityLivingBase)this, new SpellModifiers())) {
            MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.NPC, Spells.blinding_flash, (EntityLivingBase)this, new SpellModifiers()));
            if (Spells.blinding_flash.requiresPacket()) {
                PacketNPCCastSpell.Message msg = new PacketNPCCastSpell.Message(this.func_145782_y(), this.func_145782_y(), EnumHand.MAIN_HAND, Spells.blinding_flash, new SpellModifiers());
                WizardryPacketHandler.net.sendToDimension((IMessage)msg, this.field_70170_p.field_73011_w.getDimension());
            }
        }
    }

    private void spawnParticles() {
        double z;
        double y;
        double x;
        float angle;
        double radius;
        int i;
        BlockPos pos = this.func_190671_u_();
        this.field_70170_p.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), WizardrySounds.SPELL_TRANSPORTATION_TRAVEL, WizardrySounds.SPELLS, 1.0f, 1.0f, false);
        int[] colours = (int[])BlockReceptacle.PARTICLE_COLOURS.get(this.getElement());
        for (i = 0; i < 20; ++i) {
            radius = 1.0;
            angle = this.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            x = (double)pos.func_177958_n() + 0.5 + radius * (double)MathHelper.func_76134_b((float)angle);
            y = (double)pos.func_177956_o() + this.field_70170_p.field_73012_v.nextDouble() * 2.0;
            z = (double)pos.func_177952_p() + 0.5 + radius * (double)MathHelper.func_76126_a((float)angle);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.02, 0.0).clr(colours[0]).fade(colours[1]).time(80 + this.field_70170_p.field_73012_v.nextInt(10)).spawn(this.field_70170_p);
        }
        for (i = 0; i < 20; ++i) {
            radius = 1.0;
            angle = this.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            x = (double)pos.func_177958_n() + 0.5 + radius * (double)MathHelper.func_76134_b((float)angle);
            y = (double)pos.func_177956_o() + this.field_70170_p.field_73012_v.nextDouble() * 2.0;
            z = (double)pos.func_177952_p() + 0.5 + radius * (double)MathHelper.func_76126_a((float)angle);
            this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, x, y, z, 0.0, 0.02, 0.0, new int[0]);
        }
        for (i = 0; i < 20; ++i) {
            radius = 1.0;
            angle = this.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            x = (double)pos.func_177958_n() + 0.5 + radius * (double)MathHelper.func_76134_b((float)angle);
            y = (double)pos.func_177956_o() + this.field_70170_p.field_73012_v.nextDouble() * 2.0;
            z = (double)pos.func_177952_p() + 0.5 + radius * (double)MathHelper.func_76126_a((float)angle);
            this.field_70170_p.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, x, y, z, 0.0, 0.02, 0.0, new int[0]);
        }
    }
}

