/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.projectile;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftSounds;
import com.windanesz.ancientspellcraft.spell.Contingency;
import electroblob.wizardry.entity.projectile.EntityMagicProjectile;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityContingencyProjectile
extends EntityMagicProjectile {
    private int lifetime = 16;
    private Spell storedSpell = Spells.none;
    private Contingency.Type contingencyType = Contingency.Type.DAMAGE;

    public EntityContingencyProjectile(World world) {
        super(world);
        this.func_70105_a(0.7f, 0.7f);
    }

    public void setContingencyType(Contingency.Type contingencyType) {
        this.contingencyType = contingencyType;
    }

    public void setStoredSpell(Spell storedSpell) {
        this.storedSpell = storedSpell;
    }

    protected void func_70184_a(RayTraceResult rayTrace) {
        Entity entity;
        if (!this.field_70170_p.field_72995_K && (entity = rayTrace.field_72308_g) != null && entity instanceof EntityLivingBase) {
            if (this.field_70192_c != null) {
                Contingency.setContingencyTag((EntityLivingBase)entity, this.field_70192_c, this.contingencyType, this.storedSpell);
            } else {
                Contingency.setContingencyTag((EntityLivingBase)entity, (EntityLivingBase)entity, this.contingencyType, this.storedSpell);
            }
        }
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, AncientSpellcraftSounds.DISPEL, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
        this.func_70106_y();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                if (this.field_70173_aa <= 1) continue;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE, (Random)this.field_70146_Z, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)0.03, (boolean)true).clr(210, 255, 255).fade(0.2f, 0.2f, 0.2f).time(20 + this.field_70146_Z.nextInt(10)).spawn(this.field_70170_p);
                if (this.field_70173_aa <= 1) continue;
                double x = this.field_70165_t - this.field_70159_w / 2.0;
                double y = this.field_70163_u - this.field_70181_x / 2.0;
                double z = this.field_70161_v - this.field_70179_y / 2.0;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH, (Random)this.field_70146_Z, (double)x, (double)y, (double)z, (double)0.01, (boolean)true).clr(210, 255, 255).fade(0.2f, 0.2f, 0.2f).time(20 + this.field_70146_Z.nextInt(10)).spawn(this.field_70170_p);
            }
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.lifetime);
        super.writeSpawnData(buffer);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.lifetime = buffer.readInt();
        super.readSpawnData(buffer);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.lifetime = nbt.func_74762_e("lifetime");
        this.storedSpell = (Spell)Spell.registry.getValue(new ResourceLocation(nbt.func_74779_i("stored_spell")));
        this.contingencyType = Contingency.Type.fromName(nbt.func_74779_i("contingency_type"));
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("lifetime", this.lifetime);
        nbt.func_74778_a("stored_spell", this.storedSpell.getUnlocalisedName());
        nbt.func_74778_a("contingency_type", this.contingencyType.spellName);
    }
}

