/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.projectile;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftSounds;
import com.windanesz.ancientspellcraft.util.SpellcastUtils;
import electroblob.wizardry.entity.construct.EntityMagicConstruct;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.entity.projectile.EntityMagicProjectile;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityMetamagicProjectile
extends EntityMagicProjectile {
    private int lifetime = 16;
    private Spell storedSpell = Spells.none;

    public EntityMetamagicProjectile(World world) {
        super(world);
        this.func_70105_a(0.7f, 0.7f);
    }

    public void setStoredSpell(Spell storedSpell) {
        this.storedSpell = storedSpell;
    }

    protected void func_70184_a(RayTraceResult rayTrace) {
        if (!this.field_70170_p.field_72995_K) {
            Entity entity = rayTrace.field_72308_g;
            if (entity != null) {
                if (entity instanceof EntityLivingBase) {
                    // empty if block
                }
            } else {
                SpellcastUtils.tryCastSpellAtLocation(this.field_70170_p, rayTrace.func_178782_a().func_177984_a(), rayTrace.field_178784_b, this.storedSpell, new SpellModifiers());
            }
        }
        if (this.field_70192_c == null) {
            return;
        }
        if (rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && rayTrace.func_178782_a() != null) {
            List entityList;
            BlockPos pos = rayTrace.func_178782_a().func_177984_a();
            List entities = EntityUtils.getEntitiesWithinRadius((double)1.5, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (World)this.field_70170_p, EntityLivingBase.class);
            if (!entities.isEmpty()) {
                for (EntityLivingBase entityLivingBase : entities) {
                    if (!(entityLivingBase instanceof ISummonedCreature) || ((ISummonedCreature)entityLivingBase).func_184753_b() != null || entityLivingBase.field_70173_aa >= 40) continue;
                    ((ISummonedCreature)entityLivingBase).setOwnerId(this.field_70192_c.func_110124_au());
                    ((ISummonedCreature)entityLivingBase).setCaster(this.field_70192_c);
                }
            }
            if (!(entityList = EntityUtils.getEntitiesWithinRadius((double)3.0, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (World)this.field_70170_p, EntityMagicConstruct.class)).isEmpty()) {
                for (EntityMagicConstruct magicConstruct : entityList) {
                    if (magicConstruct.field_70173_aa >= 40 || magicConstruct.func_184753_b() != null) continue;
                    magicConstruct.setCaster(this.field_70192_c);
                }
            }
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, AncientSpellcraftSounds.DISPEL, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                double dx = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double dy = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70131_O + (double)(this.field_70131_O / 2.0f) - 0.1;
                double dz = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double v = 0.06;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).clr(255, 255, 255).pos(this.func_174791_d().func_72441_c(dx - this.field_70159_w / 2.0, dy, dz - this.field_70179_y / 2.0)).vel(-v * dx, -v * dy, -v * dz).scale(this.field_70130_N * 2.0f).time(10).spawn(this.field_70170_p);
                if (this.field_70173_aa <= 1) continue;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST, (Random)this.field_70146_Z, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)0.03, (boolean)true).clr(255, 255, 255).fade(0, 0, 0).time(20 + this.field_70146_Z.nextInt(10)).spawn(this.field_70170_p);
                if (this.field_70173_aa <= 1) continue;
                double x = this.field_70165_t - this.field_70159_w / 2.0;
                double y = this.field_70163_u - this.field_70181_x / 2.0;
                double z = this.field_70161_v - this.field_70179_y / 2.0;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH, (Random)this.field_70146_Z, (double)x, (double)y, (double)z, (double)0.03, (boolean)true).clr(255, 255, 255).fade(0, 0, 0).time(20 + this.field_70146_Z.nextInt(10)).spawn(this.field_70170_p);
            }
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.lifetime);
        super.writeSpawnData(buffer);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.lifetime = buffer.readInt();
        super.readSpawnData(buffer);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.lifetime = nbt.func_74762_e("lifetime");
        this.storedSpell = (Spell)Spell.registry.getValue(new ResourceLocation(nbt.func_74779_i("stored_spell")));
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("lifetime", this.lifetime);
        nbt.func_74778_a("stored_spell", this.storedSpell.getUnlocalisedName());
    }
}

