/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.item.ITickableArtefact;
import com.windanesz.ancientspellcraft.item.ItemASArtefact;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCubePhasing
extends ItemASArtefact
implements ISpellCastingItem,
IManaStoringItem,
ITickableArtefact {
    public ItemCubePhasing(EnumRarity rarity, ItemArtefact.Type type) {
        super(rarity, type);
        this.func_77656_e(1000);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return !this.isManaEmpty(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        Wizardry.proxy.addMultiLineDescription(tooltip, "item." + this.getRegistryName() + ".desc", new Object[]{Settings.generalSettings.orb_artefact_potency_bonus});
        if (!Settings.isArtefactEnabled((Item)this)) {
            tooltip.add(Wizardry.proxy.translate("item.ebwizardry:generic.disabled", new Style().func_150238_a(TextFormatting.RED), new Object[0]));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        SpellModifiers modifiers;
        Spell spell;
        ItemStack stack = player.func_184586_b(hand);
        if (Settings.isArtefactEnabled((Item)this) && this.canCast(stack, spell = this.getSpell(player, world), player, hand, 0, modifiers = new SpellModifiers()) && this.cast(stack, spell, player, hand, 0, modifiers)) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase user, int timeLeft) {
        this.finishCasting(stack, user, timeLeft);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase user) {
        this.finishCasting(stack, user, 0);
        return stack;
    }

    private void finishCasting(ItemStack stack, EntityLivingBase user, int timeLeft) {
        if (Spell.byMetadata((int)stack.func_77952_i()).isContinuous) {
            Spell spell = Spell.byMetadata((int)stack.func_77952_i());
            SpellModifiers modifiers = new SpellModifiers();
            int castingTick = stack.func_77988_m() - timeLeft;
            MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Finish(SpellCastEvent.Source.SCROLL, spell, user, modifiers, castingTick));
            spell.finishCasting(user.field_70170_p, user, Double.NaN, Double.NaN, Double.NaN, null, castingTick, modifiers);
            if (user instanceof EntityPlayer) {
                ((EntityPlayer)user).func_184811_cZ().func_185145_a((Item)this, spell.getCooldown());
            }
        }
    }

    public boolean cast(ItemStack stack, Spell spell, EntityPlayer caster, EnumHand hand, int castingTick, SpellModifiers modifiers) {
        World world = caster.field_70170_p;
        if (world.field_72995_K && !spell.isContinuous && spell.requiresPacket()) {
            return false;
        }
        if (spell.cast(world, caster, hand, castingTick, modifiers)) {
            if (!world.field_72995_K) {
                if (!spell.isContinuous && spell.requiresPacket()) {
                    PacketCastSpell.Message msg = new PacketCastSpell.Message(caster.func_145782_y(), hand, spell, modifiers);
                    WizardryPacketHandler.net.sendToDimension((IMessage)msg, world.field_73011_w.getDimension());
                }
                caster.func_184811_cZ().func_185145_a((Item)this, 10);
                this.consumeMana(stack, this.getManaCost(spell), (EntityLivingBase)caster);
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public Spell getCurrentSpell(ItemStack stack) {
        return Spells.none;
    }

    public boolean showSpellHUD(EntityPlayer player, ItemStack stack) {
        return false;
    }

    public boolean canCast(ItemStack stack, Spell spell, EntityPlayer caster, EnumHand hand, int castingTick, SpellModifiers modifiers) {
        if (this.getMana(stack) < this.getManaCost(spell)) {
            return false;
        }
        if (castingTick == 0) {
            return !MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(SpellCastEvent.Source.OTHER, spell, (EntityLivingBase)caster, modifiers));
        }
        return !spell.isContinuous;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public void setMana(ItemStack stack, int mana) {
        super.setDamage(stack, this.getManaCapacity(stack) - mana);
    }

    public int getMana(ItemStack stack) {
        return this.getManaCapacity(stack) - this.getDamage(stack);
    }

    public int getManaCapacity(ItemStack stack) {
        return this.getMaxDamage(stack);
    }

    public void addCharge(ItemStack stack) {
        this.setMana(stack, this.getMana(stack) + 20);
    }

    private int getManaCost(Spell spell) {
        return spell == Spells.blink ? 200 : 400;
    }

    private Spell getSpell(EntityPlayer caster, World world) {
        return caster.func_70093_af() ? Spells.phase_step : Spells.blink;
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        if (player.field_70170_p.func_82737_E() % 20L == 0L && !this.isManaFull(stack)) {
            this.addCharge(stack);
        }
    }
}

