/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftTabs;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryRecipes;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMagicShield
extends Item
implements ISpellCastingItem,
IManaStoringItem,
IWorkbenchItem {
    private final EnumRarity rarity;
    private final int charge = 2;

    public ItemMagicShield(EnumRarity rarity) {
        this.func_77664_n();
        this.field_77777_bU = 1;
        this.func_77637_a(AncientSpellcraftTabs.ANCIENTSPELLCRAFT_GEAR);
        this.func_77656_e(1000);
        this.rarity = rarity;
        this.func_185043_a(new ResourceLocation("blocking"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)ItemArmor.field_96605_cw);
        WizardryRecipes.addToManaFlaskCharging((Item)this);
    }

    public int getSpellSlotCount(ItemStack stack) {
        return 0;
    }

    public boolean onApplyButtonPressed(EntityPlayer player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        boolean changed = false;
        if (crystals.func_75211_c() != ItemStack.field_190927_a && !this.isManaFull(centre.func_75211_c())) {
            int chargeDepleted = this.getManaCapacity(centre.func_75211_c()) - this.getMana(centre.func_75211_c());
            if (crystals.func_75211_c().func_190916_E() * 100 < chargeDepleted) {
                this.rechargeMana(centre.func_75211_c(), crystals.func_75211_c().func_190916_E() * 100);
                crystals.func_75209_a(crystals.func_75211_c().func_190916_E());
            } else {
                this.setMana(centre.func_75211_c(), this.getManaCapacity(centre.func_75211_c()));
                crystals.func_75209_a((int)Math.ceil((double)chargeDepleted / 100.0));
            }
            changed = true;
        }
        return changed;
    }

    public boolean showTooltip(ItemStack stack) {
        return true;
    }

    public int getMana(ItemStack stack) {
        return this.getManaCapacity(stack) - this.getDamage(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public void setMana(ItemStack stack, int mana) {
        super.setDamage(stack, this.getManaCapacity(stack) - mana);
    }

    public int getManaCapacity(ItemStack stack) {
        return this.getMaxDamage(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.rarity;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        Wizardry.proxy.addMultiLineDescription(tooltip, "item." + this.getRegistryName() + ".desc", new Object[0]);
        if (advanced.func_194127_a()) {
            tooltip.add("\u00a79" + I18n.func_135052_a((String)"item.ebwizardry:wand.mana", (Object[])new Object[]{this.getMana(stack), this.getManaCapacity(stack)}));
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return 20000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.isManaEmpty(stack)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        Spell spell = Spells.shield;
        SpellModifiers modifiers = new SpellModifiers();
        modifiers.set("potency", 2.0f, false);
        this.cast(stack, spell, player, hand, 0, modifiers);
        if (!player.func_184587_cr()) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        if (ItemStack.func_185132_d((ItemStack)oldStack, (ItemStack)newStack)) {
            return true;
        }
        return super.canContinueUsing(oldStack, newStack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase user, int count) {
        if (user instanceof EntityPlayer && count % 20 == 0) {
            this.consumeMana(stack, 2, user);
            if (this.isManaEmpty(stack)) {
                user.func_184597_cx();
            }
        }
        super.onUsingTick(stack, user, count);
    }

    public String func_77653_i(ItemStack stack) {
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return !this.isManaEmpty(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (!(oldStack.func_190926_b() && newStack.func_190926_b() || oldStack.func_77973_b() != newStack.func_77973_b() || slotChanged)) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean cast(ItemStack stack, Spell spell, EntityPlayer caster, EnumHand hand, int castingTick, SpellModifiers modifiers) {
        World world = caster.field_70170_p;
        if (world.field_72995_K && !spell.isContinuous && spell.requiresPacket()) {
            return false;
        }
        if (spell.cast(world, caster, hand, castingTick, modifiers)) {
            if (castingTick == 0) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.OTHER, spell, (EntityLivingBase)caster, modifiers));
            }
            if (!world.field_72995_K && !spell.isContinuous && spell.requiresPacket()) {
                PacketCastSpell.Message msg = new PacketCastSpell.Message(caster.func_145782_y(), hand, spell, modifiers);
                WizardryPacketHandler.net.sendToDimension((IMessage)msg, world.field_73011_w.getDimension());
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public Spell getCurrentSpell(ItemStack stack) {
        return Spells.shield;
    }

    public boolean showSpellHUD(EntityPlayer player, ItemStack stack) {
        return false;
    }

    public boolean canCast(ItemStack stack, Spell spell, EntityPlayer caster, EnumHand hand, int castingTick, SpellModifiers modifiers) {
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }
}

