/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.google.common.collect.Multimap;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftSpells;
import electroblob.wizardry.data.IVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.IConjuredItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemShadowBlade
extends ItemSword
implements IConjuredItem {
    public static final IVariable<Integer> SHADOW_CHARGE_TIME = new IVariable.Variable(Persistence.NEVER).withTicker(ItemShadowBlade::update);
    public static final IVariable<Boolean> SHADOW_CHARGE_UPWARDS = new IVariable.Variable(Persistence.NEVER);
    private static final double EXTRA_HIT_MARGIN = 1.0;

    public ItemShadowBlade() {
        super(Item.ToolMaterial.IRON);
        this.func_77656_e(1200);
        this.setNoRepair();
        this.addAnimationPropertyOverrides();
        this.func_77637_a(null);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.COMMON;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getMaxDamageFromNBT(stack, Spells.conjure_sword);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.func_111205_h(slot);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(POTENCY_MODIFIER, "Potency modifier", (double)(IConjuredItem.getDamageMultiplier((ItemStack)stack) - 1.0f), 2));
        }
        return multimap;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase wielder) {
        if (!ItemShadowBlade.isImmuneToWither(target)) {
            ItemShadowBlade.applyWitherDamage(target);
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)AncientSpellcraftItems.charm_shadow_blade)) {
            this.startShadowForm(player, player.func_70093_af());
            player.func_184811_cZ().func_185145_a((Item)this, 80);
            player.func_184224_h(true);
        }
        return super.func_77659_a(world, player, hand);
    }

    private static int getRandomNumberInRange(int min, int max) {
        Random r = new Random();
        return r.nextInt(max - min + 1) + min;
    }

    private void startShadowForm(EntityPlayer player, Boolean upwards) {
        WizardData.get((EntityPlayer)player).setVariable(SHADOW_CHARGE_TIME, (Object)6);
        WizardData.get((EntityPlayer)player).setVariable(SHADOW_CHARGE_UPWARDS, (Object)upwards);
    }

    private static int update(EntityPlayer player, Integer chargeTime) {
        if (WizardData.get((EntityPlayer)player) != null) {
            boolean upwards = false;
            if (WizardData.get((EntityPlayer)player).getVariable(SHADOW_CHARGE_UPWARDS) != null) {
                upwards = (Boolean)WizardData.get((EntityPlayer)player).getVariable(SHADOW_CHARGE_UPWARDS);
            }
            if (chargeTime == null) {
                chargeTime = 0;
            }
            if (chargeTime > 0) {
                player.func_82142_c(true);
                Vec3d look = player.func_70040_Z();
                float speed = 1.5f;
                if (upwards) {
                    player.field_70181_x = 1.0;
                    player.field_70159_w = look.field_72450_a / 2.0;
                    player.field_70179_y = look.field_72449_c / 2.0;
                } else {
                    player.field_70159_w = look.field_72450_a * (double)speed;
                    player.field_70179_y = look.field_72449_c * (double)speed;
                }
                List collided = player.field_70170_p.func_72872_a(EntityLivingBase.class, player.func_174813_aQ().func_186662_g(1.0));
                collided.remove(player);
                if (player.field_70170_p.field_72995_K) {
                    for (int i = 0; i < 5; ++i) {
                        float x = player.field_70170_p.field_73012_v.nextFloat();
                        x = player.field_70170_p.field_73012_v.nextBoolean() ? x : x * -1.0f;
                        float y = player.field_70170_p.field_73012_v.nextFloat();
                        y = player.field_70170_p.field_73012_v.nextBoolean() ? y : y * -1.0f;
                        float z = player.field_70170_p.field_73012_v.nextFloat();
                        z = player.field_70170_p.field_73012_v.nextBoolean() ? z : z * -1.0f;
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).entity((Entity)player).pos(0.0, (double)(player.field_70131_O / 2.0f), 0.0).time(6).vel(player.field_70170_p.field_73012_v.nextGaussian() / 40.0, player.field_70170_p.field_73012_v.nextDouble() / 40.0, player.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(0, 0, 0).collide(false).scale(2.0f).spawn(player.field_70170_p);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).entity((Entity)player).pos((double)x, (double)(player.field_70131_O / 2.0f + y), (double)z).time(6 + ItemShadowBlade.getRandomNumberInRange(0, 4)).vel(player.field_70170_p.field_73012_v.nextGaussian() / 40.0, player.field_70170_p.field_73012_v.nextDouble() / 40.0, player.field_70170_p.field_73012_v.nextGaussian() / 40.0).clr(0, 0, 0).collide(false).scale(1.0f).spawn(player.field_70170_p);
                    }
                }
                if (!player.field_70170_p.field_72995_K && !collided.isEmpty()) {
                    for (EntityLivingBase entity : collided) {
                        if (ItemShadowBlade.isImmuneToWither(entity)) continue;
                        ItemShadowBlade.applyWitherDamage(entity);
                    }
                }
                Integer n = chargeTime;
                Integer n2 = chargeTime = Integer.valueOf(chargeTime - 1);
                if (chargeTime == 0) {
                    if (!player.func_70644_a(MobEffects.field_76441_p)) {
                        player.func_82142_c(false);
                    }
                    player.func_184224_h(false);
                }
            }
        }
        return chargeTime;
    }

    private static boolean isImmuneToWither(EntityLivingBase entity) {
        return entity.func_70644_a(MobEffects.field_82731_v) || MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.WITHER, (Entity)entity) || entity instanceof EntityWitherSkeleton || entity instanceof EntityWither;
    }

    private static void applyWitherDamage(EntityLivingBase target) {
        target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, AncientSpellcraftSpells.conjure_shadow_blade.getProperty("wither_duration").intValue()));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (!(oldStack.func_190926_b() && newStack.func_190926_b() || oldStack.func_77973_b() != newStack.func_77973_b() || slotChanged)) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        int damage = stack.func_77952_i();
        if (damage > stack.func_77958_k() || damage < 0) {
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184592_cb().func_77973_b() instanceof ItemShadowBlade) {
                ((EntityPlayer)entity).func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
            } else {
                entity.func_174820_d(slot, ItemStack.field_190927_a);
            }
        } else {
            stack.func_77964_b(damage + 1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack par2ItemStack) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return false;
    }
}

