/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.potion;

import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.entity.projectile.EntityMagicArrow;
import electroblob.wizardry.entity.projectile.EntityMagicProjectile;
import electroblob.wizardry.potion.PotionMagicEffect;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PotionProjectileWard
extends PotionMagicEffect {
    private boolean deflectsMagic;
    private float deflectChance;
    private Potion potion;
    private static int MAGIC_PROJECTILE_CONSUME_AMOUNT = 20;
    private static int PHYSICAL_PROJECTILE_CONSUME_AMOUNT = 10;

    public PotionProjectileWard(Potion potion, String name, int liquidColor, boolean deflectsMagic, float deflectChance) {
        super(false, 16580068, new ResourceLocation("ancientspellcraft", "textures/gui/potion_icon_" + name + ".png"));
        this.func_188413_j();
        this.func_76390_b("potion.ancientspellcraft:" + name);
        this.deflectsMagic = deflectsMagic;
        this.deflectChance = deflectChance;
        this.potion = potion;
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return true;
    }

    public void func_76394_a(EntityLivingBase entity, int strength) {
        if (entity != null) {
            List projectiles = EntityUtils.getEntitiesWithinRadius((double)3.5, (double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v, (World)entity.field_70170_p, Entity.class);
            for (Entity projectile : projectiles) {
                if (this.isProjectileOnGround(projectile)) continue;
                if (projectile instanceof EntityMagicProjectile) {
                    if (((EntityMagicProjectile)projectile).func_85052_h() == entity) {
                        return;
                    }
                    if (!this.deflectsMagic) continue;
                    if (entity.field_70170_p.field_73012_v.nextDouble() <= (double)this.deflectChance) {
                        if (!projectile.func_95999_t().equals("marked") && !ASUtils.attemptConsumeManaFromHand(entity, MAGIC_PROJECTILE_CONSUME_AMOUNT)) continue;
                        projectile.func_96094_a("marked");
                        this.onDeflect(entity, projectile);
                        continue;
                    }
                    projectile.func_96094_a("marked");
                    continue;
                }
                if (!(projectile instanceof IProjectile)) continue;
                if (projectile instanceof EntityArrow && ((EntityArrow)projectile).field_70250_c == entity) {
                    return;
                }
                if (entity.field_70170_p.field_73012_v.nextDouble() <= (double)this.deflectChance) {
                    if (!(projectile instanceof EntityMagicArrow) && !projectile.func_95999_t().equals("marked") && !ASUtils.attemptConsumeManaFromHand(entity, PHYSICAL_PROJECTILE_CONSUME_AMOUNT)) continue;
                    projectile.func_96094_a("marked");
                    if (projectile instanceof EntityArrow) {
                        ((EntityArrow)projectile).field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
                    }
                    this.onDeflect(entity, projectile);
                    continue;
                }
                projectile.func_96094_a("marked");
            }
        }
    }

    private boolean isProjectileOnGround(Entity projectile) {
        return projectile.field_70170_p.func_184143_b(projectile.func_174813_aQ().func_186662_g(0.05));
    }

    private void onDeflect(EntityLivingBase entity, Entity projectile) {
        this.deflectProjectile(entity, projectile);
        if (entity.field_70170_p.field_72995_K) {
            this.spawnParticle((Entity)entity, projectile);
        }
    }

    private void spawnParticle(Entity entity, Entity projectile) {
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).entity(projectile).pos(0.0, 0.3, 0.0).clr(255, 255, 255).time(5).scale(2.0f).spawn(projectile.field_70170_p);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(projectile.field_70165_t, projectile.field_70163_u, projectile.field_70161_v).clr(255, 255, 235).scale(2.0f).time(5).entity(entity).pos(projectile.func_70040_Z().field_72450_a, (double)entity.func_70047_e(), projectile.func_70040_Z().field_72449_c * -1.0).spawn(entity.field_70170_p);
    }

    private void deflectProjectile(EntityLivingBase entity, Entity projectile) {
        Vec3d centre = entity.func_174824_e(0.0f).func_178786_a(0.0, 0.1, 0.0);
        Vec3d vec = projectile.func_174791_d().func_178788_d(centre).func_72432_b().func_186678_a(0.6);
        projectile.func_70024_g(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }
}

