/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.ritual;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.ritual.IHasItemToRender;
import com.windanesz.ancientspellcraft.ritual.IHasRightClickEffect;
import com.windanesz.ancientspellcraft.ritual.IRitualIngredient;
import com.windanesz.ancientspellcraft.ritual.Ritual;
import com.windanesz.ancientspellcraft.tileentity.TileRune;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Condensing
extends Ritual
implements IRitualIngredient,
IHasItemToRender,
IHasRightClickEffect {
    private ItemStack stack = ItemStack.field_190927_a;
    private String STORED_ITEM_TAG = "stored_item";
    private String GROWTH_PROGRESS_TAG = "growth_progress";

    public Condensing() {
        super("ancientspellcraft", "condensing", SpellActions.SUMMON, false);
    }

    @Override
    public void initialEffect(World world, EntityPlayer caster, TileRune centerPiece) {
        this.ruinNonCenterPieceRunes(centerPiece, world);
    }

    @Override
    public void onRitualFinish(World world, EntityPlayer caster, TileRune centerPiece) {
        if (caster == null || !world.field_72995_K) {
            // empty if block
        }
        super.onRitualFinish(world, caster, centerPiece);
    }

    @Override
    public void effect(World world, EntityPlayer caster, TileRune centerPiece) {
        super.effect(world, caster, centerPiece);
        if (!world.field_72995_K && world.func_82737_E() % 180L == 0L) {
            float progress = 0.0f;
            if (centerPiece.getRitualData().func_74764_b(this.STORED_ITEM_TAG)) {
                this.stack = this.getStoredItem(centerPiece);
                if (centerPiece.getRitualData().func_74764_b(this.GROWTH_PROGRESS_TAG)) {
                    progress = centerPiece.getRitualData().func_74760_g(this.GROWTH_PROGRESS_TAG);
                    if ((progress = this.incrementGrowthTimer(progress)) >= 100.0f) {
                        this.stack = this.growCrystal();
                        progress = 0.0f;
                    }
                }
                NBTTagCompound stackCompound = new NBTTagCompound();
                this.stack.func_77955_b(stackCompound);
                NBTTagCompound comp = centerPiece.getRitualData();
                comp.func_74776_a(this.GROWTH_PROGRESS_TAG, progress);
                comp.func_74782_a(this.STORED_ITEM_TAG, (NBTBase)stackCompound);
                centerPiece.setRitualData(comp);
            } else {
                List entityItemList = EntityUtils.getEntitiesWithinRadius((double)1.0, (double)centerPiece.func_174877_v().func_177958_n(), (double)centerPiece.func_174877_v().func_177956_o(), (double)centerPiece.func_174877_v().func_177952_p(), (World)world, EntityItem.class);
                if (!entityItemList.isEmpty()) {
                    for (EntityItem entityItem : entityItemList) {
                        if ((entityItem.func_92059_d().func_77973_b() != WizardryItems.magic_crystal || entityItem.func_92059_d().func_77960_j() != 0) && entityItem.func_92059_d().func_77973_b() != WizardryItems.crystal_shard && !this.isElementalCrystalShard(entityItem.func_92059_d().func_77973_b())) continue;
                        NBTTagCompound stackCompound = new NBTTagCompound();
                        ItemStack itemStack = new ItemStack(entityItem.func_92059_d().func_77973_b(), 1);
                        itemStack.func_77955_b(stackCompound);
                        NBTTagCompound comp = new NBTTagCompound();
                        comp.func_74782_a(this.STORED_ITEM_TAG, (NBTBase)stackCompound);
                        centerPiece.setRitualData(comp);
                        entityItem.func_92059_d().func_190918_g(1);
                    }
                }
            }
            centerPiece.sendUpdates();
        }
        if (world.field_72995_K && this.getStoredItem(centerPiece) != null && this.getStoredItem(centerPiece) != ItemStack.field_190927_a) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).clr(255, 255, 247).face(EnumFacing.SOUTH).pos((double)centerPiece.getXCenter(), (double)(centerPiece.getYCenter() + 0.3f), (double)centerPiece.getZCenter()).scale(1.0f).spawn(world);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).clr(255, 255, 247).face(EnumFacing.WEST).pos((double)centerPiece.getXCenter(), (double)(centerPiece.getYCenter() + 0.3f), (double)centerPiece.getZCenter()).scale(1.0f).spawn(world);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).clr(255, 255, 247).fade(0, 0, 0).spin((double)0.8f, (double)0.07f).time(40).pos((double)centerPiece.getXCenter(), (double)((float)centerPiece.getY() + 0.1f), (double)centerPiece.getZCenter()).scale(0.2f).spawn(world);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).clr(255, 255, 247).vel(0.0, 0.1, 0.0).fade(0, 0, 0).spin((double)0.8f, (double)0.07f).time(40).pos((double)centerPiece.getXCenter(), (double)((float)centerPiece.getY() + 0.1f), (double)centerPiece.getZCenter()).scale(0.2f).spawn(world);
        }
    }

    private ItemStack growCrystal() {
        Item item = this.stack.func_77973_b();
        if (item == WizardryItems.magic_crystal && this.stack.func_77960_j() == 0) {
            return new ItemStack(WizardryItems.grand_crystal);
        }
        if (item == WizardryItems.crystal_shard) {
            return new ItemStack(WizardryItems.magic_crystal);
        }
        if (item == AncientSpellcraftItems.crystal_shard_sorcery) {
            return new ItemStack(WizardryItems.magic_crystal, Element.SORCERY.ordinal());
        }
        if (item == AncientSpellcraftItems.crystal_shard_necromancy) {
            return new ItemStack(WizardryItems.magic_crystal, Element.NECROMANCY.ordinal());
        }
        if (item == AncientSpellcraftItems.crystal_shard_lightning) {
            return new ItemStack(WizardryItems.magic_crystal, Element.LIGHTNING.ordinal());
        }
        if (item == AncientSpellcraftItems.crystal_shard_ice) {
            return new ItemStack(WizardryItems.magic_crystal, Element.ICE.ordinal());
        }
        if (item == AncientSpellcraftItems.crystal_shard_healing) {
            return new ItemStack(WizardryItems.magic_crystal, Element.HEALING.ordinal());
        }
        if (item == AncientSpellcraftItems.crystal_shard_fire) {
            return new ItemStack(WizardryItems.magic_crystal, Element.FIRE.ordinal());
        }
        if (item == AncientSpellcraftItems.crystal_shard_earth) {
            return new ItemStack(WizardryItems.magic_crystal, Element.EARTH.ordinal());
        }
        return this.stack;
    }

    private float incrementGrowthTimer(float currentProgress) {
        Item item = this.stack.func_77973_b();
        if (item == WizardryItems.magic_crystal && this.stack.func_77960_j() == 0) {
            return currentProgress + 0.25f;
        }
        if (this.isElementalCrystalShard(item) || item == WizardryItems.crystal_shard) {
            return currentProgress + 0.75f;
        }
        return currentProgress;
    }

    @Override
    public List<List<ItemStack>> getRequiredIngredients() {
        ArrayList<List<ItemStack>> ingredients = new ArrayList<List<ItemStack>>();
        ArrayList<ItemStack> condensingUpgrade = new ArrayList<ItemStack>();
        condensingUpgrade.add(new ItemStack(WizardryItems.condenser_upgrade));
        ingredients.add(condensingUpgrade);
        return ingredients;
    }

    @Override
    public boolean onRightClick(TileRune centerPiece, @Nullable EntityLivingBase breakerEntity) {
        if (breakerEntity instanceof EntityPlayer) {
            ItemStack stack = this.getStoredItem(centerPiece);
            if (stack != ItemStack.field_190927_a && stack.func_77973_b() != Items.field_190931_a) {
                if (breakerEntity.field_70170_p.field_72995_K) {
                    return true;
                }
                if (!((EntityPlayer)breakerEntity).field_71071_by.func_70441_a(stack)) {
                    EntityItem entityitem = new EntityItem(centerPiece.func_145831_w(), (double)centerPiece.getXCenter(), (double)centerPiece.getYCenter(), (double)centerPiece.getZCenter(), stack);
                    entityitem.func_174869_p();
                    centerPiece.func_145831_w().func_72838_d((Entity)entityitem);
                }
                this.setStoredItem(ItemStack.field_190927_a, centerPiece);
                return true;
            }
            EntityPlayer player = (EntityPlayer)breakerEntity;
            ItemStack playerStack = player.func_184614_ca();
            if (!centerPiece.func_145831_w().field_72995_K && this.isValidItem(playerStack)) {
                this.setStoredItem(player.func_184614_ca(), centerPiece);
                player.func_184614_ca().func_190918_g(1);
                return true;
            }
        }
        return true;
    }

    private void setStoredItem(ItemStack newItem, TileRune centerPiece) {
        NBTTagCompound ritualData = centerPiece.getRitualData();
        if (ritualData == null) {
            ritualData = new NBTTagCompound();
        }
        ritualData.func_74776_a(this.GROWTH_PROGRESS_TAG, 0.0f);
        ritualData.func_74782_a(this.STORED_ITEM_TAG, (NBTBase)ASUtils.convertToNBTSingeCount(newItem));
        centerPiece.setRitualData(ritualData);
        centerPiece.sendUpdates();
    }

    private ItemStack getStoredItem(TileRune centerPiece) {
        if (centerPiece.getRitualData().func_74764_b(this.STORED_ITEM_TAG)) {
            return new ItemStack(centerPiece.getRitualData().func_74775_l(this.STORED_ITEM_TAG));
        }
        return ItemStack.field_190927_a;
    }

    private boolean isValidItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        return this.isElementalCrystalShard(item) || item == WizardryItems.crystal_shard && stack.func_77960_j() == 0 || item == WizardryItems.magic_crystal && stack.func_77960_j() == 0;
    }

    private boolean isElementalCrystalShard(Item item) {
        return item == AncientSpellcraftItems.crystal_shard_sorcery || item == AncientSpellcraftItems.crystal_shard_necromancy || item == AncientSpellcraftItems.crystal_shard_lightning || item == AncientSpellcraftItems.crystal_shard_ice || item == AncientSpellcraftItems.crystal_shard_healing || item == AncientSpellcraftItems.crystal_shard_fire || item == AncientSpellcraftItems.crystal_shard_earth;
    }

    @Override
    public boolean shouldConsumeIngredients() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderItem(TileRune tileRune, float partialTicks, int destroyStage, float alpha) {
        ItemStack stack;
        if (tileRune.func_145831_w().field_72995_K && (stack = this.getStoredItem(tileRune)) != ItemStack.field_190927_a) {
            float t = (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + partialTicks;
            if (!stack.func_190926_b()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.8f, (float)0.0f);
                GlStateManager.func_179114_b((float)0.0f, (float)1.0f, (float)0.0f, (float)180.0f);
                GlStateManager.func_179114_b((float)t, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.85f, (float)0.85f, (float)0.85f);
                Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.func_179121_F();
            }
        }
    }
}

