/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.ritual;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.packet.ASPacketHandler;
import com.windanesz.ancientspellcraft.packet.PacketContinuousRitual;
import com.windanesz.ancientspellcraft.packet.PacketStartRitual;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftBlocks;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.registry.Rituals;
import com.windanesz.ancientspellcraft.tileentity.TileRune;
import com.windanesz.ancientspellcraft.util.RitualProperties;
import electroblob.wizardry.util.BlockUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class Ritual
extends IForgeRegistryEntry.Impl<Ritual> {
    public static IForgeRegistry<Ritual> registry;
    private RitualProperties globalProperties;
    protected Item[] applicableItems;
    private Set<String> propertyKeys = new HashSet<String>();
    private final String unlocalisedName;
    private RitualProperties properties;
    private boolean enabled = true;
    private static int nextRitualId;
    private final int id;

    public RitualProperties getProperties() {
        return this.properties;
    }

    public Ritual(String modID, String name, EnumAction action, boolean isContinuous) {
        this.setRegistryName(modID, name);
        this.unlocalisedName = this.getRegistryName().toString();
        this.id = nextRitualId++;
        this.items(AncientSpellcraftItems.ritual_book);
    }

    public static List<Ritual> getRituals(Predicate<Ritual> filter) {
        return registry.getValuesCollection().stream().filter(filter.and(s -> s != Rituals.none)).collect(Collectors.toList());
    }

    public static String getRegistryNameString(Ritual ritual) {
        return ritual.getRegistryName().toString();
    }

    public String getDescription() {
        return AncientSpellcraft.proxy.translate(this.getDescriptionTranslationKey(), new Object[0]);
    }

    protected String getDescriptionTranslationKey() {
        return "ritual." + this.unlocalisedName + ".desc";
    }

    public void initialEffect(World world, EntityPlayer caster, TileRune centerPiece) {
    }

    public void effect(World world, EntityPlayer caster, TileRune centerPiece) {
        if (!world.field_72995_K) {
            if (this.isFirstTick(centerPiece)) {
                this.initialEffect(world, caster, centerPiece);
                PacketStartRitual.Message msg = new PacketStartRitual.Message(caster.func_145782_y(), this, centerPiece.getX(), centerPiece.getY(), centerPiece.getZ());
                ASPacketHandler.net.sendToDimension((IMessage)msg, caster.field_70170_p.field_73011_w.getDimension());
                return;
            }
            if (caster != null) {
                PacketContinuousRitual.Message msg = new PacketContinuousRitual.Message(caster.func_145782_y(), this, centerPiece.getX(), centerPiece.getY(), centerPiece.getZ());
                ASPacketHandler.net.sendToDimension((IMessage)msg, caster.field_70170_p.field_73011_w.getDimension());
            }
            if (BlockUtils.canBlockBeReplaced((World)world, (BlockPos)centerPiece.func_174877_v().func_177984_a())) {
                world.func_175656_a(centerPiece.func_174877_v().func_177984_a(), AncientSpellcraftBlocks.MAGELIGHT.func_176223_P());
            }
        }
    }

    public void onRitualFinish(World world, EntityPlayer caster, TileRune centerPiece) {
        if (!world.field_72995_K) {
            List posList = centerPiece.getConnectedRunes().stream().map(TileEntity::func_174877_v).collect(Collectors.toList());
            for (BlockPos pos : posList) {
                if (world.func_180495_p(pos).func_177230_c() != AncientSpellcraftBlocks.PLACED_RUNE) continue;
                world.func_175656_a(pos, AncientSpellcraftBlocks.RUNE_USED.func_176223_P());
            }
        }
    }

    public boolean isFirstTick(TileRune centerPiece) {
        return centerPiece.getRitualCurrentLifeTime() == 1;
    }

    public final NonNullList<Ingredient> getPattern() {
        return this.properties.pattern;
    }

    public final RitualProperties getRitualProperties() {
        return this.properties;
    }

    public final int getMaxLifeTime() {
        return this.properties.lifetime;
    }

    public void init() {
    }

    public final boolean arePropertiesInitialised() {
        return this.properties != null;
    }

    public final String[] getPropertyKeys() {
        return this.propertyKeys.toArray(new String[0]);
    }

    public void setProperties(@Nonnull RitualProperties properties) {
        if (!this.arePropertiesInitialised()) {
            this.properties = properties;
            if (this.globalProperties == null) {
                this.globalProperties = properties;
            }
        } else {
            AncientSpellcraft.logger.info("A mod attempted to set a ritual's properties, but they were already initialised.");
        }
    }

    public static List<Ritual> getAllRituals() {
        return Ritual.getRituals(s -> true);
    }

    public static Ritual byNetworkID(int id) {
        if (id < 0 || id >= registry.getValuesCollection().size()) {
            return Rituals.none;
        }
        return registry.getValuesCollection().stream().filter(s -> s.id == id).findAny().orElse(Rituals.none);
    }

    public final int networkID() {
        return this.id;
    }

    protected void ruinNonCenterPieceRunes(TileRune centerPiece, World world) {
        if (!world.field_72995_K) {
            List alist = centerPiece.getRitualRunes().stream().filter(Objects::nonNull).filter(r -> r != centerPiece).map(TileEntity::func_174877_v).collect(Collectors.toList());
            for (BlockPos pos : alist) {
                if (world.func_180495_p(pos).func_177230_c() != AncientSpellcraftBlocks.PLACED_RUNE) continue;
                world.func_175713_t(pos);
                world.func_175656_a(pos, AncientSpellcraftBlocks.RUNE_USED.func_176223_P());
            }
        }
    }

    public boolean applicableForItem(Item item) {
        return Arrays.asList(this.applicableItems).contains(item);
    }

    public Ritual items(Item ... applicableItems) {
        this.applicableItems = applicableItems;
        return this;
    }

    public NBTTagCompound getNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("ritual", this.getRegistryName().toString());
        return compound;
    }

    public String getDisplayName() {
        return AncientSpellcraft.proxy.translate(this.getTranslationKey(), new Object[0]);
    }

    protected String getTranslationKey() {
        return "ritual." + this.unlocalisedName;
    }

    static {
        nextRitualId = 0;
    }
}

