/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemGlassBottle;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ConjureWater
extends SpellRay {
    private Random rand = new Random();

    public ConjureWater(String modID, String name, EnumAction action, boolean isContinuous) {
        super(modID, name, SpellActions.POINT, false);
        this.soundValues(0.5f, 1.1f, 0.2f);
        this.addProperties(new String[]{"blast_radius"});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        EntityLivingBase entityLivingTarget;
        if (target instanceof EntityLivingBase && !(entityLivingTarget = (EntityLivingBase)target).func_70648_aU() && !entityLivingTarget.func_70644_a(MobEffects.field_76427_o)) {
            entityLivingTarget.func_70097_a(DamageSource.field_76369_e, ConjureWater.isWaterSensitiveEntity(entityLivingTarget) ? 2.0f : 1.0f);
            return true;
        }
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (!EntityUtils.canDamageBlocks((Entity)caster, (World)world)) {
            return false;
        }
        Item offhandItemItem = caster.func_184592_cb().func_77973_b();
        if (offhandItemItem instanceof ItemBucket || offhandItemItem instanceof ItemGlassBottle) {
            return this.onMiss(world, caster, origin, hit, ticksInUse, modifiers);
        }
        if (caster.field_70170_p.field_73011_w.getDimension() == -1) {
            return false;
        }
        int waterRadius = (int)((float)this.getProperty("blast_radius").intValue() * modifiers.get(WizardryItems.blast_upgrade));
        boolean createdWater = false;
        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-waterRadius, -waterRadius, -waterRadius), (BlockPos)pos.func_177982_a(waterRadius, waterRadius, waterRadius))) {
            if (currPos.func_177956_o() > pos.func_177956_o() || world.func_180495_p(currPos).func_177230_c() == Blocks.field_150355_j) continue;
            IBlockState iblockstate = world.func_180495_p(currPos = currPos.func_177972_a(side));
            Material material = iblockstate.func_185904_a();
            boolean flag = !material.func_76220_a();
            boolean flag1 = iblockstate.func_177230_c().func_176200_f((IBlockAccess)world, currPos);
            if (!world.func_175623_d(currPos) && !flag && !flag1) continue;
            if (!(world.field_72995_K || !flag && !flag1 || material.func_76224_d() && world.func_180495_p(currPos).func_177230_c() != Blocks.field_150355_j)) {
                world.func_175655_b(currPos, true);
                world.func_175656_a(currPos, Blocks.field_150355_j.func_176223_P());
                world.func_180495_p(currPos).func_177230_c().func_189540_a(world.func_180495_p(currPos), world, currPos, (Block)Blocks.field_150355_j, currPos);
                createdWater = true;
            }
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187917_gq, SoundCategory.BLOCKS, 0.5f, this.rand.nextFloat() * 0.4f + 0.8f, false);
        }
        return createdWater;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer) {
            EntityPlayer playerIn = (EntityPlayer)caster;
            ItemStack stack = caster.func_184592_cb();
            if (stack.func_77973_b() instanceof ItemGlassBottle) {
                stack.func_190918_g(1);
                ItemStack potionStack = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b);
                world.func_184148_a(playerIn, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                if (stack.func_190926_b()) {
                    playerIn.func_184611_a(EnumHand.OFF_HAND, potionStack);
                } else if (!playerIn.field_71071_by.func_70441_a(potionStack)) {
                    playerIn.func_71019_a(potionStack, false);
                }
                return true;
            }
            if (stack.func_77973_b() instanceof ItemBucket) {
                stack.func_190918_g(1);
                ItemStack waterBucket = new ItemStack(Items.field_151131_as);
                world.func_184148_a(playerIn, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187630_M, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                if (stack.func_190926_b()) {
                    playerIn.func_184611_a(EnumHand.OFF_HAND, waterBucket);
                } else if (!playerIn.field_71071_by.func_70441_a(waterBucket)) {
                    playerIn.func_71019_a(waterBucket, false);
                }
                return true;
            }
        }
        return false;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        float brightness = world.field_73012_v.nextFloat();
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_BUBBLE).pos(x, y, z).vel(vx, vy, vz).time(8 + world.field_73012_v.nextInt(12)).clr(0.4f + 0.6f * brightness, 0.6f + 0.4f * brightness, 1.0f).collide(true).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_BUBBLE).pos(x, y, z).vel(vx, vy, vz).time(8 + world.field_73012_v.nextInt(12)).collide(true).spawn(world);
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }

    private static boolean isWaterSensitiveEntity(EntityLivingBase entity) {
        return entity instanceof EntityEnderman || entity instanceof EntityBlaze;
    }
}

