/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.google.common.base.Predicate;
import com.windanesz.ancientspellcraft.entity.ai.EntityAIWizardFollowPlayer;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class Covenant
extends SpellRay {
    public static final IStoredVariable<UUID> ALLIED_WIZARD_UUID_KEY = IStoredVariable.StoredVariable.ofUUID((String)"alliedWizardUUID", (Persistence)Persistence.ALWAYS);

    public Covenant() {
        super("ancientspellcraft", "covenant", SpellActions.SUMMON, false);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{ALLIED_WIZARD_UUID_KEY});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer && target instanceof EntityWizard) {
            EntityPlayer player = (EntityPlayer)caster;
            EntityWizard wizard = (EntityWizard)target;
            WizardData data = WizardData.get((EntityPlayer)player);
            boolean changeStatus = true;
            if (!world.field_72995_K) {
                boolean flag2;
                Entity oldWizard = EntityUtils.getEntityByUUID((World)world, (UUID)((UUID)data.getVariable(ALLIED_WIZARD_UUID_KEY)));
                boolean flag1 = oldWizard != null && oldWizard != wizard;
                boolean bl = flag2 = wizard == oldWizard && Covenant.isAlreadyFollowing(wizard);
                if (flag1 || flag2) {
                    if (flag2) {
                        changeStatus = false;
                    }
                    Covenant.endAlliance((EntityWizard)oldWizard);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:covenant.no_longer_following", new Object[]{oldWizard.func_145748_c_()}), false);
                }
                if (changeStatus && !Covenant.isAlreadyFollowing(wizard)) {
                    Covenant.allyWithWizard(player, wizard);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:covenant.following", new Object[]{wizard.func_145748_c_()}), true);
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    private static void endAlliance(EntityWizard wizard) {
        for (EntityAITasks.EntityAITaskEntry entityaitasks$entityaitaskentry : wizard.field_70714_bg.field_75782_a) {
            EntityAIBase entityAIBase = entityaitasks$entityaitaskentry.field_75733_a;
            if (!(entityAIBase instanceof EntityAIWizardFollowPlayer)) continue;
            wizard.field_70714_bg.func_85156_a(entityAIBase);
        }
    }

    private static void allyWithWizard(EntityPlayer player, EntityWizard wizard) {
        EntityAIWizardFollowPlayer task = new EntityAIWizardFollowPlayer(wizard, 1.0, 6.0f, 10.0f, player);
        wizard.field_70714_bg.func_75776_a(2, (EntityAIBase)task);
        EntityAINearestAttackableTarget targetTask = null;
        EntityAIHurtByTarget hurtByTask = null;
        boolean foundTargetTask = false;
        boolean foundHurtByTask = false;
        for (EntityAITasks.EntityAITaskEntry entityaitasks$entityaitaskentry : wizard.field_70715_bh.field_75782_a) {
            EntityAIBase entityaibase = entityaitasks$entityaitaskentry.field_75733_a;
            if (entityaibase instanceof EntityAINearestAttackableTarget) {
                targetTask = (EntityAINearestAttackableTarget)entityaibase;
                foundTargetTask = true;
            }
            if (!(entityaibase instanceof EntityAIHurtByTarget)) continue;
            hurtByTask = (EntityAIHurtByTarget)entityaibase;
            foundHurtByTask = true;
        }
        if (foundTargetTask) {
            wizard.field_70715_bh.func_85156_a(targetTask);
            EntityAINearestAttackableTarget newTargetTask = new EntityAINearestAttackableTarget((EntityCreature)wizard, EntityLiving.class, 0, false, true, Covenant.getNewTargetSelector(wizard, player));
            wizard.field_70715_bh.func_75776_a(0, (EntityAIBase)newTargetTask);
        }
        if (foundHurtByTask) {
            wizard.field_70715_bh.func_85156_a(hurtByTask);
        }
        WizardData data = WizardData.get((EntityPlayer)player);
        data.setVariable(ALLIED_WIZARD_UUID_KEY, (Object)wizard.func_110124_au());
    }

    private static Predicate<Entity> getNewTargetSelector(EntityWizard wizard, EntityPlayer thePlayer) {
        return entity -> entity != null && !entity.func_82150_aj() && AllyDesignationSystem.isValidTarget((Entity)wizard, (Entity)entity) && entity != thePlayer && (entity instanceof IMob || entity instanceof ISummonedCreature || Arrays.asList(Wizardry.settings.summonedCreatureTargetsWhitelist).contains(EntityList.func_191306_a(entity.getClass()))) && !Arrays.asList(Wizardry.settings.summonedCreatureTargetsBlacklist).contains(EntityList.func_191306_a(entity.getClass()));
    }

    private static boolean isAlreadyFollowing(EntityWizard wizard) {
        for (EntityAITasks.EntityAITaskEntry entityaitasks$entityaitaskentry : wizard.field_70714_bg.field_75782_a) {
            EntityAIBase entityAIBase = entityaitasks$entityaitaskentry.field_75733_a;
            if (!(entityAIBase instanceof EntityAIWizardFollowPlayer)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onCheckSpawnEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !event.getWorld().field_72995_K) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            WizardData data = WizardData.get((EntityPlayer)player);
            Entity storedWizard = EntityUtils.getEntityByUUID((World)event.getWorld(), (UUID)((UUID)data.getVariable(ALLIED_WIZARD_UUID_KEY)));
            if (storedWizard != null && !Covenant.isAlreadyFollowing((EntityWizard)storedWizard)) {
                Covenant.allyWithWizard(player, (EntityWizard)storedWizard);
            }
        }
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

