/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.block.BlockCrystalMine;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftBlocks;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.tileentity.TileEntityPlayerSave;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class CrystalMine
extends SpellRay {
    public CrystalMine() {
        super("ancientspellcraft", "crystal_mine", SpellActions.POINT, false);
        this.soundValues(1.0f, 1.4f, 0.4f);
        this.ignoreLivingEntities(true);
        this.addProperties(new String[]{"damage"});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        boolean detonated = false;
        List blockPosList = BlockUtils.getBlockSphere((BlockPos)pos, (double)10.0);
        for (BlockPos blockPos : blockPosList) {
            TileEntity tileEntity;
            if (world.func_180495_p(blockPos).func_177230_c() != AncientSpellcraftBlocks.CRYSTAL_MINE || !((tileEntity = world.func_175625_s(blockPos)) instanceof TileEntityPlayerSave) || ((TileEntityPlayerSave)tileEntity).getCaster() == null || ((TileEntityPlayerSave)tileEntity).getCaster() != caster) continue;
            ((BlockCrystalMine)world.func_180495_p(blockPos).func_177230_c()).explode(world, blockPos, (Entity)caster);
            detonated = true;
        }
        if (detonated) {
            return true;
        }
        if (side == EnumFacing.UP && world.isSideSolid(pos, EnumFacing.UP) && BlockUtils.canBlockBeReplaced((World)world, (BlockPos)pos.func_177984_a())) {
            if (!world.field_72995_K) {
                world.func_175656_a(pos.func_177984_a(), AncientSpellcraftBlocks.CRYSTAL_MINE.func_176223_P());
                ((TileEntityPlayerSave)world.func_175625_s(pos.func_177984_a())).setCaster(caster);
                ((TileEntityPlayerSave)world.func_175625_s(pos.func_177984_a())).sync();
            }
            return true;
        }
        return false;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        float brightness = world.field_73012_v.nextFloat() * 0.25f;
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, -0.01, 0.0).time(40 + world.field_73012_v.nextInt(10)).spawn(world);
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

