/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftPotions;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.Location;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class DimensionalAnchor
extends SpellRay {
    private static final String LOCATION_TAG = "location_data";
    public static final IStoredVariable<NBTTagCompound> DIMENSION_ANCHOR_DATA = IStoredVariable.StoredVariable.ofNBT((String)"dimension_anchor_data", (Persistence)Persistence.DIMENSION_CHANGE);
    public static List<String> teleportationSpellList = Arrays.asList("ebwizardry:phase_step", "ebwizardry:blink", "ebwizardry:transportation", "ebwizardry:transience", "ancientspellcraft:transportation_portal", "ancientspellcraft:pocket_dimension", "ancientspellcraft:hellgate");

    public DimensionalAnchor() {
        super("ancientspellcraft", "dimensional_anchor", SpellActions.POINT, false);
        this.soundValues(1.0f, 1.1f, 0.2f);
        this.addProperties(new String[]{"effect_duration"});
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{DIMENSION_ANCHOR_DATA});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (EntityUtils.isLiving((Entity)target)) {
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(AncientSpellcraftPotions.dimensional_anchor, this.getProperty("effect_duration").intValue(), 0));
        }
        return true;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(1235712).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(544002).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).time(12 + world.field_73012_v.nextInt(8)).clr(740160).spawn(world);
    }

    public static boolean shouldPreventSpell(EntityLivingBase entity, World world, Spell spell) {
        boolean preventCast = false;
        if (entity != null && world != null && entity.func_70644_a(AncientSpellcraftPotions.dimensional_anchor) && (preventCast = teleportationSpellList.contains(spell.getRegistryName().toString())) && entity instanceof EntityPlayer && !world.field_72995_K) {
            ((EntityPlayer)entity).func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:dimensional_anchor.prevent_spell", new Object[0]), false);
        }
        return preventCast;
    }

    public static void storePlayerLocationData(EntityPlayer player) {
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a(LOCATION_TAG, (NBTBase)new Location(player.func_180425_c(), player.field_71093_bK).toNBT());
            data.setVariable(DIMENSION_ANCHOR_DATA, (Object)compound);
            data.sync();
        }
    }

    public static void purgeLocationData(EntityPlayer player) {
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null) {
            data.setVariable(DIMENSION_ANCHOR_DATA, null);
            data.sync();
        }
    }

    @Nullable
    public static Location getPlayerLocationData(EntityPlayer player) {
        NBTTagCompound compound;
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null && (compound = (NBTTagCompound)data.getVariable(DIMENSION_ANCHOR_DATA)) != null && compound.func_74764_b(LOCATION_TAG)) {
            return Location.fromNBT((NBTTagCompound)((NBTTagCompound)compound.func_74781_a(LOCATION_TAG)));
        }
        return null;
    }

    @SubscribeEvent
    public static void onEnderTeleportEvent(EnderTeleportEvent event) {
        if (event.getEntityLiving().func_70644_a(AncientSpellcraftPotions.dimensional_anchor) && event.isCancelable()) {
            if (event.getEntityLiving() instanceof EntityPlayer && !event.getEntityLiving().field_70170_p.field_72995_K) {
                ((EntityPlayer)event.getEntityLiving()).func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:dimensional_anchor.prevent_ender_pearl", new Object[0]), false);
            }
            event.setCanceled(true);
        }
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

