/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.entity.projectile.EntityIceShard;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class FrostNova
extends Spell {
    private static final String SHARD_COUNT = "shard_count";
    private static final String FREEZE_RADIUS = "freeze_radius";

    public FrostNova() {
        super("ancientspellcraft", "frost_nova", SpellActions.SUMMON, true);
        this.soundValues(1.0f, 1.2f, 0.2f);
        this.addProperties(new String[]{SHARD_COUNT, FREEZE_RADIUS});
    }

    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        if (ticksInUse < 40) {
            if (world.field_72995_K) {
                this.spawnParticles(world, (EntityLivingBase)caster, modifiers);
            }
            return true;
        }
        if (ticksInUse > 40) {
            return false;
        }
        if (!world.field_72995_K) {
            caster.field_70172_ad = 10;
            for (int i = 0; i < this.getProperty(SHARD_COUNT).intValue(); ++i) {
                double dx = world.field_73012_v.nextDouble() - 0.5;
                double dz = world.field_73012_v.nextDouble() - 0.5;
                EntityIceShard iceshard = new EntityIceShard(world);
                iceshard.func_70107_b(caster.field_70165_t + dx, caster.field_70163_u + 1.0, caster.field_70161_v + dz);
                iceshard.field_70159_w = dx * 2.5;
                iceshard.field_70181_x = 0.2;
                iceshard.field_70179_y = dz * 2.5;
                iceshard.setCaster((EntityLivingBase)caster);
                world.func_72838_d((Entity)iceshard);
            }
            for (EntityLivingBase entity : EntityUtils.getEntitiesWithinRadius((double)this.getProperty(FREEZE_RADIUS).intValue(), (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)caster.field_70170_p, EntityLivingBase.class)) {
                if (entity == caster || AllyDesignationSystem.isAllied((EntityLivingBase)caster, (EntityLivingBase)entity) || MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FROST, (Entity)entity)) continue;
                entity.func_70690_d(new PotionEffect(WizardryPotions.frost, Spells.ice_shard.getProperty("effect_duration").intValue(), Spells.ice_shard.getProperty("effect_strength").intValue()));
            }
            if (caster.func_184587_cr()) {
                caster.func_184597_cx();
            }
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    protected void spawnParticles(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        for (int i = 0; i < 10; ++i) {
            double dx = world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
            double dy = world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
            double dz = world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.ICE).entity((Entity)caster).pos(0.0, (double)(caster.field_70131_O / 2.0f), 0.0).vel(dx * 0.3, dy * 0.3, dz * 0.3).spawn(world);
        }
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

