/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class HandOfGaia
extends Spell {
    private static String MAX_AFFECTED_ENTITIES = "max_affected_entities";

    public HandOfGaia() {
        super("ancientspellcraft", "hand_of_gaia", SpellActions.SUMMON, true);
        this.addProperties(new String[]{"effect_radius"});
        this.addProperties(new String[]{MAX_AFFECTED_ENTITIES});
        this.soundValues(1.0f, 1.1f, 0.1f);
    }

    public boolean requiresPacket() {
        return false;
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        double radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
        this.playSound(world, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, ticksInUse, 0, modifiers, new String[0]);
        List targets = EntityUtils.getEntitiesWithinRadius((double)radius, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)world, EntityLivingBase.class);
        int entityCount = this.getProperty(MAX_AFFECTED_ENTITIES).intValue();
        for (EntityLivingBase target : targets) {
            if (entityCount <= 0) {
                return true;
            }
            if (AllyDesignationSystem.isAllied((EntityLivingBase)caster, (EntityLivingBase)target)) {
                --entityCount;
                target.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 30, 0));
            }
            if (!world.field_72995_K) continue;
            if (world.func_82737_E() % 2L == 0L) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).entity((Entity)target).time(20).pos(0.0, (double)caster.func_70047_e() - 0.25, 0.0).clr(201, 90, 168).spawn(world);
            }
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.VINE).entity((Entity)caster).time(60).pos(0.0, (double)caster.func_70047_e() - 0.25, 0.0).target((Entity)target).seed(world.func_82737_E() - (long)ticksInUse).spawn(world);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.GUARDIAN_BEAM).entity((Entity)caster).time(60).pos(0.0, (double)caster.func_70047_e() - 0.25, 0.0).target((Entity)target).clr(139, 8, 168).spawn(world);
        }
        return true;
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

