/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.google.common.base.Predicate;
import com.windanesz.ancientspellcraft.item.ItemNewArtefact;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.living.EntitySpiritHorse;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="ancientspellcraft")
public class HorseWhistle
extends Spell {
    public static final IStoredVariable<UUID> LAST_HORSE_UUID_KEY = IStoredVariable.StoredVariable.ofUUID((String)"lastHorseUUID", (Persistence)Persistence.ALWAYS);
    private static final Predicate<Entity> HORSE = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity instanceof AbstractHorse && !entity.func_184207_aI();
        }
    };

    public HorseWhistle() {
        super("ancientspellcraft", "horse_whistle", SpellActions.POINT_UP, false);
        this.soundValues(1.0f, 1.4f, 0.4f);
        this.addProperties(new String[]{"range"});
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{LAST_HORSE_UUID_KEY});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (caster.func_184218_aH() && caster.func_184187_bx() instanceof EntityHorse && ItemNewArtefact.isNewArtefactActive(caster, AncientSpellcraftItems.belt_horse)) {
            EntityHorse horse = (EntityHorse)caster.func_184187_bx();
            horse.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 600, 0));
            if (world.field_72995_K) {
                for (int i = 0; i < 4; ++i) {
                    double x = horse.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                    double y = horse.field_70163_u + (double)caster.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
                    double z = horse.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).clr(MobEffects.field_76424_c.func_76401_j()).spawn(world);
                }
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BUFF).entity((Entity)horse).clr(MobEffects.field_76424_c.func_76401_j()).spawn(world);
            }
            return true;
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        if (!world.field_72995_K) {
            WizardData data = WizardData.get((EntityPlayer)caster);
            Entity oldHorse = EntityUtils.getEntityByUUID((World)world, (UUID)((UUID)data.getVariable(LAST_HORSE_UUID_KEY)));
            if (oldHorse != null) {
                this.callHorse(caster, (EntityHorse)oldHorse);
                return true;
            }
            AbstractHorse abstracthorse = this.getClosestHorse((Entity)caster, world, 100.0);
            double radius = 100.0;
            List horses = EntityUtils.getEntitiesWithinRadius((double)radius, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)world, AbstractHorse.class);
            for (AbstractHorse horse : horses) {
                if (horse.func_184780_dh() != caster.func_110124_au()) continue;
                this.callHorse(caster, (EntityHorse)horse);
                data.setVariable(LAST_HORSE_UUID_KEY, (Object)horse.func_110124_au());
                return true;
            }
        }
        return true;
    }

    private void callHorse(EntityPlayer caster, EntityHorse horse) {
        if (!horse.func_184207_aI()) {
            if (horse.func_70032_d((Entity)caster) > 20.0f) {
                HorseWhistle.tryTeleportToOwner(horse, caster);
            }
            horse.func_70661_as().func_75499_g();
            horse.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
            horse.func_70661_as().func_75492_a(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, 1.7);
        }
    }

    @Nullable
    protected AbstractHorse getClosestHorse(Entity entityIn, World world, double distance) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        for (Entity entity1 : world.func_175674_a(entityIn, entityIn.func_174813_aQ().func_72321_a(distance, distance, distance), HORSE)) {
            double d1 = entity1.func_70092_e(entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v);
            if (!(d1 < d0)) continue;
            entity = entity1;
            d0 = d1;
        }
        return (AbstractHorse)entity;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }

    @SubscribeEvent
    public static void onEntityMountEvent(EntityMountEvent event) {
        if (event.getEntityMounting() instanceof EntityPlayer && event.getEntityBeingMounted() instanceof EntityHorse && !(event.getEntityBeingMounted() instanceof EntitySpiritHorse)) {
            EntityPlayer player = (EntityPlayer)event.getEntityMounting();
            WizardData data = WizardData.get((EntityPlayer)player);
            if (!player.field_70170_p.field_72995_K) {
                data.setVariable(LAST_HORSE_UUID_KEY, (Object)event.getEntityBeingMounted().func_110124_au());
            }
        }
    }

    private static void tryTeleportToOwner(EntityHorse horse, EntityPlayer owner) {
        if (!horse.func_110167_bD() && !horse.func_184218_aH()) {
            BlockPos randomNearbyPos = BlockUtils.findNearbyFloorSpace((Entity)owner, (int)10, (int)3);
            int i = MathHelper.func_76141_d((float)randomNearbyPos.func_177958_n()) - 2;
            int j = MathHelper.func_76141_d((float)randomNearbyPos.func_177952_p()) - 2;
            int k = MathHelper.func_76141_d((float)randomNearbyPos.func_177956_o());
            for (int l = 0; l <= 4; ++l) {
                for (int i1 = 0; i1 <= 4; ++i1) {
                    if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !HorseWhistle.isTeleportFriendlyBlock(i, j, k, l, i1, horse)) continue;
                    horse.func_70012_b((double)((float)(i + l) + 0.5f), (double)k, (double)((float)(j + i1) + 0.5f), horse.field_70177_z, horse.field_70125_A);
                }
            }
        }
    }

    private static boolean isTeleportFriendlyBlock(int x, int z, int y, int xOffset, int zOffset, EntityHorse horse) {
        BlockPos blockpos = new BlockPos(x + xOffset, y - 1, z + zOffset);
        IBlockState iblockstate = horse.field_70170_p.func_180495_p(blockpos);
        return iblockstate.func_193401_d((IBlockAccess)horse.field_70170_p, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID && iblockstate.func_189884_a((Entity)horse) && horse.field_70170_p.func_175623_d(blockpos.func_177984_a()) && horse.field_70170_p.func_175623_d(blockpos.func_177981_b(2));
    }
}

