/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class LivingComet
extends Spell {
    public static final String SPEED = "speed";
    public static final String ACCELERATION = "acceleration";
    private static final double Y_NUDGE_ACCELERATION = 0.075;

    public LivingComet() {
        super("ancientspellcraft", "living_comet", SpellActions.POINT, true);
        this.addProperties(new String[]{SPEED, ACCELERATION});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (caster.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                float x = caster.field_70170_p.field_73012_v.nextFloat();
                x = caster.field_70170_p.field_73012_v.nextBoolean() ? x : x * -1.0f;
                float y = caster.field_70170_p.field_73012_v.nextFloat();
                y = caster.field_70170_p.field_73012_v.nextBoolean() ? y : y * -1.0f;
                float z = caster.field_70170_p.field_73012_v.nextFloat();
                z = caster.field_70170_p.field_73012_v.nextBoolean() ? z : z * -1.0f;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).entity((Entity)caster).pos(0.0, (double)caster.field_70131_O, 0.0).time(6).vel(caster.field_70170_p.field_73012_v.nextGaussian() / 40.0, caster.field_70170_p.field_73012_v.nextDouble() / 40.0, caster.field_70170_p.field_73012_v.nextGaussian() / 40.0).collide(true).scale(3.0f).spawn(caster.field_70170_p);
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).entity((Entity)caster).pos((double)x, (double)(caster.field_70131_O / 2.0f + y), (double)z).time(6).vel(caster.field_70170_p.field_73012_v.nextGaussian() / 40.0, caster.field_70170_p.field_73012_v.nextDouble() / 40.0, caster.field_70170_p.field_73012_v.nextGaussian() / 40.0).collide(true).scale(1.0f).spawn(caster.field_70170_p);
            }
        }
        caster.field_70143_R = 0.0f;
        if (ticksInUse > 40 && caster.field_70122_E) {
            if (!world.field_72995_K) {
                caster.field_70170_p.func_72876_a((Entity)caster, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, 1.8f, true);
            }
            caster.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 60, 0));
            caster.func_184597_cx();
            return true;
        }
        if (!caster.func_184613_cA()) {
            float speed = 2.0f * this.getProperty(SPEED).floatValue() * modifiers.get("potency");
            float acceleration = 2.0f * this.getProperty(ACCELERATION).floatValue() * modifiers.get("potency");
            if (ticksInUse < 20) {
                caster.func_70024_g(0.0, 0.3, 0.0);
            }
            if (ticksInUse > 20 && (Math.abs(caster.field_70159_w) < (double)speed || caster.field_70159_w / caster.func_70040_Z().field_72450_a < 0.0) && (Math.abs(caster.field_70179_y) < (double)speed || caster.field_70179_y / caster.func_70040_Z().field_72449_c < 0.0)) {
                caster.func_70024_g(caster.func_70040_Z().field_72450_a * (double)acceleration * 2.0, 0.0, caster.func_70040_Z().field_72449_c * (double)acceleration * 2.0);
            }
            if (ticksInUse > 100 && (Math.abs(caster.field_70181_x) < (double)speed || caster.field_70181_x / caster.func_70040_Z().field_72448_b < 0.0)) {
                caster.field_70181_x += caster.func_70040_Z().field_72448_b * (double)(acceleration + (float)(ticksInUse / 20)) + 0.075;
            }
            if (!Wizardry.settings.replaceVanillaFallDamage) {
                caster.field_70143_R = 0.0f;
            }
        }
        if (world.field_72995_K) {
            double x = caster.field_70165_t - 1.0 + world.field_73012_v.nextDouble() * 2.0;
            double y = caster.field_70163_u + (double)caster.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
            double z = caster.field_70161_v - 1.0 + world.field_73012_v.nextDouble() * 2.0;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).pos(x, y, z).vel(0.0, -0.1, 0.0).time(15).spawn(world);
            x = caster.field_70165_t - 1.0 + world.field_73012_v.nextDouble() * 2.0;
            y = caster.field_70163_u + (double)caster.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
            z = caster.field_70161_v - 1.0 + world.field_73012_v.nextDouble() * 2.0;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).pos(x, y, z).vel(0.0, -0.1, 0.0).time(15).spawn(world);
        }
        if (ticksInUse % 24 == 0) {
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        }
        return true;
    }

    public void finishCasting(World world, @Nullable EntityLivingBase caster, double x, double y, double z, @Nullable EnumFacing direction, int duration, SpellModifiers modifiers) {
        if (!caster.func_70644_a(MobEffects.field_76441_p)) {
            // empty if block
        }
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

