/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.entity.construct.EntityBuilder;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftBlocks;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MagmaShell
extends Spell {
    public MagmaShell() {
        super("ancientspellcraft", "magma_shell", SpellActions.SUMMON, false);
        this.soundValues(1.0f, 1.2f, 0.2f);
        this.addProperties(new String[]{"blast_radius", "effect_duration"});
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return true;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        return false;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return this.createShell(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return this.createShell(world, (EntityLivingBase)caster, hand, ticksInUse, modifiers);
    }

    private boolean createShell(World world, EntityLivingBase caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (caster.field_70122_E) {
            if (!world.field_72995_K) {
                for (EntityLivingBase currentTarget : EntityUtils.getEntitiesWithinRadius((double)4.0, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)caster.field_70170_p, EntityLivingBase.class)) {
                    if (!AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)currentTarget) || MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FROST, (Entity)currentTarget)) continue;
                    EntityUtils.applyStandardKnockback((Entity)caster, (EntityLivingBase)currentTarget);
                }
                EntityBuilder builder = new EntityBuilder(world);
                builder.func_70107_b(caster.func_180425_c().func_177958_n(), caster.func_180425_c().func_177956_o(), caster.func_180425_c().func_177952_p());
                builder.setCaster(caster);
                builder.lifetime = 600;
                builder.blockLifetime = (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
                builder.buildTickRate = 1;
                builder.batchSize = (int)(2.0f * modifiers.get("potency")) + (int)(3.0f * modifiers.get(WizardryItems.blast_upgrade));
                List<BlockPos> list = this.getShellBlocks(caster, modifiers);
                list.sort(Comparator.comparingInt(Vec3i::func_177956_o));
                builder.setBuildList(list);
                builder.setBlockToBuild(AncientSpellcraftBlocks.CONJURED_MAGMA.func_176223_P());
                world.func_72838_d((Entity)builder);
            }
            return true;
        }
        return false;
    }

    private List<BlockPos> getShellBlocks(EntityLivingBase caster, SpellModifiers modifiers) {
        List largeFilledSphere = BlockUtils.getBlockSphere((BlockPos)caster.func_180425_c().func_177984_a(), (double)((float)this.getProperty("blast_radius").intValue() * modifiers.get(WizardryItems.blast_upgrade)));
        List smallFilledSphere = BlockUtils.getBlockSphere((BlockPos)caster.func_180425_c().func_177984_a(), (double)((float)(this.getProperty("blast_radius").intValue() - 1) * modifiers.get(WizardryItems.blast_upgrade)));
        ArrayList<BlockPos> hollowSphere = new ArrayList<BlockPos>();
        for (BlockPos pos : largeFilledSphere) {
            if (smallFilledSphere.contains(pos)) continue;
            hollowSphere.add(pos);
        }
        return hollowSphere;
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

