/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.block.BlockMagicMushroom;
import com.windanesz.ancientspellcraft.entity.construct.EntitySpellTicker;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.spell.ISpellTickerConstruct;
import electroblob.wizardry.entity.construct.EntityMagicConstruct;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.spell.SpellConstruct;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MushroomForest
extends SpellConstruct<EntitySpellTicker>
implements ISpellTickerConstruct {
    public MushroomForest() {
        super("ancientspellcraft", "mushroom_forest", SpellActions.SUMMON, EntitySpellTicker::new, false);
        this.addProperties(new String[]{"effect_radius"});
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }

    protected void addConstructExtras(EntitySpellTicker construct, EnumFacing side, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        super.addConstructExtras((EntityMagicConstruct)construct, side, caster, modifiers);
        int individualMushroomDuration = (int)(2.0f * this.getProperty("duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
        construct.setDuration(individualMushroomDuration);
        construct.setModifiers(modifiers);
        construct.setSpell((Spell)this);
    }

    @Override
    public void onUpdate(World world, EntitySpellTicker entity) {
        BlockPos pos;
        BlockMagicMushroom mushroom = BlockMagicMushroom.getRandomMushroom(0.05f, 0.03f);
        int radius = (int)this.getProperty("effect_radius").doubleValue();
        int i = 10;
        while ((pos = BlockUtils.findNearbyFloorSpace((World)world, (BlockPos)entity.func_180425_c(), (int)radius, (int)10)) != null && !BlockMagicMushroom.tryPlaceMushroom(world, pos, entity.getCaster(), mushroom, entity.getDuration(), entity.getModifiers()) && --i > 0) {
        }
    }

    @Override
    public IBlockState getBlock(World world, EntitySpellTicker entityMushroomForest) {
        return null;
    }
}

