/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class PrismaticSpray
extends Spell {
    protected static final double Y_OFFSET = 0.25;

    public PrismaticSpray() {
        super("ancientspellcraft", "prismatic_spray", SpellActions.SUMMON, false);
        this.addProperties(new String[]{"blast_radius", "direct_damage", "effect_duration"});
        this.soundValues(1.0f, 1.0f, 0.1f);
    }

    public boolean requiresPacket() {
        return false;
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        boolean foundTarget = false;
        if (!ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)AncientSpellcraftItems.charm_prismatic_spray)) {
            Random rnd = new Random(42L);
            double radius = this.getProperty("blast_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
            List targets = EntityUtils.getEntitiesWithinRadius((double)radius, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)world, EntityLivingBase.class);
            ArrayList<Element> beamTypes = new ArrayList<Element>(EnumSet.allOf(Element.class));
            beamTypes.remove(0);
            for (EntityLivingBase target : targets) {
                if (target == caster) continue;
                foundTarget = true;
                int currIndex = (int)(rnd.nextFloat() * (float)beamTypes.size());
                while (beamTypes.get(currIndex) == Element.MAGIC) {
                    currIndex = (int)(rnd.nextFloat() * (float)beamTypes.size());
                }
                Element element = beamTypes.get(currIndex);
                this.performEffect(element, caster, target, modifiers);
                beamTypes.remove(currIndex);
                if (!beamTypes.isEmpty()) continue;
                break;
            }
            if (!foundTarget && !caster.field_70170_p.field_72995_K) {
                caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getRegistryName() + ".no_target", new Object[0]), true);
            }
        } else {
            double range;
            Vec3d endpoint;
            float damage = (float)this.getProperty("direct_damage").intValue() * modifiers.get("potency");
            int duration = (int)((float)this.getProperty("effect_duration").intValue() * modifiers.get(WizardryItems.duration_upgrade));
            Vec3d look = caster.func_70040_Z();
            Vec3d origin = new Vec3d(caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e() - 0.25, caster.field_70161_v);
            RayTraceResult rayTrace = RayTracer.rayTrace((World)world, (Vec3d)origin, (Vec3d)(endpoint = origin.func_178787_e(look.func_186678_a(range = this.getRange(world, origin, look, (EntityLivingBase)caster, ticksInUse, modifiers)))), (float)0.0f, (boolean)false, (boolean)true, (boolean)false, Entity.class, (Predicate)RayTracer.ignoreEntityFilter((Entity)caster));
            if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.ENTITY) {
                boolean flag = this.onEntityHit(world, rayTrace.field_72308_g, rayTrace.field_72307_f, (EntityLivingBase)caster, origin, ticksInUse, modifiers);
                if (flag) {
                    range = origin.func_72438_d(rayTrace.field_72307_f);
                }
                if (rayTrace.field_72308_g instanceof EntityLivingBase) {
                    foundTarget = true;
                    int precision = 7;
                    float radius = 2.0f;
                    EntityLivingBase target = (EntityLivingBase)rayTrace.field_72308_g;
                    for (int i = 0; i < precision; ++i) {
                        double p1 = (double)i * Math.PI / (double)(precision / 2);
                        double x1 = caster.field_70165_t;
                        double y1 = caster.field_70163_u + (double)caster.func_70047_e() + Math.cos(p1) * (double)radius;
                        double z1 = caster.field_70161_v;
                        Vec3d endpoint2 = new Vec3d(x1, y1, z1);
                        if (i == 0) {
                            this.spawnBeamFocused(world, origin, look, endpoint2, (EntityLivingBase)caster, target, range, Element.EARTH, 58, 92, 24);
                        }
                        if (i == 1) {
                            this.spawnBeamFocused(world, origin, look, endpoint2, (EntityLivingBase)caster, target, range, Element.LIGHTNING, 70, 76, 163);
                        }
                        if (i == 2) {
                            this.spawnBeamFocused(world, origin, look, endpoint2, (EntityLivingBase)caster, target, range, Element.NECROMANCY, 99, 9, 93);
                        }
                        if (i == 3) {
                            this.spawnBeamFocused(world, origin, look, endpoint2, (EntityLivingBase)caster, target, range, Element.FIRE, 252, 118, 23);
                        }
                        if (i == 4) {
                            this.spawnBeamFocused(world, origin, look, endpoint2, (EntityLivingBase)caster, target, range, Element.HEALING, 253, 255, 122);
                        }
                        if (i == 5) {
                            this.spawnBeamFocused(world, origin, look, endpoint2, (EntityLivingBase)caster, target, range, Element.SORCERY, 0, 222, 23);
                        }
                        if (i != 6) continue;
                        this.spawnBeamFocused(world, origin, look, endpoint2, (EntityLivingBase)caster, target, range, Element.ICE, 144, 236, 252);
                    }
                    EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.MAGIC), (float)(damage * 1.5f));
                    target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, duration));
                    target.func_70690_d(new PotionEffect(WizardryPotions.paralysis, duration, 0));
                    target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, duration));
                    target.func_70690_d(new PotionEffect(MobEffects.field_76440_q, duration, 0));
                    target.func_70690_d(new PotionEffect(WizardryPotions.frost, duration, 0));
                    target.func_70015_d(duration / 20);
                }
            }
        }
        if (foundTarget) {
            this.playSound(world, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, 0, 0, modifiers, new String[0]);
        }
        return foundTarget;
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    private void performEffect(Element element, EntityPlayer caster, EntityLivingBase target, SpellModifiers modifiers) {
        float damage = (float)this.getProperty("direct_damage").intValue() * modifiers.get("potency");
        int duration = (int)((float)this.getProperty("effect_duration").intValue() * modifiers.get(WizardryItems.duration_upgrade));
        Vec3d look = caster.func_70040_Z();
        Vec3d origin = new Vec3d(caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e() - 0.25, caster.field_70161_v);
        if (caster.field_70170_p.field_72995_K && !Wizardry.proxy.isFirstPerson((Entity)caster)) {
            origin = origin.func_178787_e(look.func_186678_a(1.2));
        }
        double range = caster.func_70032_d((Entity)target);
        switch (element) {
            case EARTH: {
                EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.POISON), (float)damage);
                target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, duration));
                this.spawnBeam(caster.field_70170_p, origin, look, (EntityLivingBase)caster, target, range, element, 58, 92, 24);
                break;
            }
            case LIGHTNING: {
                EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.SHOCK), (float)damage);
                target.func_70690_d(new PotionEffect(WizardryPotions.paralysis, duration, 0));
                this.spawnBeam(caster.field_70170_p, origin, look, (EntityLivingBase)caster, target, range, element, 70, 76, 163);
                break;
            }
            case NECROMANCY: {
                EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.WITHER), (float)damage);
                target.func_70690_d(new PotionEffect(MobEffects.field_82731_v, duration));
                this.spawnBeam(caster.field_70170_p, origin, look, (EntityLivingBase)caster, target, range, element, 99, 9, 93);
                break;
            }
            case FIRE: {
                EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.FIRE), (float)damage);
                target.func_70015_d(duration / 20);
                this.spawnBeam(caster.field_70170_p, origin, look, (EntityLivingBase)caster, target, range, element, 252, 118, 23);
                break;
            }
            case HEALING: {
                EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.RADIANT), (float)damage);
                target.func_70690_d(new PotionEffect(MobEffects.field_76440_q, duration, 0));
                if (target.func_70662_br()) {
                    target.func_70015_d(duration / 40);
                }
                this.spawnBeam(caster.field_70170_p, origin, look, (EntityLivingBase)caster, target, range, element, 253, 255, 122);
                break;
            }
            case SORCERY: {
                EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.FORCE), (float)damage);
                EntityUtils.applyStandardKnockback((Entity)caster, (EntityLivingBase)target, (float)2.0f);
                this.spawnBeam(caster.field_70170_p, origin, look, (EntityLivingBase)caster, target, range, element, 0, 222, 23);
                break;
            }
            case ICE: {
                EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.FROST), (float)damage);
                target.func_70690_d(new PotionEffect(WizardryPotions.frost, duration, 0));
                this.spawnBeam(caster.field_70170_p, origin, look, (EntityLivingBase)caster, target, range, element, 144, 236, 252);
                break;
            }
        }
    }

    protected void spawnBeam(World world, Vec3d origin, Vec3d direction, EntityLivingBase caster, EntityLivingBase target, double distance, Element element, int r, int g, int b) {
        if (world.field_72995_K) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).entity((Entity)caster).time(40).pos(0.0, (double)caster.func_70047_e() - 0.25, 0.0).target((Entity)target).clr(r, g, b).scale(2.0f).seed(world.func_82737_E()).spawn(world);
        }
    }

    protected void spawnBeamFocused(World world, Vec3d origin, Vec3d direction, Vec3d offset, EntityLivingBase caster, EntityLivingBase target, double distance, Element element, int r, int g, int b) {
        if (world.field_72995_K) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).time(10).pos(offset).target((Entity)target).clr(r, g, b).scale(1.0f).seed(world.func_82737_E()).spawn(world);
        }
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }

    protected double getRange(World world, Vec3d origin, Vec3d direction, @Nullable EntityLivingBase caster, int ticksInUse, SpellModifiers modifiers) {
        return 10.0 * (double)modifiers.get(WizardryItems.range_upgrade);
    }
}

