/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.block.ITemporaryBlock;
import com.windanesz.ancientspellcraft.entity.construct.EntitySpellTicker;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftBlocks;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.spell.ISpellTickerConstruct;
import electroblob.wizardry.entity.construct.EntityMagicConstruct;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.spell.SpellConstruct;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Swamp
extends SpellConstruct<EntitySpellTicker>
implements ISpellTickerConstruct {
    public Swamp() {
        super("ancientspellcraft", "swamp", SpellActions.SUMMON, EntitySpellTicker::new, false);
        this.addProperties(new String[]{"effect_radius"});
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }

    protected void addConstructExtras(EntitySpellTicker construct, EnumFacing side, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        super.addConstructExtras((EntityMagicConstruct)construct, side, caster, modifiers);
        int blockDuration = (int)(this.getProperty("duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
        construct.setDuration(blockDuration);
        construct.setModifiers(modifiers);
        construct.setSpell((Spell)this);
    }

    @Override
    public void onUpdate(World world, EntitySpellTicker entity) {
        int radius = (int)this.getProperty("effect_radius").doubleValue();
        int blockDuration = (int)(2.0f * this.getProperty("duration").floatValue() * entity.getModifiers().get(WizardryItems.duration_upgrade));
        BlockPos pos = BlockUtils.findNearbyFloorSpace((World)world, (BlockPos)entity.func_180425_c(), (int)radius, (int)10);
        boolean shouldPlace = true;
        boolean placed = false;
        if (pos == null) {
            return;
        }
        if (shouldPlace) {
            ITemporaryBlock.placeTemporaryBlock(entity.getCaster(), world, AncientSpellcraftBlocks.QUICKSAND, pos.func_177977_b(), blockDuration);
            placed = true;
        }
        BlockPos prevPos = pos;
        if (placed) {
            for (int i = 0; i < world.field_73012_v.nextInt(4); ++i) {
                pos = BlockUtils.findNearbyFloorSpace((World)world, (BlockPos)prevPos, (int)1, (int)3);
                if (pos == null || entity.getCaster() != null && entity.getCaster().func_180425_c().func_177956_o() == pos.func_177956_o()) continue;
                ITemporaryBlock.placeTemporaryBlock(entity.getCaster(), world, AncientSpellcraftBlocks.QUICKSAND, pos.func_177977_b(), blockDuration);
                prevPos = pos;
            }
        }
    }

    @Override
    public IBlockState getBlock(World world, EntitySpellTicker entityMushroomForest) {
        return null;
    }
}

