/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class TameAnimal
extends SpellRay {
    EntityPlayer casterPlayer;
    Random rand = new Random();

    public TameAnimal() {
        super("ancientspellcraft", "tameanimal", SpellActions.POINT, false);
        this.soundValues(0.7f, 1.2f, 0.4f);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        this.casterPlayer = caster;
        return super.cast(world, caster, hand, ticksInUse, modifiers);
    }

    protected boolean onEntityHit(World world, Entity entity, Vec3d vec3d, @Nullable EntityLivingBase entityLivingBase, Vec3d vec3d1, int i, SpellModifiers spellModifiers) {
        if (this.casterPlayer != null) {
            world.func_184134_a((double)entity.func_180425_c().func_177958_n(), (double)entity.func_180425_c().func_177956_o(), (double)entity.func_180425_c().func_177952_p(), SoundEvents.field_193808_ex, SoundCategory.BLOCKS, 0.5f, this.rand.nextFloat() * 0.4f + 0.8f, false);
            if (entity instanceof EntityParrot) {
                EntityParrot parrot = (EntityParrot)entity;
                if (!parrot.func_70909_n() && this.casterPlayer != null) {
                    parrot.func_193101_c(this.casterPlayer);
                    this.playTameEffect(true, (EntityAnimal)parrot);
                    parrot.field_70170_p.func_72960_a((Entity)parrot, (byte)7);
                    return true;
                }
            } else {
                if (entity instanceof EntityWolf) {
                    EntityWolf wolf = (EntityWolf)entity;
                    if (!wolf.func_70909_n() && this.casterPlayer != null) {
                        wolf.func_193101_c(this.casterPlayer);
                        wolf.func_70661_as().func_75499_g();
                        wolf.func_70624_b((EntityLivingBase)null);
                        wolf.func_70904_g(false);
                        wolf.func_70606_j(20.0f);
                        this.playTameEffect(true, (EntityAnimal)wolf);
                        wolf.field_70170_p.func_72960_a((Entity)wolf, (byte)7);
                        return true;
                    }
                    return false;
                }
                if (entity instanceof EntityOcelot) {
                    EntityOcelot ocelot = (EntityOcelot)entity;
                    if (!ocelot.func_70909_n() && this.casterPlayer != null) {
                        ocelot.func_193101_c(this.casterPlayer);
                        ocelot.func_70912_b(1 + ocelot.field_70170_p.field_73012_v.nextInt(3));
                        this.playTameEffect(true, (EntityAnimal)ocelot);
                        ocelot.func_70907_r().func_75270_a(true);
                        ocelot.field_70170_p.func_72960_a((Entity)ocelot, (byte)7);
                        return true;
                    }
                    return false;
                }
                if (entity instanceof EntityHorse || entity instanceof EntityDonkey || entity instanceof EntityMule || entity instanceof EntityLlama) {
                    AbstractHorse horse = (AbstractHorse)entity;
                    if (!horse.func_110248_bS() && !horse.func_184207_aI()) {
                        horse.func_110263_g(this.casterPlayer);
                        this.playTameEffect(true, (EntityAnimal)horse);
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos blockPos, EnumFacing enumFacing, Vec3d vec3d, @Nullable EntityLivingBase entityLivingBase, Vec3d vec3d1, int i, SpellModifiers spellModifiers) {
        return false;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase entityLivingBase, Vec3d vec3d, Vec3d vec3d1, int i, SpellModifiers spellModifiers) {
        return false;
    }

    protected void playTameEffect(boolean play, EntityAnimal entityAnimal) {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
        if (!play) {
            enumparticletypes = EnumParticleTypes.SMOKE_NORMAL;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.rand.nextGaussian() * 0.02;
            double d1 = this.rand.nextGaussian() * 0.02;
            double d2 = this.rand.nextGaussian() * 0.02;
            entityAnimal.field_70170_p.func_175688_a(enumparticletypes, entityAnimal.field_70165_t + (double)(this.rand.nextFloat() * entityAnimal.field_70130_N * 2.0f) - (double)entityAnimal.field_70130_N, entityAnimal.field_70163_u + 0.5 + (double)(this.rand.nextFloat() * entityAnimal.field_70131_O), entityAnimal.field_70161_v + (double)(this.rand.nextFloat() * entityAnimal.field_70130_N * 2.0f) - (double)entityAnimal.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.LEAF).pos(x, y, z).vel(vx, vy, vz).collide(true).spawn(world);
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

