/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.entity.construct.EntityTransportationPortal;
import com.windanesz.ancientspellcraft.item.ItemNewArtefact;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.block.BlockTransportationStone;
import electroblob.wizardry.data.IVariable;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellConstructRanged;
import electroblob.wizardry.spell.Transportation;
import electroblob.wizardry.util.Location;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class TransportationPortal
extends SpellConstructRanged<EntityTransportationPortal> {
    public TransportationPortal(String modID, String name, EnumAction action, boolean isContinuous) {
        super(modID, name, EntityTransportationPortal::new, false);
        this.soundValues(1.0f, 1.1f, 0.1f);
        this.floor(true);
        this.overlap(false);
        this.addProperties(new String[]{"effect_duration"});
    }

    public boolean requiresPacket() {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        WizardData data = WizardData.get((EntityPlayer)caster);
        if (data != null) {
            ArrayList locations = (ArrayList)data.getVariable((IVariable)Transportation.LOCATIONS_KEY);
            if (locations == null) {
                locations = new ArrayList(4);
                data.setVariable((IVariable)Transportation.LOCATIONS_KEY, locations);
            }
            if (locations.isEmpty()) {
                if (!world.field_72995_K) {
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ebwizardry:transportation.undefined", new Object[0]), true);
                }
                return false;
            }
            if (!ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)AncientSpellcraftItems.charm_rift_bottle)) {
                if (ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)WizardryItems.charm_transportation)) {
                    List locationsInDimension = locations.stream().filter(l -> l.dimension == caster.field_71093_bK).collect(Collectors.toList());
                    if (locationsInDimension.isEmpty()) {
                        if (!world.field_72995_K) {
                            caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ebwizardry:transportation.wrongdimension", new Object[0]), true);
                        }
                        return false;
                    }
                    Location destination = Transportation.getLocationAimedAt((EntityPlayer)caster, locationsInDimension, (float)1.0f);
                    if (destination == null) {
                        return false;
                    }
                    return this.spawnPortal(world, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, EnumFacing.UP, (EntityLivingBase)caster, modifiers, destination);
                }
                Location destination = (Location)locations.get(locations.size() - 1);
                if (destination.dimension == caster.field_71093_bK) {
                    return this.spawnPortal(world, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, EnumFacing.UP, (EntityLivingBase)caster, modifiers, destination);
                }
                if (!world.field_72995_K) {
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ebwizardry:transportation.wrongdimension", new Object[0]), true);
                }
            } else {
                if (ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)WizardryItems.charm_transportation)) {
                    ArrayList locationsInDimension = new ArrayList(locations);
                    Location destination = Transportation.getLocationAimedAt((EntityPlayer)caster, locationsInDimension, (float)1.0f);
                    if (destination == null) {
                        return false;
                    }
                    return this.spawnPortal(world, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, EnumFacing.UP, (EntityLivingBase)caster, modifiers, destination);
                }
                Location destination = (Location)locations.get(locations.size() - 1);
                return this.spawnPortal(world, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, EnumFacing.UP, (EntityLivingBase)caster, modifiers, destination);
            }
            return false;
        }
        return false;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return false;
    }

    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        return false;
    }

    public boolean spawnPortal(World world, double x, double y, double z, @Nullable EnumFacing side, @Nullable EntityLivingBase caster, SpellModifiers modifiers, Location location) {
        if (location.pos.func_177954_c(x, y, z) < 5.0) {
            if (!world.field_72995_K && caster instanceof EntityPlayer) {
                ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:transportation_portal.too_close", new Object[0]), true);
            }
            return false;
        }
        if (!(!(caster instanceof EntityPlayer) || ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)caster), (Item)AncientSpellcraftItems.charm_rift_bottle) && caster.field_71093_bK != location.dimension || BlockTransportationStone.testForCircle((World)world, (BlockPos)location.pos))) {
            if (!world.field_72995_K) {
                ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.ebwizardry:transportation.missing", new Object[0]), true);
            }
            return false;
        }
        if (!world.field_72995_K) {
            EntityTransportationPortal construct = (EntityTransportationPortal)((Object)this.constructFactory.apply(world));
            construct.func_70107_b(x, y, z);
            construct.setCaster(caster);
            construct.lifetime = caster instanceof EntityPlayer && ItemNewArtefact.isNewArtefactActive((EntityPlayer)caster, AncientSpellcraftItems.head_riftstone) ? -1 : (int)(this.getProperty("duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
            construct.setTargetDim(location.dimension);
            construct.setTargetPos(location.pos);
            construct.setParticleColors();
            if (!world.func_72872_a(((Object)((Object)construct)).getClass(), construct.func_174813_aQ()).isEmpty()) {
                return false;
            }
            world.func_72838_d((Entity)construct);
            this.playSound(world, caster, 0, -1, modifiers, new String[0]);
        }
        return true;
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

