/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.entity.living.EntitySkeletonMageMinion;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellMinion;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class UnholyAlliance
extends SpellMinion<EntitySkeletonMageMinion> {
    private static final String POTENCY_ATTRIBUTE_MODIFIER = "potency";

    public UnholyAlliance(String modID, String name, Function<World, EntitySkeletonMageMinion> minionFactory) {
        super(modID, name, minionFactory);
        this.soundValues(7.0f, 1.0f, 0.0f);
    }

    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        return false;
    }

    protected boolean spawnMinions(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            int i = 0;
            ArrayList<BlockPos> locations = new ArrayList<BlockPos>();
            locations.add(caster.func_180425_c().func_177967_a(EnumFacing.NORTH, 2));
            locations.add(caster.func_180425_c().func_177967_a(EnumFacing.SOUTH, 2));
            locations.add(caster.func_180425_c().func_177967_a(EnumFacing.WEST, 2));
            locations.add(caster.func_180425_c().func_177967_a(EnumFacing.EAST, 2));
            locations.add(caster.func_180425_c().func_177967_a(EnumFacing.NORTH, 2).func_177967_a(EnumFacing.EAST, 2));
            locations.add(caster.func_180425_c().func_177967_a(EnumFacing.NORTH, 2).func_177967_a(EnumFacing.WEST, 2));
            locations.add(caster.func_180425_c().func_177967_a(EnumFacing.SOUTH, 2).func_177967_a(EnumFacing.WEST, 2));
            for (Element element : Element.values()) {
                if (element == Element.MAGIC) continue;
                int range = this.getProperty("summon_radius").intValue();
                BlockPos pos = world.func_175623_d((BlockPos)locations.get(i)) && world.func_175623_d(((BlockPos)locations.get(i)).func_177984_a()) ? (BlockPos)locations.get(i) : BlockUtils.findNearbyFloorSpace((Entity)caster, (int)range, (int)(range * 2));
                ++i;
                if (pos == null) {
                    return false;
                }
                EntitySkeletonMageMinion minion = this.createMinion(world, caster, modifiers, element);
                minion.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                minion.setCaster(caster);
                minion.setLifetime((int)(this.getProperty("minion_lifetime").floatValue() * modifiers.get(WizardryItems.duration_upgrade)));
                IAttributeInstance attribute = minion.func_110148_a(SharedMonsterAttributes.field_111264_e);
                if (attribute != null) {
                    attribute.func_111121_a(new AttributeModifier(POTENCY_ATTRIBUTE_MODIFIER, (double)(modifiers.get(POTENCY_ATTRIBUTE_MODIFIER) - 1.0f), 2));
                }
                minion.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("minion_health", (double)(modifiers.get("minion_health") - 1.0f), 2));
                minion.func_70606_j(minion.func_110138_aP());
                this.addMinionExtras((EntityLiving)minion, pos, caster, modifiers, i);
                world.func_72838_d((Entity)minion);
            }
        }
        return true;
    }

    private EntitySkeletonMageMinion createMinion(World world, EntityLivingBase caster, SpellModifiers modifiers, Element element) {
        return new EntitySkeletonMageMinion(world, element);
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

