/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.entity.EntityWisp;
import com.windanesz.ancientspellcraft.entity.construct.EntitySpellTicker;
import com.windanesz.ancientspellcraft.item.ItemEnchantedNameTag;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import com.windanesz.ancientspellcraft.spell.ISpellTickerConstruct;
import com.windanesz.ancientspellcraft.util.ASUtils;
import com.windanesz.ancientspellcraft.util.BiomeLocator;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.spell.SpellConstruct;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class WillOWisp
extends SpellConstruct<EntitySpellTicker>
implements ISpellTickerConstruct {
    public static String BIOME_POS_TAG = "biomePos";
    public static String BIOME_TAG = "biome";

    public WillOWisp(String modID, String name) {
        super(modID, name, EnumAction.BLOCK, EntitySpellTicker::new, false);
        this.addProperties(new String[]{"range"});
        this.soundValues(1.0f, 1.2f, 0.3f);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        WizardData data = WizardData.get((EntityPlayer)caster);
        ItemStack offhand = caster.func_184592_cb();
        if (caster.func_130014_f_().field_73011_w.getDimension() == 0) {
            if (!offhand.func_190926_b() && offhand.func_77973_b() instanceof ItemEnchantedNameTag) {
                String nameTag;
                if (!offhand.func_77942_o()) {
                    if (!world.field_72995_K) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.tag_has_no_name", new Object[0]), false);
                    }
                    return false;
                }
                try {
                    nameTag = caster.func_184592_cb().func_77978_p().func_74775_l("display").func_74779_i("Name");
                }
                catch (Exception e) {
                    if (!world.field_72995_K) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.tag_has_no_name", new Object[0]), false);
                    }
                    return false;
                }
                if (ASUtils.isBiomeNameRegistered(nameTag)) {
                    boolean res = super.cast(world, caster, hand, ticksInUse, modifiers);
                    caster.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
                    return res;
                }
                if (!world.field_72995_K) {
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.invalid_biome_name_in_tag", new Object[0]), false);
                    caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.try_listbiomes", new Object[0]), false);
                }
                return false;
            }
            if (!world.field_72995_K) {
                caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.no_name_tag", new Object[0]), false);
            }
        } else if (!world.field_72995_K) {
            caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.not_in_overworld", new Object[0]), false);
        }
        return false;
    }

    protected void addConstructExtras(EntitySpellTicker construct, EnumFacing side, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        NBTTagCompound extraData = new NBTTagCompound();
        double maxRange = (double)this.getProperty("range").floatValue() * Math.pow(modifiers.get(WizardryItems.range_upgrade), 3.0);
        String biome = caster.func_184592_cb().func_77978_p().func_74775_l("display").func_74779_i("Name");
        NBTTagCompound nameTagCompund = caster.func_184592_cb().func_77978_p();
        extraData.func_74780_a("maxRange", maxRange);
        extraData.func_74778_a("biome", biome);
        extraData.func_74782_a("nametagCompound", (NBTBase)nameTagCompund);
        construct.setExtraData(extraData);
        construct.setSpell((Spell)this);
        construct.lifetime = 200;
        if (caster != null && !caster.field_70170_p.field_72995_K) {
            caster.field_70170_p.func_72838_d((Entity)construct);
        }
    }

    public void createWisp(World world, EntityPlayer player, BlockPos targetPos, NBTTagCompound nameTagStackTag) {
        if (!world.field_72995_K && targetPos != null) {
            EntityWisp entitywisp = new EntityWisp(world, player.field_70165_t, player.field_70163_u + (double)(player.field_70131_O / 2.0f), player.field_70161_v);
            entitywisp.moveTowards(targetPos, player);
            entitywisp.setEnchantedNameTag(nameTagStackTag, 0);
            world.func_72838_d((Entity)entitywisp);
        }
    }

    public boolean hasCustomName(ItemStack nameTag) {
        NBTTagCompound tag = nameTag.func_77978_p();
        return !tag.func_74779_i("name").isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onUpdate(World world, EntitySpellTicker entitySpellTicker) {
        String biome;
        if (entitySpellTicker.field_70173_aa > 10 && !entitySpellTicker.getExtraData().func_74764_b(BIOME_POS_TAG)) {
            if (!world.field_72995_K && entitySpellTicker.getCaster() instanceof EntityPlayer) {
                ((EntityPlayer)entitySpellTicker.getCaster()).func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.searching", new Object[0]), false);
            }
            NBTTagCompound compound = entitySpellTicker.getExtraData();
            if (entitySpellTicker.getExtraData().func_74764_b("biome")) {
                if (compound.func_74764_b("searching")) {
                    entitySpellTicker.func_70106_y();
                    WillOWisp.dropNameTag(entitySpellTicker);
                    return;
                }
                compound.func_74757_a("searching", true);
                entitySpellTicker.setExtraData(compound);
                biome = entitySpellTicker.getExtraData().func_74779_i("biome");
                ResourceLocation biomeResourceLocation = ASUtils.getBiomeRegistryNameFromName(biome);
                BlockPos biomePos = BiomeLocator.spiralOutwardsLookingForBiome(world, (Biome)ForgeRegistries.BIOMES.getValue(biomeResourceLocation), entitySpellTicker.field_70165_t, entitySpellTicker.field_70161_v);
                if (biomePos != null && biomePos != BlockPos.field_177992_a) {
                    compound.func_74782_a(BIOME_POS_TAG, (NBTBase)NBTUtil.func_186859_a((BlockPos)biomePos));
                    entitySpellTicker.setExtraData(compound);
                    double distFromTicker = Math.sqrt(biomePos.func_177954_c(entitySpellTicker.field_70165_t, entitySpellTicker.field_70163_u, entitySpellTicker.field_70161_v));
                    if (distFromTicker > entitySpellTicker.getExtraData().func_74769_h("maxRange")) {
                        if (!world.field_72995_K && entitySpellTicker.getCaster() != null) {
                            ((EntityPlayer)entitySpellTicker.getCaster()).func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.target_too_far", new Object[0]), false);
                        }
                        WillOWisp.dropNameTag(entitySpellTicker);
                        entitySpellTicker.func_70106_y();
                        return;
                    }
                } else {
                    entitySpellTicker.func_70106_y();
                    WillOWisp.dropNameTag(entitySpellTicker);
                    return;
                }
            }
        }
        if (!world.field_72995_K && entitySpellTicker.field_70173_aa > 80 && entitySpellTicker.getExtraData().func_74764_b(BIOME_POS_TAG)) {
            BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)entitySpellTicker.getExtraData().func_74775_l(BIOME_POS_TAG));
            this.playSound(world, entitySpellTicker.field_70165_t, entitySpellTicker.field_70163_u, entitySpellTicker.field_70161_v, 0, 0, entitySpellTicker.getModifiers(), new String[0]);
            this.createWisp(world, (EntityPlayer)entitySpellTicker.getCaster(), pos, entitySpellTicker.getExtraData().func_74775_l("nametagCompound"));
            biome = entitySpellTicker.getExtraData().func_74779_i("biome");
            if (entitySpellTicker.getCaster() != null) {
                ((EntityPlayer)entitySpellTicker.getCaster()).func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:will_o_wisp.sent_to_biome", new Object[]{biome}), false);
            }
            entitySpellTicker.func_70106_y();
        }
    }

    private static void dropNameTag(EntitySpellTicker entitySpellTicker) {
        if (!entitySpellTicker.field_70170_p.field_72995_K && entitySpellTicker.getExtraData().func_74764_b("nametagCompound")) {
            ItemStack stack = new ItemStack(AncientSpellcraftItems.enchanted_name_tag, 1);
            stack.func_77982_d(entitySpellTicker.getExtraData().func_74775_l("nametagCompound"));
            entitySpellTicker.field_70170_p.func_72838_d((Entity)new EntityItem(entitySpellTicker.field_70170_p, entitySpellTicker.field_70165_t, entitySpellTicker.field_70163_u, entitySpellTicker.field_70161_v, stack));
        }
    }

    @Override
    public IBlockState getBlock(World world, EntitySpellTicker entityMushroomForest) {
        return null;
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spellcraft_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

