/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.AncientSpellcraftItems;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.item.ItemWandUpgrade;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class WordsOfUnbinding
extends Spell {
    public WordsOfUnbinding() {
        super("ancientspellcraft", "words_of_unbinding", SpellActions.IMBUE, false);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)AncientSpellcraftItems.ring_disenchanter)) {
            if (caster.func_184592_cb().func_77948_v()) {
                NBTTagCompound compound;
                if (!world.field_72995_K && (compound = caster.func_184592_cb().func_77978_p()) != null && compound.func_74764_b("ench")) {
                    compound.func_82580_o("ench");
                    this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
                    caster.func_184592_cb().func_77982_d(compound);
                    return true;
                }
                if (world.field_72995_K) {
                    WordsOfUnbinding.spawnParticles(world, (EntityLivingBase)caster);
                }
                return true;
            }
            if (!world.field_72995_K) {
                caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:words_of_unbinding.disenchanting_no_item", new Object[0]), false);
            }
            return false;
        }
        if (caster.func_184586_b(hand).func_190926_b() || !(caster.func_184586_b(hand).func_77973_b() instanceof ItemWand)) {
            if (!world.field_72995_K) {
                caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:words_of_unbinding.no_wand", new Object[0]), false);
            }
            return false;
        }
        ItemStack stack = caster.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ItemWand) {
            if (WandHelper.getTotalUpgrades((ItemStack)stack) > 0 && !world.field_72995_K) {
                if (!caster.func_184592_cb().func_190926_b() && caster.func_184592_cb().func_77973_b() instanceof ItemWandUpgrade) {
                    boolean action = WordsOfUnbinding.removeUpgrade(caster, stack, caster.func_184592_cb().func_77973_b());
                    if (action) {
                        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
                    }
                    return action;
                }
                boolean action = WordsOfUnbinding.removeUpgrade(caster, stack, null);
                if (action) {
                    this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
                }
                return action;
            }
        } else {
            if (!world.field_72995_K) {
                caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:words_of_unbinding.no_upgrade_to_remove", new Object[0]), false);
            }
            return false;
        }
        if (world.field_72995_K) {
            WordsOfUnbinding.spawnParticles(world, (EntityLivingBase)caster);
        }
        return true;
    }

    public static boolean removeUpgrade(EntityPlayer player, ItemStack wand, @Nullable Item upgrade) {
        boolean returnItem;
        boolean bl = returnItem = player.field_70170_p.field_73012_v.nextDouble() < 0.2 && ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)AncientSpellcraftItems.ring_unbinding);
        if (wand.func_77978_p() == null) {
            wand.func_77982_d(new NBTTagCompound());
        }
        if (!wand.func_77978_p().func_74764_b("upgrades")) {
            return false;
        }
        NBTTagCompound upgrades = wand.func_77978_p().func_74775_l("upgrades");
        if (upgrade != null) {
            String upgradeString = upgrade.getRegistryName().func_110623_a().replace("_upgrade", "");
            if (upgrades.func_74764_b(upgradeString)) {
                int counter = upgrades.func_74762_e(upgradeString);
                if (--counter >= 1) {
                    upgrades.func_74768_a(upgradeString, counter);
                } else {
                    upgrades.func_82580_o(upgradeString);
                }
                NBTExtras.storeTagSafely((NBTTagCompound)wand.func_77978_p(), (String)"upgrades", (NBTBase)upgrades);
                if (returnItem) {
                    WordsOfUnbinding.dropUpgrade(player, upgradeString);
                }
                return true;
            }
            WordsOfUnbinding.removeRandomUpgrade(player, wand, returnItem);
        } else {
            WordsOfUnbinding.removeRandomUpgrade(player, wand, returnItem);
        }
        return true;
    }

    private static void dropUpgrade(EntityPlayer player, String upgrade) {
        Item item;
        List upgradeItems = ForgeRegistries.ITEMS.getKeys().stream().filter(i -> i.func_110623_a().equals(upgrade + "_upgrade")).collect(Collectors.toList());
        if (!upgradeItems.isEmpty() && !player.func_191521_c(new ItemStack(item = (Item)ForgeRegistries.ITEMS.getValue((ResourceLocation)upgradeItems.get(0))))) {
            player.func_71019_a(new ItemStack(item), false);
        }
    }

    private static void removeRandomUpgrade(EntityPlayer player, ItemStack wand, boolean returnItem) {
        Random rand;
        ArrayList appliedUpgrades;
        String upgradeToDecrease;
        NBTTagCompound upgrades = wand.func_77978_p().func_74775_l("upgrades");
        if (!upgrades.func_82582_d() && upgrades.func_74764_b(upgradeToDecrease = (String)(appliedUpgrades = new ArrayList(upgrades.func_150296_c())).get((rand = new Random()).nextInt(appliedUpgrades.size())))) {
            int counter = upgrades.func_74762_e(upgradeToDecrease);
            if (--counter >= 1) {
                upgrades.func_74768_a(upgradeToDecrease, counter);
            } else {
                upgrades.func_82580_o(upgradeToDecrease);
            }
            NBTExtras.storeTagSafely((NBTTagCompound)wand.func_77978_p(), (String)"upgrades", (NBTBase)upgrades);
            if (returnItem) {
                WordsOfUnbinding.dropUpgrade(player, upgradeToDecrease);
            }
        }
    }

    protected static void spawnParticles(World world, EntityLivingBase caster) {
        for (int i = 0; i < 10; ++i) {
            double x = caster.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            double y = caster.field_70163_u + (double)caster.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
            double z = caster.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).clr(218, 186, 219).spawn(world);
        }
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BUFF).entity((Entity)caster).clr(218, 186, 219).spawn(world);
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean applicableForItem(Item item) {
        return item == AncientSpellcraftItems.ancient_spell_book || item == AncientSpellcraftItems.ancient_spellcraft_scroll;
    }
}

