/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.tileentity;

import com.windanesz.ancientspellcraft.constants.EnumFacingIntercardinal;
import com.windanesz.ancientspellcraft.registry.AncientSpellcraftBlocks;
import com.windanesz.ancientspellcraft.registry.Rituals;
import com.windanesz.ancientspellcraft.ritual.IRitualBlockRequirement;
import com.windanesz.ancientspellcraft.ritual.IRitualIngredient;
import com.windanesz.ancientspellcraft.ritual.Ritual;
import electroblob.wizardry.util.BlockUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TileRune
extends TileEntity
implements ITickable {
    private Item rune = Items.field_190931_a;
    private String RUNE_TAG = "rune";
    private String MASTER_TAG = "is_master";
    private String RITUAL_DATA = "ritual_data";
    private TileRune master;
    private boolean isMaster;
    private int casterId;
    private UUID casterUUID;
    private boolean firstRun = true;
    private TileRune centerPiece;
    private List<TileRune> connectedRunes;
    private Ritual ritual;
    private int ritualCurrentLifeTime = 0;
    List<TileRune> ritualRunes;
    private NBTTagCompound ritualData;

    public void setRitualRunes(List<TileRune> ritualRunes) {
        if (this.isMaster) {
            this.ritualRunes = ritualRunes;
        } else {
            this.getMaster().ritualRunes = ritualRunes;
        }
    }

    public void setRitualData(NBTTagCompound ritualData) {
        this.ritualData = ritualData;
    }

    public void setRitual(Ritual ritual) {
        if (this.isMaster()) {
            this.ritual = ritual;
        } else {
            this.getMaster().setRitual(ritual);
        }
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    private void incrementRitualCurrentLifeTime() {
        if (this.isMaster()) {
            ++this.ritualCurrentLifeTime;
        } else {
            ++this.getMaster().ritualCurrentLifeTime;
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != AncientSpellcraftBlocks.PLACED_RUNE) {
            this.field_145850_b.func_175713_t(this.field_174879_c);
            return;
        }
        if (this.firstRun) {
            this.initializeRuneMultiBlockIfNecessary();
            this.firstRun = false;
        }
        if (this.isMaster && !this.field_145850_b.field_72995_K) {
            if (this.centerPiece != null && this.getMaster() != this.centerPiece) {
                return;
            }
            if (this.connectedRunes != null && this.ritual == null) {
                boolean matchesRitual = true;
                for (TileRune rune : this.connectedRunes) {
                    for (Map.Entry resourceLocationRitualEntry : Ritual.registry.getEntries()) {
                        Ritual currentRitual = (Ritual)((Object)resourceLocationRitualEntry.getValue());
                        if (currentRitual == Rituals.none || currentRitual.getRitualProperties().centerpiece == null || currentRitual.getRitualProperties().centerpiece != rune.rune) continue;
                        BlockPos pos = rune.field_174879_c;
                        int width = currentRitual.getRitualProperties().width;
                        int height = currentRitual.getRitualProperties().height;
                        Item[][] matrix = new Item[height][width];
                        int index = 0;
                        for (int j = 0; j < height; ++j) {
                            for (int k = 0; k < width; ++k) {
                                if (((Ingredient)currentRitual.getRitualProperties().pattern.get(index)).func_193365_a().length > 0) {
                                    matrix[j][k] = ((Ingredient)currentRitual.getRitualProperties().pattern.get(index)).func_193365_a()[0].func_77973_b();
                                    BlockPos blockPos = pos.func_177967_a(EnumFacing.NORTH, j).func_177967_a(EnumFacing.WEST, k);
                                } else {
                                    matrix[j][k] = Items.field_190931_a;
                                }
                                ++index;
                            }
                        }
                        Item[][] posMatrix = new Item[height][width];
                        for (int j = 0; j < height; ++j) {
                            for (int k = 0; k < width; ++k) {
                                BlockPos pos12 = pos.func_177967_a(EnumFacing.NORTH, j - (int)Math.ceil(height / 2)).func_177967_a(EnumFacing.WEST, k - (int)Math.ceil(width / 2));
                                if (this.field_145850_b.func_175625_s(pos12) instanceof TileRune) {
                                    TileRune tileRune = (TileRune)this.field_145850_b.func_175625_s(pos12);
                                    posMatrix[j][k] = tileRune.getRune();
                                    continue;
                                }
                                posMatrix[j][k] = Items.field_190931_a;
                            }
                        }
                        int row1 = matrix.length;
                        int col1 = matrix[0].length;
                        for (int i2 = 0; i2 < 4; ++i2) {
                            matchesRitual = true;
                            for (int l = 0; l < row1; ++l) {
                                for (int j = 0; j < col1; ++j) {
                                    if (matrix[l][j] == posMatrix[l][j]) continue;
                                    matchesRitual = false;
                                    break;
                                }
                                if (!matchesRitual) break;
                            }
                            if (matchesRitual) break;
                            matrix = this.rotMatrixBy90(matrix);
                        }
                        if (!matchesRitual || rune.isMaster()) continue;
                        List blockPosList = BlockUtils.getBlockSphere((BlockPos)pos, (double)(width / 2 + 1)).stream().filter(p -> p.func_177956_o() == pos.func_177956_o()).collect(Collectors.toList());
                        List<TileRune> ritualRunes = blockPosList.stream().filter(pos1 -> this.field_145850_b.func_175625_s(pos1) instanceof TileRune).map(pos1 -> (TileRune)this.field_145850_b.func_175625_s(pos1)).collect(Collectors.toList());
                        if (!ritualRunes.contains((Object)rune)) {
                            // empty if block
                        }
                        ritualRunes.forEach(ritual -> this.setMaster(rune));
                        ritualRunes.forEach(ritual -> {
                            this.connectedRunes = ritualRunes;
                        });
                        for (TileRune ritualRune : ritualRunes) {
                            ritualRune.setMaster(rune);
                            if (ritualRune == rune) {
                                ritualRune.connectedRunes = ritualRunes;
                                ritualRune.ritualRunes = ritualRunes;
                                ritualRune.ritual = currentRitual;
                                ritualRune.centerPiece = rune;
                            }
                            ritualRune.sendUpdates();
                        }
                    }
                }
            }
        }
        if (this.isMaster && this.ritual != null) {
            if (this.ritualCurrentLifeTime == 0) {
                boolean ingredientsOk = true;
                boolean blocksOk = true;
                if (this.ritual instanceof IRitualIngredient) {
                    List<EntityItem> actualIngredients = ((IRitualIngredient)((Object)this.ritual)).getActualIngredients(this.field_145850_b, this.centerPiece, 1);
                    if (actualIngredients.isEmpty()) {
                        ingredientsOk = false;
                    } else {
                        if (((IRitualIngredient)((Object)this.ritual)).shouldConsumeIngredients()) {
                            actualIngredients.forEach(i -> i.func_70106_y());
                        }
                        actualIngredients.stream().forEach(i -> i.func_92059_d().func_190918_g(1));
                    }
                }
                if (this.ritual instanceof IRitualBlockRequirement) {
                    blocksOk = ((IRitualBlockRequirement)((Object)this.ritual)).areInitialRequirementsMet(this.field_145850_b, this.centerPiece);
                }
                if (blocksOk && ingredientsOk) {
                    this.updateRitualTick();
                }
            } else {
                this.updateRitualTick();
            }
        }
    }

    private IBlockState getState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    private void updateRitualTick() {
        if (this.ritualRunes == null) {
            List blockPosList = BlockUtils.getBlockSphere((BlockPos)this.field_174879_c, (double)this.ritual.getRitualProperties().width).stream().filter(p -> p.func_177956_o() == this.field_174879_c.func_177956_o()).collect(Collectors.toList());
            ArrayList<TileRune> ritualRunes = new ArrayList<TileRune>();
            for (BlockPos blockPos : blockPosList) {
                TileEntity tile;
                if (this.field_145850_b.func_180495_p(blockPos).func_177230_c() != AncientSpellcraftBlocks.PLACED_RUNE || !((tile = this.field_145850_b.func_175625_s(blockPos)) instanceof TileRune)) continue;
                ritualRunes.add((TileRune)tile);
                ((TileRune)tile).setMaster(this.centerPiece);
            }
            this.ritualRunes = ritualRunes;
        }
        if (this.centerPiece == null) {
            this.centerPiece = this;
        }
        this.incrementRitualCurrentLifeTime();
        if (this.getCaster() != null) {
            this.getRitual().effect(this.field_145850_b, this.getCaster(), this.centerPiece);
        }
        if (this.getRitual().getMaxLifeTime() != -1 && this.getRitual().getMaxLifeTime() <= this.getRitualCurrentLifeTime() && this.getCaster() != null) {
            this.getRitual().onRitualFinish(this.field_145850_b, this.getCaster(), this.centerPiece);
        }
    }

    private Item[][] rotMatrixBy90(Item[][] matrix) {
        Item temp;
        int j;
        int i;
        int N = matrix.length;
        for (i = 0; i < N; ++i) {
            for (j = 0; j < i; ++j) {
                temp = matrix[i][j];
                matrix[i][j] = matrix[j][i];
                matrix[j][i] = temp;
            }
        }
        for (i = 0; i < N; ++i) {
            for (j = 0; j < N / 2; ++j) {
                temp = matrix[i][j];
                matrix[i][j] = matrix[i][N - j - 1];
                matrix[i][N - j - 1] = temp;
            }
        }
        return matrix;
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (EnumFacingIntercardinal d : EnumFacingIntercardinal.HORIZONTALS) {
            TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n() + d.getXOffset(), this.field_174879_c.func_177956_o() + d.getYOffset(), this.field_174879_c.func_177952_p() + d.getZOffset()));
            if (!(te instanceof TileRune)) continue;
            ((TileRune)te).master = null;
            ((TileRune)te).initializeRuneMultiBlockIfNecessary();
        }
    }

    private void initializeRuneMultiBlockIfNecessary() {
        if (this.master == null || this.master.func_145837_r()) {
            ArrayList<TileRune> connectedRunes = new ArrayList<TileRune>();
            Stack<TileRune> traversingRunes = new Stack<TileRune>();
            TileRune master = this;
            traversingRunes.add(this);
            while (!traversingRunes.isEmpty()) {
                TileRune rune = (TileRune)((Object)traversingRunes.pop());
                if (rune.isMaster()) {
                    master = rune;
                }
                if (!connectedRunes.contains((Object)rune)) {
                    connectedRunes.add(rune);
                }
                for (EnumFacingIntercardinal d : EnumFacingIntercardinal.HORIZONTALS) {
                    TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(rune.field_174879_c.func_177958_n() + d.getXOffset(), rune.field_174879_c.func_177956_o() + d.getYOffset(), rune.field_174879_c.func_177952_p() + d.getZOffset()));
                    if (!(te instanceof TileRune) || connectedRunes.contains(te)) continue;
                    traversingRunes.add((TileRune)te);
                }
            }
            for (TileRune rune : connectedRunes) {
                rune.setMaster(master);
                rune.connectedRunes = master.getConnectedRunes();
            }
            this.getMaster().connectedRunes = connectedRunes;
            this.func_70296_d();
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.rune = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compound.func_74779_i(this.RUNE_TAG)));
        this.isMaster = compound.func_74767_n(this.MASTER_TAG);
        if (this.isMaster) {
            this.centerPiece = this;
            if (compound.func_74764_b(this.RITUAL_DATA)) {
                this.ritualData = compound.func_74775_l(this.RITUAL_DATA);
            }
            if (compound.func_74764_b("ritual_lifetime")) {
                this.ritualCurrentLifeTime = compound.func_74762_e("ritual_lifetime");
            }
            if (compound.func_74764_b("ritual")) {
                this.ritual = (Ritual)Ritual.registry.getValue(new ResourceLocation(compound.func_74779_i("ritual")));
            }
        }
        if (compound.func_74764_b("caster_id")) {
            this.casterId = compound.func_74762_e("caster_id");
        }
        if (compound.func_74764_b("caster_uuid")) {
            this.casterUUID = compound.func_186857_a("caster_uuid");
            this.casterUUID = NBTUtil.func_186860_b((NBTTagCompound)((NBTTagCompound)compound.func_74781_a("caster_uuid")));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74778_a(this.RUNE_TAG, this.rune.getRegistryName().toString());
        compound.func_74757_a(this.MASTER_TAG, this.isMaster);
        if (this.isMaster) {
            if (this.ritualData != null) {
                compound.func_74782_a(this.RITUAL_DATA, (NBTBase)this.ritualData);
            }
            if (this.ritual != null) {
                compound.func_74778_a("ritual", this.ritual.getRegistryName().toString());
            }
            compound.func_74768_a("ritual_lifetime", this.ritualCurrentLifeTime);
        }
        compound.func_74768_a("caster_id", this.casterId);
        compound.func_74782_a("caster_uuid", (NBTBase)NBTUtil.func_186862_a((UUID)this.casterUUID));
        return compound;
    }

    public void sendUpdates() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.getState(), this.getState(), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        this.func_70296_d();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public Item getRune() {
        return this.rune;
    }

    public int getX() {
        return this.func_174877_v().func_177958_n();
    }

    public int getY() {
        return this.func_174877_v().func_177956_o();
    }

    public int getZ() {
        return this.func_174877_v().func_177952_p();
    }

    public float getXCenter() {
        return (float)this.func_174877_v().func_177958_n() + 0.5f;
    }

    public float getYCenter() {
        return (float)this.func_174877_v().func_177956_o() + 0.5f;
    }

    public float getZCenter() {
        return (float)this.func_174877_v().func_177952_p() + 0.5f;
    }

    public Ritual getRitual() {
        if (this.isMaster()) {
            return this.ritual == null ? Rituals.none : this.ritual;
        }
        if (this.getMaster() != null) {
            return this.getMaster().getRitual();
        }
        return Rituals.none;
    }

    public NBTTagCompound getRitualData() {
        NBTTagCompound compound;
        NBTTagCompound nBTTagCompound = compound = this.isMaster() ? this.ritualData : this.getMaster().ritualData;
        if (compound != null) {
            return compound;
        }
        return new NBTTagCompound();
    }

    public List<TileRune> getRitualRunes() {
        return this.isMaster() ? this.ritualRunes : this.getMaster().ritualRunes;
    }

    public int getRitualCurrentLifeTime() {
        return this.isMaster() ? this.ritualCurrentLifeTime : this.getMaster().getRitualCurrentLifeTime();
    }

    public List<TileRune> getConnectedRunes() {
        return this.isMaster() ? this.connectedRunes : this.getMaster().connectedRunes;
    }

    @Nullable
    public EntityPlayer getCaster() {
        if (this.casterUUID == null) {
            return null;
        }
        EntityPlayer entity = this.field_145850_b.func_152378_a(this.casterUUID);
        if (entity != null) {
            return entity;
        }
        return null;
    }

    public TileRune getMaster() {
        if (this.master == null) {
            this.initializeRuneMultiBlockIfNecessary();
        }
        if (this.master != null && this.master == this && !this.isMaster) {
            this.isMaster = true;
        }
        return this.master;
    }

    private void setMaster(TileRune master) {
        this.master = master;
        this.isMaster = master == this;
    }

    public void setRune(Item rune) {
        this.rune = rune;
    }

    public void setPlacer(EntityPlayer placer) {
        this.casterId = placer.func_145782_y();
        this.casterUUID = placer.func_110124_au();
    }
}

