/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.util;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.InventoryUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ASUtils {
    public static Map<String, Integer> getAllBiomes() {
        return ForgeRegistries.BIOMES.getValuesCollection().stream().collect(Collectors.toMap(Biome::func_185359_l, Biome::func_185362_a));
    }

    public static Map<String, ResourceLocation> getAllBiomesWithRegnames() {
        return ForgeRegistries.BIOMES.getValuesCollection().stream().collect(Collectors.toMap(Biome::func_185359_l, IForgeRegistryEntry.Impl::getRegistryName));
    }

    public static boolean isBiomeNameRegistered(String biomeName) {
        Map<String, Integer> biomes = ASUtils.getAllBiomes();
        return biomes.containsKey(biomeName);
    }

    public static int getBiomeIdFromName(String biomeName) {
        Map<String, Integer> biomes = ASUtils.getAllBiomes();
        return biomes.get(biomeName);
    }

    public static ResourceLocation getBiomeRegistryNameFromName(String biomeName) {
        Map<String, ResourceLocation> biomes = ASUtils.getAllBiomesWithRegnames();
        return biomes.get(biomeName);
    }

    public static ItemStack pickRandomStackFromItemStackList(List<ItemStack> stackList) {
        return stackList.get(new Random().nextInt(stackList.size()));
    }

    public static Element getCrystalElementFromStack(ItemStack crystal) {
        int metadata = crystal.func_77960_j();
        return Element.values()[metadata];
    }

    public static float randFloatBetween(float min, float max) {
        return min + AncientSpellcraft.rand.nextFloat() * (max - min);
    }

    public static int randIntBetween(int min, int max) {
        return AncientSpellcraft.rand.nextInt(max - min + 1) + min;
    }

    public static boolean shrinkInventoryStackByOne(EntityPlayer player, ItemStack stackToShrink) {
        if (player.field_71071_by.func_70431_c(stackToShrink)) {
            int j = -1;
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                if (((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_190926_b() || !ASUtils.stackEqualExact((ItemStack)player.field_71071_by.field_70462_a.get(i), stackToShrink)) continue;
                j = i;
                break;
            }
            if (j != -1) {
                player.field_71071_by.func_70301_a(j).func_190918_g(1);
                return true;
            }
            if (ASUtils.stackEqualExact(player.func_184592_cb(), stackToShrink)) {
                player.func_184592_cb().func_190918_g(1);
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static ItemStack getItemStackFromInventoryHotbar(EntityPlayer player, Item item) {
        for (int i = 0; i < 9; ++i) {
            ItemStack currItemStack;
            if (((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_190926_b() || (currItemStack = (ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77973_b().getRegistryName() != item.getRegistryName()) continue;
            return currItemStack;
        }
        return null;
    }

    public static boolean stackEqualExact(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && (!stack1.func_77981_g() || stack1.func_77960_j() == stack2.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public static List<EntityItem> getEntityItemsWithinRadius(double radius, double x, double y, double z, World world) {
        AxisAlignedBB aabb = new AxisAlignedBB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        List entityItemList = world.func_72872_a(EntityItem.class, aabb);
        for (int i = 0; i < entityItemList.size(); ++i) {
            if (!(((EntityItem)entityItemList.get(i)).func_70011_f(x, y, z) > radius)) continue;
            entityItemList.remove(i);
            break;
        }
        return entityItemList;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isEntityBiped(Entity entity) {
        return Minecraft.func_71410_x().func_175598_ae().func_78715_a(entity.getClass()) instanceof RenderBiped;
    }

    public static List<ItemStack> getAllHotbarWands(EntityPlayer player) {
        return ASUtils.getAllHotbarWands(player, Tier.MASTER);
    }

    public static List<ItemStack> getAllHotbarWands(EntityPlayer player, Tier maxTier) {
        ArrayList<ItemStack> wands = new ArrayList<ItemStack>();
        for (ItemStack stack : InventoryUtils.getHotbar((EntityPlayer)player)) {
            if (!(stack.func_77973_b() instanceof ItemWand) || ((ItemWand)stack.func_77973_b()).tier.level > maxTier.level) continue;
            wands.add(stack);
        }
        return wands;
    }

    public static boolean attemptConsumeManaFromHand(EntityLivingBase entity, int amount) {
        if (!entity.func_184614_ca().func_190926_b() && entity.func_184614_ca().func_77973_b() instanceof ItemWand) {
            if (ASUtils.attemptConsumeManaFromStack(entity, entity.func_184614_ca(), amount)) {
                return true;
            }
            if (!entity.func_184592_cb().func_190926_b() && entity.func_184592_cb().func_77973_b() instanceof ItemWand) {
                return ASUtils.attemptConsumeManaFromStack(entity, entity.func_184592_cb(), amount);
            }
        } else if (!entity.func_184592_cb().func_190926_b() && entity.func_184592_cb().func_77973_b() instanceof ItemWand) {
            return ASUtils.attemptConsumeManaFromStack(entity, entity.func_184592_cb(), amount);
        }
        return false;
    }

    public static boolean attemptConsumeManaFromStack(EntityLivingBase entity, ItemStack wandStack, int amount) {
        ItemWand wand = (ItemWand)wandStack.func_77973_b();
        int mana = wand.getMana(wandStack);
        if (mana > amount) {
            wand.consumeMana(wandStack, amount, entity);
            return true;
        }
        return false;
    }

    public static boolean wandHasSpell(ItemStack wand, Spell spell) {
        for (Spell currentSpell : ((ItemWand)wand.func_77973_b()).getSpells(wand)) {
            if (currentSpell != spell) continue;
            return true;
        }
        return false;
    }

    public static <T> T getRandomListItem(List<T> list) {
        int listSize = list.size();
        int randomIndex = AncientSpellcraft.rand.nextInt(listSize);
        return list.get(randomIndex);
    }

    public static int getRandomMapId(Map<?, ?> map) {
        int mapSize = map.keySet().toArray().length;
        return AncientSpellcraft.rand.nextInt(mapSize);
    }

    public static int getRandomNumberInRange(int min, int max) {
        Random r = new Random();
        return r.nextInt(max - min + 1) + min;
    }

    public static Optional<TileEntity> getTile(IBlockAccess world, BlockPos pos) {
        return ASUtils.getTile(world, pos, TileEntity.class);
    }

    public static <T> Optional<T> getTile(@Nullable IBlockAccess world, @Nullable BlockPos pos, Class<T> teClass) {
        if (world == null || pos == null) {
            return Optional.empty();
        }
        TileEntity te = world.func_175625_s(pos);
        if (teClass.isInstance(te)) {
            return Optional.of(teClass.cast(te));
        }
        return Optional.empty();
    }

    public static boolean isManaStoringCastingItem(Item item) {
        return item instanceof ISpellCastingItem && item instanceof IManaStoringItem;
    }

    public static NBTTagCompound convertToNBT(ItemStack stack) {
        NBTTagCompound stackCompound = new NBTTagCompound();
        return stack.func_77955_b(stackCompound);
    }

    public static NBTTagCompound convertToNBTSingeCount(ItemStack stack) {
        ItemStack stack1 = stack.func_77946_l();
        stack1.func_190920_e(1);
        return ASUtils.convertToNBT(stack1);
    }

    public static List<BlockPos> getBlockPosListFromTag(NBTTagCompound listCompound) {
        ArrayList list = new ArrayList(listCompound.func_150296_c());
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        for (String tag : list) {
            blockPosList.add(NBTUtil.func_186861_c((NBTTagCompound)listCompound.func_74775_l(tag)));
        }
        return blockPosList;
    }

    public static NBTTagCompound writeBlockPosListToTag(List<BlockPos> posList) {
        NBTTagCompound posTagList = new NBTTagCompound();
        int i = 0;
        for (BlockPos pos : posList) {
            posTagList.func_74782_a(String.valueOf(i), (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
            ++i;
        }
        return posTagList;
    }

    public static boolean isInjured(EntityLivingBase entityLivingBase) {
        return entityLivingBase.func_110138_aP() > entityLivingBase.func_110143_aJ();
    }

    public static class ReflectionUtil {
        public static Field getField(Class clazz, String fieldName) throws NoSuchFieldException {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                Class superClass = clazz.getSuperclass();
                if (superClass == null) {
                    throw e;
                }
                return ReflectionUtil.getField(superClass, fieldName);
            }
        }

        public static void makeAccessible(Field field) {
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isPublic(field.getDeclaringClass().getModifiers())) {
                field.setAccessible(true);
            }
        }

        public static void removeFinalModifier(Field field) {
            try {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

