/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.util;

import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SpellcastUtils {
    private SpellcastUtils() {
    }

    public static boolean tryCastSpellAsMob(EntityLiving entityLiving, Spell spell, @Nullable EntityLivingBase target) {
        if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(SpellCastEvent.Source.WAND, spell, (EntityLivingBase)entityLiving, new SpellModifiers()))) {
            return false;
        }
        if (spell.isContinuous) {
            return false;
        }
        if (spell.cast(entityLiving.field_70170_p, entityLiving, EnumHand.MAIN_HAND, 0, target, new SpellModifiers())) {
            MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.OTHER, spell, (EntityLivingBase)entityLiving, new SpellModifiers()));
            if (spell.requiresPacket()) {
                PacketCastSpell.Message msg = new PacketCastSpell.Message(entityLiving.func_145782_y(), null, spell, new SpellModifiers());
                WizardryPacketHandler.net.sendToDimension((IMessage)msg, entityLiving.field_70170_p.field_73011_w.getDimension());
            }
            return true;
        }
        return false;
    }

    public static boolean tryCastSpellAsPlayer(EntityPlayer player, Spell spell, EnumHand hand, SpellCastEvent.Source source, SpellModifiers modifiers, int duration) {
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data == null) {
            return false;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(source, spell, (EntityLivingBase)player, modifiers))) {
            return false;
        }
        if (spell.isContinuous) {
            if (data.isCasting()) {
                data.stopCastingContinuousSpell();
            }
            data.startCastingContinuousSpell(spell, modifiers, duration);
            return true;
        }
        if (spell.cast(player.field_70170_p, player, EnumHand.MAIN_HAND, 0, new SpellModifiers())) {
            MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.COMMAND, spell, (EntityLivingBase)player, modifiers));
            if (spell.requiresPacket()) {
                PacketCastSpell.Message msg = new PacketCastSpell.Message(player.func_145782_y(), hand, spell, modifiers);
                WizardryPacketHandler.net.sendToDimension((IMessage)msg, player.field_70170_p.field_73011_w.getDimension());
            }
            return true;
        }
        return false;
    }

    public static boolean tryCastSpellAtLocation(World world, BlockPos pos, EnumFacing direction, Spell spell, SpellModifiers modifiers) {
        if (spell == null) {
            return false;
        }
        if (!spell.canBeCastBy(new TileEntityDispenser())) {
            return false;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(SpellCastEvent.Source.OTHER, spell, world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), direction, modifiers))) {
            return false;
        }
        if (spell.isContinuous) {
            return false;
        }
        if (spell.cast(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), direction, 0, 120, modifiers)) {
            MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.OTHER, spell, world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), direction, modifiers));
            if (spell.requiresPacket()) {
                EntityPlayer player = world.func_184137_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 30.0, false);
                if (player == null) {
                    return true;
                }
                PacketCastSpell.Message msg = new PacketCastSpell.Message(player.func_145782_y(), null, spell, modifiers);
                WizardryPacketHandler.net.sendToDimension((IMessage)msg, world.field_73011_w.getDimension());
            }
        }
        return true;
    }
}

