/*
 * Decompiled with CFR 0.152.
 */
package com.hugomage.aquafina.client.renderer;

import com.google.common.collect.Maps;
import com.hugomage.aquafina.client.model.TilapiaModel;
import com.hugomage.aquafina.entity.TilapiaEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;

public class TilapiaRenderer
extends MobRenderer<TilapiaEntity, TilapiaModel<TilapiaEntity>> {
    public static final Map<Integer, ResourceLocation> TEXTURES = (Map)Util.func_200696_a((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(0, new ResourceLocation("aquafina", "textures/entity/red_fins_tilapia.png"));
        hashMap.put(1, new ResourceLocation("aquafina", "textures/entity/red_fins_tilapia.png"));
        hashMap.put(2, new ResourceLocation("aquafina", "textures/entity/red_fins_tilapia.png"));
    });

    public TilapiaRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new TilapiaModel(), 0.2f);
    }

    protected void setupRotations(TilapiaEntity entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_225621_a_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
        float f = 4.3f * MathHelper.func_76126_a((float)(0.6f * ageInTicks));
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f));
        if (!entityLiving.func_70090_H()) {
            matrixStackIn.func_227861_a_((double)0.1f, (double)0.1f, (double)-0.1f);
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
        }
    }

    public ResourceLocation getTextureLocation(TilapiaEntity entity) {
        return TEXTURES.getOrDefault(entity.getVariant(), TEXTURES.get(0));
    }
}

