/*
 * Decompiled with CFR 0.152.
 */
package com.hugomage.aquafina.entity;

import com.hugomage.aquafina.util.RegistryHandler;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreatheAirGoal;
import net.minecraft.entity.ai.goal.FindWaterGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;

public class ArapaimaEntity
extends AnimalEntity {
    private static final Ingredient TEMPT_INGREDIENT = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196086_aW, Items.field_196087_aX});

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    public ArapaimaEntity(EntityType<? extends ArapaimaEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new MoveHelperController(this);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 100));
        this.field_70714_bg.func_75776_a(0, (Goal)new BreatheAirGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new FindWaterGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public boolean func_70877_b(ItemStack p_70877_1_) {
        return TEMPT_INGREDIENT.test(p_70877_1_);
    }

    protected PathNavigator func_175447_b(World p_175447_1_) {
        return new SwimmerPathNavigator((MobEntity)this, p_175447_1_);
    }

    public void func_70030_z() {
        int lvt_1_1_ = this.func_70086_ai();
        super.func_70030_z();
        this.updateAir(lvt_1_1_);
    }

    public boolean func_96092_aw() {
        return false;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)RegistryHandler.ARAPAIMA_SPAWN_EGG.get());
    }

    public static boolean checkArapaimaSpawns(EntityType<ArapaimaEntity> p_223364_0_, IWorld p_223364_1_, SpawnReason p_223364_2_, BlockPos p_223364_3_, Random p_223364_4_) {
        if (p_223364_3_.func_177956_o() > 45 && p_223364_3_.func_177956_o() < p_223364_1_.func_181545_F()) {
            Optional optional = p_223364_1_.func_242406_i(p_223364_3_);
            return (!Objects.equals(optional, Optional.of(Biomes.field_76782_w)) || !Objects.equals(optional, Optional.of(Biomes.field_222370_aw))) && p_223364_1_.func_204610_c(p_223364_3_).func_206884_a((ITag)FluidTags.field_206959_a);
        }
        return false;
    }

    public static boolean checkFishSpawnRules(EntityType<? extends AbstractFishEntity> p_223363_0_, IWorld p_223363_1_, SpawnReason p_223363_2_, BlockPos p_223363_3_, Random p_223363_4_) {
        return p_223363_1_.func_180495_p(p_223363_3_).func_203425_a(Blocks.field_150355_j) && p_223363_1_.func_180495_p(p_223363_3_.func_177984_a()).func_203425_a(Blocks.field_150355_j);
    }

    protected void updateAir(int air) {
        if (this.func_70089_S() && !this.func_203005_aq()) {
            this.func_70050_g(air - 1);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.func_70050_g(300);
        }
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        Item item = itemstack.func_77973_b();
        if (!this.field_70170_p.field_72995_K) {
            this.func_184185_a(SoundEvents.field_205207_aX, 1.0f, 1.0f);
        }
        if (this.func_70877_b(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
            if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.func_70691_i(item.func_219967_s().func_221466_a());
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), 0.0, 0.0, 0.0);
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203815_ax;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203816_ay;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_203813_aA;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.field_203818_az;
    }

    static class MoveHelperController
    extends MovementController {
        private final ArapaimaEntity fish;

        MoveHelperController(ArapaimaEntity p_i48857_1_) {
            super((MobEntity)p_i48857_1_);
            this.fish = p_i48857_1_;
        }

        public void func_75641_c() {
            if (this.fish.func_208600_a((ITag)FluidTags.field_206959_a)) {
                this.fish.func_213317_d(this.fish.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.fish.func_70661_as().func_75500_f()) {
                double lvt_1_1_ = this.field_75646_b - this.fish.func_226277_ct_();
                double lvt_3_1_ = this.field_75647_c - this.fish.func_226278_cu_();
                double lvt_5_1_ = this.field_75644_d - this.fish.func_226281_cx_();
                double lvt_7_1_ = MathHelper.func_76133_a((double)(lvt_1_1_ * lvt_1_1_ + lvt_3_1_ * lvt_3_1_ + lvt_5_1_ * lvt_5_1_));
                float lvt_9_1_ = (float)(MathHelper.func_181159_b((double)lvt_5_1_, (double)lvt_1_1_) * 57.2957763671875) - 90.0f;
                this.fish.field_70761_aq = this.fish.field_70177_z = this.func_75639_a(this.fish.field_70177_z, lvt_9_1_, 90.0f);
                float lvt_10_1_ = (float)(this.field_75645_e * this.fish.func_110148_a(Attributes.field_233821_d_).func_111126_e());
                this.fish.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.fish.func_70689_ay(), (float)lvt_10_1_));
                this.fish.func_213317_d(this.fish.func_213322_ci().func_72441_c(0.0, (double)this.fish.func_70689_ay() * (lvt_3_1_ /= lvt_7_1_) * 0.1, 0.0));
            } else {
                this.fish.func_70659_e(0.0f);
            }
        }
    }
}

