/*
 * Decompiled with CFR 0.152.
 */
package com.hugomage.aquafina.entity;

import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.DolphinLookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;

public class BelugaSturgeonEntity
extends WaterMobEntity {
    private static final Ingredient TEMPT_INGREDIENT = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196086_aW, Items.field_196087_aX});

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 50.0).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233821_d_, 3.0);
    }

    public BelugaSturgeonEntity(EntityType<? extends BelugaSturgeonEntity> type, World world) {
        super(type, world);
        this.field_70749_g = new DolphinLookController((MobEntity)this, 10);
        this.field_70765_h = new MoveHelperController(this);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal(this));
    }

    public static boolean checkBelugaSpawns(EntityType<BelugaSturgeonEntity> p_223364_0_, IWorld p_223364_1_, SpawnReason p_223364_2_, BlockPos p_223364_3_, Random p_223364_4_) {
        if (p_223364_3_.func_177956_o() > 45 && p_223364_3_.func_177956_o() < p_223364_1_.func_181545_F()) {
            Optional optional = p_223364_1_.func_242406_i(p_223364_3_);
            return (!Objects.equals(optional, Optional.of(Biomes.field_76777_m)) || !Objects.equals(optional, Optional.of(Biomes.field_150577_O))) && p_223364_1_.func_204610_c(p_223364_3_).func_206884_a((ITag)FluidTags.field_206959_a);
        }
        return false;
    }

    public static boolean checkFishSpawnRules(EntityType<? extends AbstractFishEntity> p_223363_0_, IWorld p_223363_1_, SpawnReason p_223363_2_, BlockPos p_223363_3_, Random p_223363_4_) {
        return p_223363_1_.func_180495_p(p_223363_3_).func_203425_a(Blocks.field_150355_j) && p_223363_1_.func_180495_p(p_223363_3_.func_177984_a()).func_203425_a(Blocks.field_150355_j);
    }

    public boolean isFood(ItemStack p_70877_1_) {
        return TEMPT_INGREDIENT.test(p_70877_1_);
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        Item item = itemstack.func_77973_b();
        if (this.isFood(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
            if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            this.func_70691_i(item.func_219967_s().func_221466_a());
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203815_ax;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203816_ay;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_203813_aA;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.field_203818_az;
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        private final BelugaSturgeonEntity fish;

        public SwimGoal(BelugaSturgeonEntity fish) {
            super((CreatureEntity)fish, 1.0, 40);
            this.fish = fish;
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final BelugaSturgeonEntity dolphin;

        public MoveHelperController(BelugaSturgeonEntity p_i48945_1_) {
            super((MobEntity)p_i48945_1_);
            this.dolphin = p_i48945_1_;
        }

        public void func_75641_c() {
            if (this.dolphin.func_70090_H()) {
                this.dolphin.func_213317_d(this.dolphin.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.dolphin.func_70661_as().func_75500_f()) {
                double d2;
                double d1;
                double d0 = this.field_75646_b - this.dolphin.func_226277_ct_();
                double d3 = d0 * d0 + (d1 = this.field_75647_c - this.dolphin.func_226278_cu_()) * d1 + (d2 = this.field_75644_d - this.dolphin.func_226281_cx_()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                } else {
                    float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.dolphin.field_70761_aq = this.dolphin.field_70177_z = this.func_75639_a(this.dolphin.field_70177_z, f, 10.0f);
                    this.dolphin.field_70759_as = this.dolphin.field_70177_z;
                    float f1 = (float)(this.field_75645_e * this.dolphin.func_233637_b_(Attributes.field_233821_d_));
                    if (this.dolphin.func_70090_H()) {
                        this.dolphin.func_70659_e(f1 * 0.02f);
                        float f2 = -((float)(MathHelper.func_181159_b((double)d1, (double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2))) * 57.2957763671875));
                        f2 = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)f2), (float)-85.0f, (float)85.0f);
                        this.dolphin.field_70125_A = this.func_75639_a(this.dolphin.field_70125_A, f2, 5.0f);
                        float f3 = MathHelper.func_76134_b((float)(this.dolphin.field_70125_A * ((float)Math.PI / 180)));
                        float f4 = MathHelper.func_76126_a((float)(this.dolphin.field_70125_A * ((float)Math.PI / 180)));
                        this.dolphin.field_191988_bg = f3 * f1;
                        this.dolphin.field_70701_bs = -f4 * f1;
                    } else {
                        this.dolphin.func_70659_e(f1 * 0.1f);
                    }
                }
            } else {
                this.dolphin.func_70659_e(0.0f);
                this.dolphin.func_184646_p(0.0f);
                this.dolphin.func_70657_f(0.0f);
                this.dolphin.func_191989_p(0.0f);
            }
        }
    }
}

