/*
 * Decompiled with CFR 0.152.
 */
package com.hugomage.aquafina.entity;

import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;

public class GoliathCatfishEntity
extends WaterMobEntity {
    private static final Ingredient TEMPT_INGREDIENT = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196086_aW, Items.field_196087_aX});

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 35.0).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233821_d_, 2.0);
    }

    public static boolean checkFishSpawnRules(EntityType<? extends WaterMobEntity> type, IWorld worldIn, SpawnReason reason, BlockPos p_223363_3_, Random randomIn) {
        return worldIn.func_180495_p(p_223363_3_).func_203425_a(Blocks.field_150355_j) && worldIn.func_180495_p(p_223363_3_.func_177984_a()).func_203425_a(Blocks.field_150355_j) && worldIn.func_72912_H().func_76073_f() < 12000L && worldIn.func_72912_H().func_76073_f() > 24000L && randomIn.nextFloat() > 0.7f;
    }

    public GoliathCatfishEntity(EntityType<? extends GoliathCatfishEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new MoveHelperController(this);
    }

    public static boolean checkGoliathCatfishSpawns(EntityType<GoliathCatfishEntity> p_223364_0_, IWorld p_223364_1_, SpawnReason p_223364_2_, BlockPos p_223364_3_, Random p_223364_4_) {
        if (p_223364_3_.func_177956_o() > 45 && p_223364_3_.func_177956_o() < p_223364_1_.func_181545_F()) {
            Optional optional = p_223364_1_.func_242406_i(p_223364_3_);
            return (!Objects.equals(optional, Optional.of(Biomes.field_76780_h)) || !Objects.equals(optional, Optional.of(Biomes.field_150599_m))) && p_223364_1_.func_204610_c(p_223364_3_).func_206884_a((ITag)FluidTags.field_206959_a);
        }
        return false;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal(this));
    }

    public boolean isFood(ItemStack p_70877_1_) {
        return TEMPT_INGREDIENT.test(p_70877_1_);
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        Item item = itemstack.func_77973_b();
        if (this.isFood(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
            if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            this.func_70691_i(item.func_219967_s().func_221466_a());
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203815_ax;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203816_ay;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_203813_aA;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.field_203818_az;
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        private final GoliathCatfishEntity fish;

        public SwimGoal(GoliathCatfishEntity fish) {
            super((CreatureEntity)fish, 1.0, 40);
            this.fish = fish;
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final GoliathCatfishEntity sturgeonEntity;

        public MoveHelperController(GoliathCatfishEntity sturgeonEntity) {
            super((MobEntity)sturgeonEntity);
            this.sturgeonEntity = sturgeonEntity;
        }
    }
}

