/*
 * Decompiled with CFR 0.152.
 */
package com.hugomage.aquafina.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class LionManJellyfishEntity
extends WaterMobEntity {
    public float xBodyRot;
    public float xBodyRotO;
    public float zBodyRot;
    public float zBodyRotO;
    public float tentacleMovement;
    public float oldTentacleMovement;
    public float tentacleAngle;
    public float oldTentacleAngle;
    private float speed;
    private float tentacleSpeed;
    private float rotateSpeed;
    private float tx;
    private float ty;
    private float tz;
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(LionManJellyfishEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public LionManJellyfishEntity(EntityType<? extends LionManJellyfishEntity> p_i49856_1_, World p_i49856_2_) {
        super(p_i49856_1_, p_i49856_2_);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233821_d_, 0.1);
    }

    protected ItemStack getBucketItemStack() {
        return null;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new MoveRandomGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public void func_70100_b_(PlayerEntity p_70100_1_) {
        p_70100_1_.func_195064_c(new EffectInstance(Effects.field_76436_u, 60, 0));
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    private void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    protected void saveToBucketTag(ItemStack bucket) {
        CompoundNBT compoundnbt = bucket.func_196082_o();
        compoundnbt.func_74768_a("Variant", this.getVariant());
        if (this.func_145818_k_()) {
            bucket.func_200302_a(this.func_200201_e());
        }
    }

    private Vector3d rotateVector(Vector3d p_207400_1_) {
        Vector3d vector3d = p_207400_1_.func_178789_a(this.xBodyRotO * ((float)Math.PI / 180));
        return vector3d.func_178785_b(-this.field_70760_ar * ((float)Math.PI / 180));
    }

    public void setMovementVector(float p_175568_1_, float p_175568_2_, float p_175568_3_) {
        this.tx = p_175568_1_;
        this.ty = p_175568_2_;
        this.tz = p_175568_3_;
    }

    public boolean hasMovementVector() {
        return this.tx != 0.0f || this.ty != 0.0f || this.tz != 0.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (dataTag == null) {
            this.setVariant(this.field_70146_Z.nextInt(1));
        } else if (dataTag.func_150297_b("Variant", 3)) {
            this.setVariant(dataTag.func_74762_e("Variant"));
        }
        return spawnDataIn;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203815_ax;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203816_ay;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_203813_aA;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.field_203818_az;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.xBodyRotO = this.xBodyRot;
        this.zBodyRotO = this.zBodyRot;
        this.oldTentacleMovement = this.tentacleMovement;
        this.oldTentacleAngle = this.tentacleAngle;
        this.tentacleMovement += this.tentacleSpeed;
        if ((double)this.tentacleMovement > Math.PI * 2) {
            if (this.field_70170_p.field_72995_K) {
                this.tentacleMovement = (float)Math.PI * 2;
            } else {
                this.tentacleMovement = (float)((double)this.tentacleMovement - Math.PI * 2);
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.tentacleSpeed = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)19);
            }
        }
        if (this.func_203005_aq()) {
            if (this.tentacleMovement < (float)Math.PI) {
                float f = this.tentacleMovement / (float)Math.PI;
                this.tentacleAngle = MathHelper.func_76126_a((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.speed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.tentacleAngle = 0.0f;
                this.speed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_213293_j(this.tx * this.speed, this.ty * this.speed, this.tz * this.speed);
            }
            Vector3d vector3d = this.func_213322_ci();
            float f1 = MathHelper.func_76133_a((double)LionManJellyfishEntity.func_213296_b((Vector3d)vector3d));
            this.field_70761_aq += (-((float)MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c)) * 57.295776f - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            this.zBodyRot = (float)((double)this.zBodyRot + Math.PI * (double)this.rotateSpeed * 1.5);
            this.xBodyRot += (-((float)MathHelper.func_181159_b((double)f1, (double)vector3d.field_72448_b)) * 57.295776f - this.xBodyRot) * 0.1f;
        } else {
            this.tentacleAngle = MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)this.tentacleMovement)) * (float)Math.PI * 0.25f;
            if (!this.field_70170_p.field_72995_K) {
                double d0 = this.func_213322_ci().field_72448_b;
                if (this.func_70644_a(Effects.field_188424_y)) {
                    d0 = 0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1);
                } else if (!this.func_189652_ae()) {
                    d0 -= 0.08;
                }
                this.func_213293_j(0.0, d0 * (double)0.98f, 0.0);
            }
            this.xBodyRot = (float)((double)this.xBodyRot + (double)(-90.0f - this.xBodyRot) * 0.02);
        }
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        private final LionManJellyfishEntity fish;

        public SwimGoal(LionManJellyfishEntity fish) {
            super((CreatureEntity)fish, 2.0, 40);
            this.fish = fish;
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }
    }

    class MoveRandomGoal
    extends Goal {
        private final LionManJellyfishEntity squid;

        public MoveRandomGoal(LionManJellyfishEntity p_i48823_2_) {
            this.squid = p_i48823_2_;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            int i = this.squid.func_70654_ax();
            if (i > 100) {
                this.squid.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.squid.func_70681_au().nextInt(50) == 0 || !this.squid.hasMovementVector()) {
                float f = this.squid.func_70681_au().nextFloat() * ((float)Math.PI * 2);
                float f1 = MathHelper.func_76134_b((float)f) * 0.2f;
                float f2 = -0.1f + this.squid.func_70681_au().nextFloat() * 0.2f;
                float f3 = MathHelper.func_76126_a((float)f) * 0.2f;
                this.squid.setMovementVector(f1, f2, f3);
            }
        }
    }
}

