/*
 * Decompiled with CFR 0.152.
 */
package com.hugomage.aquafina.entity;

import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class MarlinEntity
extends AbstractFishEntity {
    private static final Ingredient TEMPT_INGREDIENT = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196086_aW, Items.field_196087_aX});

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 50.0).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233821_d_, 1.0);
    }

    public MarlinEntity(EntityType<? extends MarlinEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new MoveHelperController(this);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new SwimmerPathNavigator((MobEntity)this, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public boolean isFood(ItemStack p_70877_1_) {
        return TEMPT_INGREDIENT.test(p_70877_1_);
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        Item item = itemstack.func_77973_b();
        if (this.isFood(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
            if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            this.func_70691_i(item.func_219967_s().func_221466_a());
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    protected ItemStack func_203707_dx() {
        return null;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203815_ax;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203816_ay;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_203813_aA;
    }

    protected SoundEvent func_203701_dz() {
        return SoundEvents.field_203818_az;
    }

    static class MoveHelperController
    extends MovementController {
        private final MarlinEntity fish;

        MoveHelperController(MarlinEntity p_i48857_1_) {
            super((MobEntity)p_i48857_1_);
            this.fish = p_i48857_1_;
        }

        public void func_75641_c() {
            if (this.fish.func_208600_a((ITag)FluidTags.field_206959_a)) {
                this.fish.func_213317_d(this.fish.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.fish.func_70661_as().func_75500_f()) {
                float f = (float)(this.field_75645_e * this.fish.func_233637_b_(Attributes.field_233821_d_));
                this.fish.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.fish.func_70689_ay(), (float)f));
                double d0 = this.field_75646_b - this.fish.func_226277_ct_();
                double d1 = this.field_75647_c - this.fish.func_226278_cu_();
                double d2 = this.field_75644_d - this.fish.func_226281_cx_();
                if (d1 != 0.0) {
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    this.fish.func_213317_d(this.fish.func_213322_ci().func_72441_c(0.0, (double)this.fish.func_70689_ay() * (d1 / d3) * 0.1, 0.0));
                }
            } else {
                this.fish.func_70659_e(0.0f);
            }
        }
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        private final MarlinEntity fish;

        public SwimGoal(MarlinEntity fish) {
            super((CreatureEntity)fish, 1.0, 40);
            this.fish = fish;
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }
    }
}

