/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api;

import com.hollingsworth.arsnouveau.api.enchanting_apparatus.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class ArsNouveauAPI {
    private HashMap<String, AbstractSpellPart> spell_map = new HashMap();
    private HashMap<String, Glyph> glyphMap = new HashMap();
    private ArrayList<IEnchantingRecipe> enchantingApparatusRecipes;
    private ArrayList<AbstractSpellPart> startingSpells = new ArrayList();
    private static ArsNouveauAPI arsNouveauAPI = null;

    public ArrayList<AbstractSpellPart> getStartingSpells() {
        return this.startingSpells;
    }

    public boolean addStartingSpell(String tag) {
        if (ArsNouveauAPI.getInstance().getSpell_map().containsKey(tag)) {
            return this.startingSpells.add(ArsNouveauAPI.getInstance().getSpell_map().get(tag));
        }
        throw new RuntimeException("Attempted to add a starting spell for an unregistered spell. Spells must be added to the Spell Map first!");
    }

    public Item getGlyphItem(String glyphName) {
        for (Item i : ItemsRegistry.RegistrationHandler.ITEMS) {
            if (!i.getRegistryName().equals((Object)new ResourceLocation("ars_nouveau", this.getSpellRegistryName(glyphName)))) continue;
            return i;
        }
        return null;
    }

    public Item getGlyphItem(AbstractSpellPart spell) {
        return this.getGlyphItem(spell.tag);
    }

    public Glyph hasCraftingReagent(Item item) {
        return this.getGlyphMap().values().stream().filter(a -> a.spellPart.getCraftingReagent() == item).findFirst().orElse(null);
    }

    public AbstractSpellPart registerSpell(String id, AbstractSpellPart part) {
        this.glyphMap.put(id, new Glyph(this.getSpellRegistryName(id), part));
        return this.spell_map.put(id, part);
    }

    public String getSpellRegistryName(String id) {
        return "glyph_" + id.toLowerCase();
    }

    public HashMap<String, AbstractSpellPart> getSpell_map() {
        return this.spell_map;
    }

    public HashMap<String, Glyph> getGlyphMap() {
        return this.glyphMap;
    }

    public ArrayList<IEnchantingRecipe> getEnchantingApparatusRecipes() {
        return this.enchantingApparatusRecipes;
    }

    private ArsNouveauAPI() {
        this.enchantingApparatusRecipes = new ArrayList();
    }

    public static ArsNouveauAPI getInstance() {
        if (arsNouveauAPI == null) {
            arsNouveauAPI = new ArsNouveauAPI();
        }
        return arsNouveauAPI;
    }

    public static enum PatchouliCategories {
        spells,
        machines,
        equipment,
        resources,
        getting_started,
        automation;

    }
}

