/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.client;

import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class RenderEventQueue {
    List<ITimedEvent> events = new ArrayList<ITimedEvent>();
    private static RenderEventQueue eventQueue;

    public void tick(RenderWorldLastEvent evt, PlayerEntity player, float renderPartialTicks) {
        if (this.events == null || this.events.size() == 0) {
            return;
        }
        ListIterator<ITimedEvent> eventListIterator = this.events.listIterator();
        while (eventListIterator.hasNext()) {
            ITimedEvent event = eventListIterator.next();
            if (event.isExpired()) {
                eventListIterator.remove();
                continue;
            }
            event.tick();
            event.tick(evt, player, renderPartialTicks);
        }
    }

    public void addEvent(ITimedEvent event) {
        this.events.add(event);
    }

    public static RenderEventQueue getInstance() {
        if (eventQueue == null) {
            eventQueue = new RenderEventQueue();
        }
        return eventQueue;
    }

    private RenderEventQueue() {
    }
}

