/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.enchanting_apparatus;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.common.block.tile.EnchantingApparatusTile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class EnchantingApparatusRecipe
implements IEnchantingRecipe {
    public ItemStack catalyst;
    public ItemStack result;
    public List<ItemStack> pedestalItems;
    public String description;
    private String category;

    public EnchantingApparatusRecipe(ItemStack result, ItemStack catalyst, List<ItemStack> pedestalItems, String category) {
        this.catalyst = catalyst;
        this.pedestalItems = pedestalItems;
        this.result = result;
        this.category = category;
    }

    public EnchantingApparatusRecipe(ItemStack result, ItemStack catalyst, ItemStack pedestalItems, String category) {
        this(result, catalyst, Collections.singletonList(pedestalItems), category);
    }

    public EnchantingApparatusRecipe(Item result, Item catalyst, Item[] pedestalItems, String category) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Item i : pedestalItems) {
            stacks.add(new ItemStack((IItemProvider)i));
        }
        this.catalyst = new ItemStack((IItemProvider)catalyst);
        this.result = new ItemStack((IItemProvider)result);
        this.pedestalItems = stacks;
        this.category = category;
    }

    @Override
    public boolean isMatch(List<ItemStack> pedestalItems, ItemStack reagent, EnchantingApparatusTile enchantingApparatusTile) {
        pedestalItems = pedestalItems.stream().filter(itemStack -> !itemStack.func_190926_b()).collect(Collectors.toList());
        return this.catalyst != null && reagent.func_77973_b() == this.catalyst.func_77973_b() && this.pedestalItems.size() == pedestalItems.size() && EnchantingApparatusRecipe.areSameSet(pedestalItems, this.pedestalItems);
    }

    @Override
    public ItemStack getResult(List<ItemStack> pedestalItems, ItemStack reagent, EnchantingApparatusTile enchantingApparatusTile) {
        return this.result;
    }

    public boolean isEqualTo(EnchantingApparatusRecipe other) {
        return other.result == this.result && this.catalyst == other.catalyst && this.pedestalItems.size() == other.pedestalItems.size() && EnchantingApparatusRecipe.areSameSet(this.pedestalItems, other.pedestalItems);
    }

    static boolean areSameSet(List<ItemStack> A, List<ItemStack> B) {
        if (A.size() != B.size()) {
            return false;
        }
        A.sort(Comparator.comparing(a -> a.func_77973_b().getRegistryName().toString()));
        B.sort(Comparator.comparing(a -> a.func_77973_b().getRegistryName().toString()));
        for (int i = 0; i < A.size(); ++i) {
            if (A.get(i).func_77973_b() == B.get(i).func_77973_b()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnchantingApparatusRecipe that = (EnchantingApparatusRecipe)o;
        return Objects.equals(this.catalyst, that.catalyst) && Objects.equals(this.pedestalItems, that.pedestalItems);
    }

    public int hashCode() {
        return Objects.hash(this.catalyst, this.pedestalItems);
    }

    public String toString() {
        return "EnchantingApparatusRecipe{catalyst=" + this.catalyst + ", result=" + this.result + ", pedestalItems=" + this.pedestalItems + '}';
    }

    public JsonElement serialize() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("name", this.result.func_77973_b().func_77658_a());
        jsonobject.addProperty("icon", this.result.func_77973_b().getRegistryName().toString());
        jsonobject.addProperty("category", this.category);
        JsonArray jsonArray = new JsonArray();
        JsonObject descPage = new JsonObject();
        descPage.addProperty("type", "text");
        descPage.addProperty("text", "ars_nouveau.page." + this.result.func_77973_b().getRegistryName().toString().replace("ars_nouveau:", ""));
        JsonObject infoPage = new JsonObject();
        infoPage.addProperty("type", "apparatus_recipe");
        infoPage.addProperty("reagent", this.catalyst.func_77973_b().getRegistryName().toString());
        if (this.pedestalItems != null) {
            AtomicInteger count = new AtomicInteger(1);
            this.pedestalItems.forEach(i -> {
                infoPage.addProperty("item" + count.get(), i.func_77973_b().getRegistryName().toString());
                count.addAndGet(1);
            });
        }
        jsonArray.add((JsonElement)descPage);
        jsonArray.add((JsonElement)infoPage);
        jsonobject.add("pages", (JsonElement)jsonArray);
        return jsonobject;
    }

    @Override
    public boolean consumesMana() {
        return false;
    }

    @Override
    public int manaCost() {
        return 0;
    }
}

