/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.enchanting_apparatus;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.common.block.tile.EnchantingApparatusTile;
import com.hollingsworth.arsnouveau.common.enchantment.EnchantmentRegistry;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;

public class ReactiveEnchantmentRecipe
implements IEnchantingRecipe {
    public boolean isWriteSpell(List<ItemStack> pedestalItems, ItemStack reagent) {
        ItemStack[] items = new ItemStack[]{ItemsRegistry.spellParchment.getStack()};
        List<ItemStack> stacks = Arrays.asList(items);
        if (EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.REACTIVE_ENCHANTMENT, (ItemStack)reagent) == 0) {
            return false;
        }
        if (!EnchantingApparatusRecipe.areSameSet(stacks, pedestalItems)) {
            return false;
        }
        for (ItemStack stack : pedestalItems) {
            if (!(stack.func_77973_b() instanceof SpellParchment) || SpellParchment.getSpellRecipe(stack) != null) continue;
            return false;
        }
        return true;
    }

    public boolean isLevelOne(List<ItemStack> pedestalItems, ItemStack reagent) {
        ItemStack[] items = new ItemStack[]{new ItemStack((IItemProvider)ItemsRegistry.spellParchment), new ItemStack((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem("amplify")), new ItemStack((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem("amplify")), new ItemStack((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem("amplify"))};
        List<ItemStack> stacks = Arrays.asList(items);
        if (EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.REACTIVE_ENCHANTMENT, (ItemStack)reagent) != 0) {
            return false;
        }
        if (!EnchantingApparatusRecipe.areSameSet(stacks, pedestalItems)) {
            return false;
        }
        for (ItemStack stack : pedestalItems) {
            if (!(stack.func_77973_b() instanceof SpellParchment) || SpellParchment.getSpellRecipe(stack) != null) continue;
            return false;
        }
        return true;
    }

    public boolean isLevelTwo(List<ItemStack> pedestalItems, ItemStack reagent) {
        ItemStack[] items = new ItemStack[]{new ItemStack((IItemProvider)Items.field_151065_br), new ItemStack((IItemProvider)Items.field_151065_br), new ItemStack((IItemProvider)Items.field_151065_br), new ItemStack((IItemProvider)Items.field_151065_br), new ItemStack((IItemProvider)Items.field_221696_bj), new ItemStack((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem("extend_time")), new ItemStack((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem("aoe")), new ItemStack((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem("dampen"))};
        List<ItemStack> stacks = Arrays.asList(items);
        if (EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.REACTIVE_ENCHANTMENT, (ItemStack)reagent) != 1) {
            return false;
        }
        return EnchantingApparatusRecipe.areSameSet(stacks, pedestalItems);
    }

    public boolean isLevelThree(List<ItemStack> pedestalItems, ItemStack reagent) {
        ItemStack[] items = new ItemStack[]{ItemsRegistry.mythicalClay.getStack(), ItemsRegistry.mythicalClay.getStack(), ItemsRegistry.mythicalClay.getStack(), ItemsRegistry.mythicalClay.getStack(), new ItemStack((IItemProvider)Items.field_151079_bi), new ItemStack((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem("pierce")), new ItemStack((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem("extract")), new ItemStack((IItemProvider)ArsNouveauAPI.getInstance().getGlyphItem("fortune"))};
        List<ItemStack> stacks = Arrays.asList(items);
        if (EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.REACTIVE_ENCHANTMENT, (ItemStack)reagent) != 2) {
            return false;
        }
        return EnchantingApparatusRecipe.areSameSet(stacks, pedestalItems);
    }

    public ItemStack getParchment(List<ItemStack> pedestalItems) {
        for (ItemStack stack : pedestalItems) {
            if (!(stack.func_77973_b() instanceof SpellParchment)) continue;
            return stack;
        }
        return null;
    }

    @Override
    public boolean isMatch(List<ItemStack> pedestalItems, ItemStack reagent, EnchantingApparatusTile enchantingApparatusTile) {
        if (this.isLevelOne(pedestalItems, reagent) && ManaUtil.hasManaNearby(enchantingApparatusTile.func_174877_v(), enchantingApparatusTile.func_145831_w(), 10, this.manaCost())) {
            return true;
        }
        if (this.isLevelTwo(pedestalItems, reagent) && ManaUtil.hasManaNearby(enchantingApparatusTile.func_174877_v(), enchantingApparatusTile.func_145831_w(), 10, this.manaCost() * 2)) {
            return true;
        }
        if (this.isLevelThree(pedestalItems, reagent) && ManaUtil.hasManaNearby(enchantingApparatusTile.func_174877_v(), enchantingApparatusTile.func_145831_w(), 10, this.manaCost() * 3)) {
            return true;
        }
        return this.isWriteSpell(pedestalItems, reagent);
    }

    @Override
    public ItemStack getResult(List<ItemStack> pedestalItems, ItemStack reagent, EnchantingApparatusTile enchantingApparatusTile) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)reagent);
        if (this.isLevelOne(pedestalItems, reagent)) {
            enchantments.put(EnchantmentRegistry.REACTIVE_ENCHANTMENT, 1);
            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)reagent);
            CompoundNBT tag = reagent.func_77978_p();
            ItemStack parchment = this.getParchment(pedestalItems);
            tag.func_74778_a("spell", parchment.func_77978_p().func_74779_i("spell"));
            reagent.func_77982_d(tag);
        } else if (this.isLevelTwo(pedestalItems, reagent) && ManaUtil.takeManaNearby(enchantingApparatusTile.func_174877_v(), enchantingApparatusTile.func_145831_w(), 10, this.manaCost() * 2) != null) {
            enchantments.put(EnchantmentRegistry.REACTIVE_ENCHANTMENT, 2);
            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)reagent);
        } else if (this.isLevelThree(pedestalItems, reagent) && ManaUtil.takeManaNearby(enchantingApparatusTile.func_174877_v(), enchantingApparatusTile.func_145831_w(), 10, this.manaCost() * 3) != null) {
            enchantments.put(EnchantmentRegistry.REACTIVE_ENCHANTMENT, 3);
            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)reagent);
        } else if (this.isWriteSpell(pedestalItems, reagent)) {
            CompoundNBT tag = reagent.func_77978_p();
            ItemStack parchment = this.getParchment(pedestalItems);
            tag.func_74778_a("spell", parchment.func_77978_p().func_74779_i("spell"));
            reagent.func_77982_d(tag);
        }
        return reagent;
    }

    @Override
    public int manaCost() {
        return 3000;
    }

    @Override
    public boolean consumesMana() {
        return true;
    }
}

