/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.event;

import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import java.util.ArrayList;
import java.util.List;

public class EventQueue {
    List<ITimedEvent> events = new ArrayList<ITimedEvent>();
    private static EventQueue eventQueue;

    public void tick() {
        if (this.events == null || this.events.isEmpty()) {
            return;
        }
        ArrayList<ITimedEvent> stale = new ArrayList<ITimedEvent>();
        for (int i = 0; i < this.events.size(); ++i) {
            ITimedEvent event = this.events.get(i);
            if (event.isExpired()) {
                stale.add(event);
                continue;
            }
            event.tick();
        }
        this.events.removeAll(stale);
    }

    public void addEvent(ITimedEvent event) {
        if (this.events == null) {
            this.events = new ArrayList<ITimedEvent>();
        }
        this.events.add(event);
    }

    public static EventQueue getInstance() {
        if (eventQueue == null) {
            eventQueue = new EventQueue();
        }
        return eventQueue;
    }

    public void clear() {
        this.events = null;
    }

    private EventQueue() {
    }
}

