/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class AbstractEffect
extends AbstractSpellPart {
    public AbstractEffect(String tag, String description) {
        super(tag, description);
    }

    public abstract void onResolve(RayTraceResult var1, World var2, @Nullable LivingEntity var3, List<AbstractAugment> var4, SpellContext var5);

    public void applyPotion(LivingEntity entity, Effect potionEffect, List<AbstractAugment> augmentTypes) {
        this.applyPotion(entity, potionEffect, augmentTypes, 30, 30);
    }

    public void applyPotion(LivingEntity entity, Effect potionEffect, List<AbstractAugment> augmentTypes, int baseDuration, int durationBuffBase) {
        if (entity == null) {
            return;
        }
        int duration = baseDuration + durationBuffBase * AbstractEffect.getBuffCount(augmentTypes, AugmentExtendTime.class);
        int amp = AbstractEffect.getBuffCount(augmentTypes, AugmentAmplify.class);
        entity.func_195064_c(new EffectInstance(potionEffect, duration * 20, amp));
    }

    public Vec3d safelyGetHitPos(RayTraceResult result) {
        if (result instanceof EntityRayTraceResult) {
            return ((EntityRayTraceResult)result).func_216348_a() != null ? ((EntityRayTraceResult)result).func_216348_a().func_213303_ch() : result.func_216347_e();
        }
        return result.func_216347_e();
    }

    public boolean wouldSucceed(RayTraceResult rayTraceResult, World world, LivingEntity shooter, List<AbstractAugment> augments) {
        return true;
    }

    public boolean nonAirBlockSuccess(RayTraceResult rayTraceResult, World world) {
        return rayTraceResult instanceof BlockRayTraceResult && world.func_180495_p(((BlockRayTraceResult)rayTraceResult).func_216350_a()).func_185904_a() != Material.field_151579_a;
    }

    public boolean livingEntityHitSuccess(RayTraceResult rayTraceResult) {
        return rayTraceResult instanceof EntityRayTraceResult && ((EntityRayTraceResult)rayTraceResult).func_216348_a() instanceof LivingEntity;
    }

    public boolean nonAirAnythingSuccess(RayTraceResult result, World world) {
        return this.nonAirBlockSuccess(result, world) || this.livingEntityHitSuccess(result);
    }
}

