/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.Item;

public abstract class AbstractSpellPart
implements ISpellTier,
Comparable<AbstractSpellPart> {
    public String tag;
    public String name;

    public abstract int getManaCost();

    public String getTag() {
        return this.tag;
    }

    public String getIcon() {
        return this.tag + ".png";
    }

    protected AbstractSpellPart(String tag, String name) {
        this.tag = tag;
        this.name = name;
    }

    public int getAdjustedManaCost(List<AbstractAugment> augmentTypes) {
        int cost = this.getManaCost();
        for (AbstractAugment a : augmentTypes) {
            if (a instanceof AugmentDampen && !this.dampenIsAllowed()) continue;
            cost += a.getManaCost();
        }
        return Math.max(cost, 0);
    }

    @Nullable
    public Item getCraftingReagent() {
        return null;
    }

    public boolean dampenIsAllowed() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.ONE;
    }

    public static int getBuffCount(List<AbstractAugment> augments, Class<? extends AbstractSpellPart> spellClass) {
        return (int)augments.stream().filter(spellClass::isInstance).count();
    }

    public boolean hasBuff(List<AbstractAugment> augments, Class<? extends AbstractSpellPart> spellClass) {
        return AbstractSpellPart.getBuffCount(augments, spellClass) > 0;
    }

    public int getAmplificationBonus(List<AbstractAugment> augmentTypes) {
        return AbstractSpellPart.getBuffCount(augmentTypes, AugmentAmplify.class) - AbstractSpellPart.getBuffCount(augmentTypes, AugmentDampen.class);
    }

    @Override
    public int compareTo(AbstractSpellPart o) {
        return this.getTier().ordinal() - o.getTier().ordinal();
    }

    public JsonElement serialize() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("name", this.getName());
        jsonobject.addProperty("icon", "ars_nouveau:" + this.getItemID());
        jsonobject.addProperty("category", "spells_" + (this.getTier().ordinal() + 1));
        jsonobject.addProperty("sortnum", (Number)(this instanceof AbstractCastMethod ? 1 : (this instanceof AbstractEffect ? 2 : 3)));
        JsonArray jsonArray = new JsonArray();
        JsonObject descPage = new JsonObject();
        descPage.addProperty("type", "text");
        descPage.addProperty("text", this.getBookDescription());
        JsonObject infoPage = new JsonObject();
        infoPage.addProperty("type", "glyph_recipe");
        infoPage.addProperty("tier", this.getTier().name());
        String manaCost = this.getManaCost() < 20 ? "Low" : "Medium";
        manaCost = this.getManaCost() > 50 ? "High" : manaCost;
        infoPage.addProperty("mana_cost", manaCost);
        if (this.getCraftingReagent() != null) {
            String clayType = this.getTier() == ISpellTier.Tier.ONE ? ItemsRegistry.magicClay.getRegistryName().toString() : (this.getTier() == ISpellTier.Tier.TWO ? ItemsRegistry.marvelousClay.getRegistryName().toString() : ItemsRegistry.mythicalClay.getRegistryName().toString());
            infoPage.addProperty("clay_type", clayType);
            infoPage.addProperty("reagent", this.getCraftingReagent().getRegistryName().toString());
        }
        jsonArray.add((JsonElement)descPage);
        jsonArray.add((JsonElement)infoPage);
        jsonobject.add("pages", (JsonElement)jsonArray);
        return jsonobject;
    }

    public String getItemID() {
        return "glyph_" + this.getTag();
    }

    protected String getBookDescription() {
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractSpellPart that = (AbstractSpellPart)o;
        return this.getTag().equals(that.getTag()) && this.getName().equals(that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getTag(), this.getName());
    }
}

