/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tileentity.TileEntity;

public class SpellContext {
    private int manaCost;
    private boolean isCanceled;
    public final List<AbstractSpellPart> recipe;
    @Nullable
    public final LivingEntity caster;
    private int currentIndex;
    @Nullable
    public TileEntity castingTile;

    public SpellContext(List<AbstractSpellPart> recipe, @Nullable LivingEntity caster) {
        this.recipe = recipe;
        this.caster = caster;
        this.isCanceled = false;
        this.currentIndex = 0;
    }

    public AbstractSpellPart nextSpell() {
        ++this.currentIndex;
        return this.recipe.get(this.currentIndex - 1);
    }

    public void resetSpells() {
        this.currentIndex = 0;
    }

    public SpellContext withCastingTile(TileEntity tile) {
        this.castingTile = tile;
        return this;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public int getManaCost() {
        return this.manaCost;
    }

    public void setManaCost(int manaCost) {
        this.manaCost = manaCost;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean canceled) {
        this.isCanceled = canceled;
    }

    public List<AbstractSpellPart> getRecipe() {
        return this.recipe;
    }

    @Nullable
    public LivingEntity getCaster() {
        return this.caster;
    }
}

