/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.api.util.SpellRecipeUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.capability.ManaCapability;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;

public class SpellResolver {
    public AbstractCastMethod castType;
    public List<AbstractSpellPart> spell_recipe;
    public final SpellContext spellContext;
    public boolean silent;

    public SpellResolver(AbstractCastMethod cast, List<AbstractSpellPart> spell_recipe, SpellContext context) {
        this.castType = cast;
        this.spell_recipe = spell_recipe;
        this.spellContext = context;
        if (this.castType != null) {
            this.castType.resolver = this;
        }
    }

    public SpellResolver(AbstractSpellPart[] spellParts, SpellContext context) {
        this(new ArrayList<AbstractSpellPart>(Arrays.asList(spellParts)), context);
    }

    public SpellResolver(List<AbstractSpellPart> spell_recipe, SpellContext context) {
        this(null, spell_recipe, context);
        AbstractCastMethod method = null;
        if (spell_recipe != null && !spell_recipe.isEmpty() && spell_recipe.get(0) instanceof AbstractCastMethod) {
            method = (AbstractCastMethod)spell_recipe.get(0);
        }
        this.castType = method;
        if (this.castType != null) {
            this.castType.resolver = this;
        }
    }

    public SpellResolver(List<AbstractSpellPart> spell_recipe, boolean silent, SpellContext context) {
        this(spell_recipe, context);
        this.silent = silent;
    }

    public boolean canCast(LivingEntity entity) {
        int numMethods = 0;
        if (this.spell_recipe == null || this.spell_recipe.isEmpty() || this.castType == null) {
            if (!this.silent) {
                entity.func_145747_a((ITextComponent)new StringTextComponent("Invalid Spell."));
            }
            return false;
        }
        for (AbstractSpellPart spellPart : this.spell_recipe) {
            if (!(spellPart instanceof AbstractCastMethod)) continue;
            ++numMethods;
        }
        if (numMethods > 1 && !this.silent) {
            entity.func_145747_a((ITextComponent)new TranslationTextComponent("ars_nouveau.alert.duplicate_method", new Object[0]));
            return false;
        }
        return this.enoughMana(entity);
    }

    boolean enoughMana(LivingEntity entity) {
        int totalCost = ManaUtil.getCastingCost(this.spell_recipe, entity);
        AtomicBoolean canCast = new AtomicBoolean(false);
        ManaCapability.getMana(entity).ifPresent(mana -> {
            canCast.set(totalCost <= mana.getCurrentMana() || entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_());
            if (!(canCast.get() || entity.func_130014_f_().field_72995_K || this.silent)) {
                entity.func_145747_a((ITextComponent)new StringTextComponent("Not enough mana."));
            }
        });
        return canCast.get();
    }

    public boolean postEvent(LivingEntity entity) {
        return SpellUtil.postEvent(new SpellCastEvent(entity, this.spell_recipe));
    }

    public void onCast(ItemStack stack, LivingEntity livingEntity, World world) {
        if (this.canCast(livingEntity) && !this.postEvent(livingEntity)) {
            this.castType.onCast(stack, livingEntity, world, SpellRecipeUtil.getAugments(this.spell_recipe, 0, livingEntity));
        }
    }

    public void onCastOnBlock(BlockRayTraceResult blockRayTraceResult, LivingEntity caster) {
        if (this.canCast(caster) && !this.postEvent(caster)) {
            this.castType.onCastOnBlock(blockRayTraceResult, caster, SpellRecipeUtil.getAugments(this.spell_recipe, 0, caster));
        }
    }

    public void onCastOnBlock(ItemUseContext context) {
        if (this.canCast((LivingEntity)context.func_195999_j()) && !this.postEvent((LivingEntity)context.func_195999_j())) {
            this.castType.onCastOnBlock(context, SpellRecipeUtil.getAugments(this.spell_recipe, 0, (LivingEntity)context.func_195999_j()));
        }
    }

    public void onCastOnEntity(ItemStack stack, LivingEntity playerIn, LivingEntity target, Hand hand) {
        if (this.canCast(playerIn) && !this.postEvent(playerIn)) {
            this.castType.onCastOnEntity(stack, playerIn, target, hand, SpellRecipeUtil.getAugments(this.spell_recipe, 0, playerIn));
        }
    }

    public void onResolveEffect(World world, LivingEntity shooter, RayTraceResult result) {
        SpellResolver.resolveEffects(world, shooter, result, this.spell_recipe, this.spellContext);
    }

    public static void resolveEffects(World world, LivingEntity shooter, RayTraceResult result, List<AbstractSpellPart> spell_recipe, SpellContext spellContext) {
        spellContext.resetSpells();
        shooter = SpellResolver.getUnwrappedCaster(world, shooter, spellContext);
        for (int i = 0; i < spell_recipe.size() && !spellContext.isCanceled(); ++i) {
            AbstractSpellPart spell = spellContext.nextSpell();
            if (!(spell instanceof AbstractEffect)) continue;
            ((AbstractEffect)spell).onResolve(result, world, shooter, SpellRecipeUtil.getAugments(spell_recipe, i, shooter), spellContext);
        }
    }

    public static LivingEntity getUnwrappedCaster(World world, LivingEntity shooter, SpellContext spellContext) {
        if (shooter == null && spellContext.castingTile != null) {
            shooter = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
            BlockPos pos = spellContext.castingTile.func_174877_v();
            shooter.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }
        shooter = shooter == null ? FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world)) : shooter;
        return shooter;
    }

    public boolean wouldAllEffectsDoWork(RayTraceResult result, World world, LivingEntity entity, List<AbstractAugment> augments) {
        for (AbstractSpellPart spellPart : this.spell_recipe) {
            if (!(spellPart instanceof AbstractEffect) || ((AbstractEffect)spellPart).wouldSucceed(result, world, entity, augments)) continue;
            return false;
        }
        return true;
    }

    public boolean wouldCastSuccessfully(@Nullable ItemStack stack, LivingEntity caster, World world, List<AbstractAugment> augments) {
        return this.castType.wouldCastSuccessfully(stack, caster, world, augments);
    }

    public boolean wouldCastOnBlockSuccessfully(ItemUseContext context, List<AbstractAugment> augments) {
        return this.castType.wouldCastOnBlockSuccessfully(context, augments);
    }

    public boolean wouldCastOnBlockSuccessfully(BlockRayTraceResult blockRayTraceResult, LivingEntity caster) {
        return this.castType.wouldCastOnBlockSuccessfully(blockRayTraceResult, caster, SpellRecipeUtil.getAugments(this.spell_recipe, 0, caster));
    }

    public boolean wouldCastOnEntitySuccessfully(@Nullable ItemStack stack, LivingEntity caster, LivingEntity target, Hand hand, List<AbstractAugment> augments) {
        return this.castType.wouldCastOnEntitySuccessfully(stack, caster, target, hand, augments);
    }

    public void expendMana(LivingEntity entity) {
        int totalCost = ManaUtil.getCastingCost(this.spell_recipe, entity);
        ManaCapability.getMana(entity).ifPresent(mana -> mana.removeMana(totalCost));
    }
}

