/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class BlockUtil {
    public static boolean containsStateInRadius(World world, BlockPos start, int radius, Class clazz) {
        for (double x = (double)(start.func_177958_n() - radius); x <= (double)(start.func_177958_n() + radius); x += 1.0) {
            for (double y = (double)(start.func_177956_o() - radius); y <= (double)(start.func_177956_o() + radius); y += 1.0) {
                for (double z = (double)(start.func_177952_p() - radius); z <= (double)(start.func_177952_p() + radius); z += 1.0) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (pos.equals((Object)start) || !world.func_180495_p(pos).func_177230_c().getClass().equals(clazz)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static double distanceFrom(BlockPos start, BlockPos end) {
        return Math.sqrt(Math.pow(start.func_177958_n() - end.func_177958_n(), 2.0) + Math.pow(start.func_177956_o() - end.func_177956_o(), 2.0) + Math.pow(start.func_177952_p() - end.func_177952_p(), 2.0));
    }

    public static boolean destroyBlockSafely(World world, BlockPos pos, boolean dropBlock, LivingEntity caster) {
        PlayerEntity playerEntity;
        if (!(world instanceof ServerWorld)) {
            return false;
        }
        Object object = playerEntity = caster instanceof PlayerEntity ? (PlayerEntity)caster : FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
        if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, world.func_180495_p(pos), playerEntity))) {
            return false;
        }
        return world.func_175655_b(pos, dropBlock);
    }

    public static boolean destroyRespectsClaim(LivingEntity caster, World world, BlockPos pos) {
        PlayerEntity playerEntity = caster instanceof PlayerEntity ? (PlayerEntity)caster : FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
        return !MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, world.func_180495_p(pos), playerEntity));
    }

    public static void safelyUpdateState(World world, BlockPos pos, BlockState state) {
        if (!World.func_189509_E((BlockPos)pos)) {
            world.func_184138_a(pos, state, state, 3);
        }
    }

    public static void safelyUpdateState(World world, BlockPos pos) {
        BlockUtil.safelyUpdateState(world, pos, world.func_180495_p(pos));
    }

    public static boolean destroyBlockSafelyWithoutSound(World world, BlockPos pos, boolean dropBlock) {
        return BlockUtil.destroyBlockWithoutSound(world, pos, dropBlock, null);
    }

    public static boolean destroyBlockSafelyWithoutSound(World world, BlockPos pos, boolean dropBlock, @Nullable LivingEntity caster) {
        PlayerEntity playerEntity;
        if (!(world instanceof ServerWorld)) {
            return false;
        }
        Object object = playerEntity = caster instanceof PlayerEntity ? (PlayerEntity)caster : FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world));
        if (MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(world, pos, world.func_180495_p(pos), playerEntity))) {
            return false;
        }
        return BlockUtil.destroyBlockWithoutSound(world, pos, dropBlock);
    }

    private static boolean destroyBlockWithoutSound(World world, BlockPos pos, boolean dropBlock) {
        return BlockUtil.destroyBlockWithoutSound(world, pos, dropBlock, null);
    }

    private static boolean destroyBlockWithoutSound(World world, BlockPos pos, boolean isMoving, @Nullable Entity entityIn) {
        BlockState blockstate = world.func_180495_p(pos);
        if (blockstate.isAir((IBlockReader)world, pos)) {
            return false;
        }
        IFluidState ifluidstate = world.func_204610_c(pos);
        if (isMoving) {
            TileEntity tileentity = blockstate.hasTileEntity() ? world.func_175625_s(pos) : null;
            Block.func_220054_a((BlockState)blockstate, (World)world, (BlockPos)pos, (TileEntity)tileentity, (Entity)entityIn, (ItemStack)ItemStack.field_190927_a);
        }
        return world.func_180501_a(pos, ifluidstate.func_206883_i(), 3);
    }
}

