/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import com.hollingsworth.arsnouveau.api.event.ManaRegenCalcEvent;
import com.hollingsworth.arsnouveau.api.event.MaxManaCalcEvent;
import com.hollingsworth.arsnouveau.api.mana.IManaEquipment;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.api.util.SpellRecipeUtil;
import com.hollingsworth.arsnouveau.common.armor.MagicArmor;
import com.hollingsworth.arsnouveau.common.block.tile.ManaJarTile;
import com.hollingsworth.arsnouveau.common.capability.ManaCapability;
import com.hollingsworth.arsnouveau.common.enchantment.EnchantmentRegistry;
import com.hollingsworth.arsnouveau.common.entity.EntityFollowProjectile;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ManaUtil {
    public static int getRecipeCost(List<AbstractSpellPart> recipe) {
        int cost = 0;
        for (int i = 0; i < recipe.size(); ++i) {
            AbstractSpellPart spell = recipe.get(i);
            if (spell instanceof AbstractAugment) continue;
            List<AbstractAugment> augments = SpellRecipeUtil.getAugments(recipe, i, null);
            cost += spell.getAdjustedManaCost(augments);
        }
        return cost;
    }

    public static int getPlayerDiscounts(LivingEntity e) {
        AtomicInteger discounts = new AtomicInteger();
        CuriosUtil.getAllWornItems(e).ifPresent(items -> {
            for (int i = 0; i < items.getSlots(); ++i) {
                Item item = items.getStackInSlot(i).func_77973_b();
                if (!(item instanceof IManaEquipment)) continue;
                discounts.addAndGet(((IManaEquipment)item).getManaDiscount());
            }
        });
        return discounts.get();
    }

    public static int getCastingCost(List<AbstractSpellPart> recipe, LivingEntity e) {
        int cost = ManaUtil.getRecipeCost(recipe) - ManaUtil.getPlayerDiscounts(e);
        return Math.max(cost, 0);
    }

    public static int getMaxMana(PlayerEntity e) {
        AtomicInteger max = new AtomicInteger(100);
        e.func_184209_aF().forEach(i -> {
            if (i.func_77973_b() instanceof IManaEquipment) {
                max.addAndGet(((IManaEquipment)i.func_77973_b()).getMaxManaBoost());
            }
            max.addAndGet(25 * EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.MANA_BOOST_ENCHANTMENT, (ItemStack)i));
        });
        CuriosUtil.getAllWornItems((LivingEntity)e).ifPresent(items -> {
            for (int i = 0; i < items.getSlots(); ++i) {
                Item item = items.getStackInSlot(i).func_77973_b();
                if (!(item instanceof IManaEquipment)) continue;
                max.addAndGet(((IManaEquipment)item).getMaxManaBoost());
            }
        });
        ManaCapability.getMana((LivingEntity)e).ifPresent(mana -> {
            int tier = mana.getBookTier();
            int numGlyphs = mana.getGlyphBonus() > 5 ? mana.getGlyphBonus() - 5 : 0;
            max.addAndGet(numGlyphs * 15);
            max.addAndGet(tier * 50);
        });
        MaxManaCalcEvent event = new MaxManaCalcEvent((LivingEntity)e, max.get());
        MinecraftForge.EVENT_BUS.post((Event)event);
        max.set(event.getMax());
        return max.get();
    }

    public static int getManaRegen(PlayerEntity e) {
        AtomicInteger regen = new AtomicInteger(5);
        for (ItemStack i : e.func_184209_aF()) {
            if (i.func_77973_b() instanceof MagicArmor) {
                MagicArmor armor = (MagicArmor)i.func_77973_b();
                regen.addAndGet(armor.getManaRegenBonus());
            }
            regen.addAndGet(2 * EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.MANA_REGEN_ENCHANTMENT, (ItemStack)i));
        }
        CuriosUtil.getAllWornItems((LivingEntity)e).ifPresent(items -> {
            int newregen = regen.get();
            for (int i = 0; i < items.getSlots(); ++i) {
                Item item = items.getStackInSlot(i).func_77973_b();
                if (!(item instanceof IManaEquipment)) continue;
                newregen += ((IManaEquipment)item).getManaRegenBonus();
            }
            regen.set(newregen);
        });
        ManaCapability.getMana((LivingEntity)e).ifPresent(mana -> {
            int tier = mana.getBookTier();
            int numGlyphs = mana.getGlyphBonus() > 5 ? mana.getGlyphBonus() - 5 : 0;
            regen.addAndGet(numGlyphs / 3);
            regen.addAndGet(tier);
        });
        ManaRegenCalcEvent event = new ManaRegenCalcEvent((LivingEntity)e, regen.get());
        MinecraftForge.EVENT_BUS.post((Event)event);
        regen.set(event.getRegen());
        return regen.get();
    }

    @Nullable
    public static BlockPos takeManaNearby(BlockPos pos, World world, int range, int mana) {
        BlockPos[] pos1 = new BlockPos[]{null};
        BlockPos.func_218281_b((BlockPos)pos.func_177982_a(range, range, range), (BlockPos)pos.func_177982_a(-range, -range, -range)).forEach(blockPos -> {
            blockPos = blockPos.func_185334_h();
            if (pos1[0] == null && world.func_175625_s(blockPos) instanceof ManaJarTile && ((ManaJarTile)world.func_175625_s(blockPos)).getCurrentMana() >= mana) {
                ((ManaJarTile)world.func_175625_s(blockPos)).removeMana(mana);
                pos1[0] = blockPos;
            }
        });
        return pos1[0];
    }

    public static BlockPos takeManaNearbyWithParticles(BlockPos pos, World world, int range, int mana) {
        BlockPos result = ManaUtil.takeManaNearby(pos, world, range, mana);
        if (result != null) {
            EntityFollowProjectile aoeProjectile = new EntityFollowProjectile(world, result, pos);
            world.func_217376_c((Entity)aoeProjectile);
        }
        return result;
    }

    @Nullable
    public static boolean hasManaNearby(BlockPos pos, World world, int range, int mana) {
        boolean[] hasMana = new boolean[]{false};
        BlockPos.func_218281_b((BlockPos)pos.func_177982_a(range, range, range), (BlockPos)pos.func_177982_a(-range, -range, -range)).forEach(blockPos -> {
            blockPos = blockPos.func_185334_h();
            if (!hasMana[0] && world.func_175625_s(blockPos) instanceof ManaJarTile && ((ManaJarTile)world.func_175625_s(blockPos)).getCurrentMana() >= mana) {
                hasMana[0] = true;
            }
        });
        return hasMana[0];
    }
}

